/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.common.Scope;
import ebuild.core.ActionQueue;
import ebuild.core.BuildPlan;
import ebuild.core.CElement;
import ebuild.core.Component;
import ebuild.core.ComponentCDependencies;
import ebuild.core.ComponentProjectHelper;
import ebuild.core.EBuildContext;
import ebuild.core.EBuildRunner;
import ebuild.core.Element;
import ebuild.core.Module;
import ebuild.core.ModuleBuildPlan;
import ebuild.core.conf.ConfExpr;
import ebuild.core.conf.ConfMapping;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.CEKey;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.EKey;
import ebuild.core.impl.Task;
import ebuild.core.util.EBuildException;
import ebuild.util.CollectionUtil;
import ebuild.util.tuple.Pair;
import ebuild.util.tuple.Triple;
import ebuild.xml.ComponentXml;
import ebuild.xml.Xml;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentBuildPlan
extends BuildPlan {
    final Component component;
    final EBuildContext context;
    private final CElement cElement;
    private final Map<String, BuildPlan> subPlans = new LinkedHashMap<String, BuildPlan>();

    public ComponentBuildPlan(EBuildRunner runner, CElement<Component> cComponent) throws EBuildException {
        super(runner, cComponent.key);
        this.component = (Component)cComponent.element;
        if (!this.component.isSource()) {
            throw EBuildException.newProblem("Non-source components not currently supported");
        }
        this.context = this.component.getProjectHelper().context;
        this.cElement = cComponent;
    }

    public ConfSet getConf() {
        return this.cElement.getConfiguration();
    }

    @Override
    public CEKey getKey() {
        return (CEKey)super.getKey();
    }

    public CElement expectLoneCPart() {
        return this.cElement;
    }

    @Override
    protected void resolveAndConfigure_(Scope scope, Scope builderScope) throws EBuildException {
        this.report.startResolveMain();
        this.resolveDependencies();
        this.report.endResolveMain();
        for (BuildPlan bp : this.subPlans.values()) {
            bp.resolveAndConfigure(scope, builderScope);
        }
        ComponentCDependencies deps = this.newCDependencies();
        this.cElement.setDependencies(deps);
    }

    @Override
    protected Collection<CElement> gatherReleases() throws EBuildException {
        return CollectionUtil.singletonList(this.cElement);
    }

    void resolveDependencies() throws EBuildException {
        EBuildContext.start(this.context);
        try {
            ComponentProjectHelper phelper = this.component.getProjectHelper();
            this.resolveContext(phelper);
            Map<String, Component.ModuleSelectionIncludes> moduleSelections = this.component.getModuleSelectionXml(this.cElement.getConfiguration());
            for (String k : moduleSelections.keySet()) {
                HashMap<Module, Triple<ConfExpr, ConfMapping, Boolean>> delements = new HashMap<Module, Triple<ConfExpr, ConfMapping, Boolean>>();
                Component.ModuleSelectionIncludes includes = moduleSelections.get(k);
                for (ComponentXml.Include d : includes.includes) {
                    String source;
                    if (!EBuildUtil.evaluateConfExpr(d.confs, this.getConf()) || "system".equals(source = d.source) || "checkedin".equals(source)) continue;
                    EKey dkey = this.context.newModuleKey(d);
                    Module delement = (Module)this.resolveElement(this.context, source, dkey);
                    ConfExpr confExpr = EBuildUtil.parseConfExpr(d.confs);
                    ConfMapping mapping = EBuildUtil.parseMapping(d.mapping);
                    delements.put(delement, new Triple<ConfExpr, ConfMapping, Boolean>(confExpr, mapping, d.dependencies));
                }
                Pair<CEKey, String> key = new Pair<CEKey, String>(this.getKey(), k);
                BuildPlan subPlan = this.runner.buildPlans.get(key);
                if (subPlan == null) {
                    ConfMapping groupMapping = EBuildUtil.parseMapping(includes.groupMapping);
                    ConfSet groupConfs = groupMapping.select(this.getConf());
                    subPlan = new ModuleBuildPlan(this.runner, key, this.getConf(), delements, groupConfs);
                    this.report.addPlan(subPlan);
                }
                this.subPlans.put(k, subPlan);
            }
            Map<String, Xml.SelectAndMap> components = this.component.getSelectedComponentsXml(this.getConf());
            for (String k : components.keySet()) {
                Xml.SelectAndMap d = components.get(k);
                EKey dkey = this.context.newElementKey(ElementType.component, d);
                Component delement = (Component)this.resolveElement(this.context, d.source, dkey);
                ConfMapping mapping = EBuildUtil.parseMapping(d.mapping, ConfMapping.EMPTY);
                ConfSet dconf = mapping.select(this.getConf());
                CEKey cekey = new CEKey(delement.key, dconf);
                BuildPlan subPlan = this.runner.buildPlans.get(cekey);
                if (subPlan == null) {
                    subPlan = new ComponentBuildPlan(this.runner, delement.getCPart(dconf));
                    this.report.addPlan(subPlan);
                    this.report.configure(delement.key, dconf);
                }
                this.subPlans.put(k, subPlan);
            }
        }
        finally {
            EBuildContext.end();
        }
    }

    ComponentCDependencies newCDependencies() throws EBuildException {
        EBuildContext.start(this.context);
        try {
            ComponentCDependencies r = new ComponentCDependencies();
            for (String k : this.subPlans.keySet()) {
                BuildPlan bp = this.subPlans.get(k);
                if (bp instanceof ModuleBuildPlan) {
                    ModuleBuildPlan mbp = (ModuleBuildPlan)bp;
                    Collection<CElement> mods = mbp.getPrimaryModules();
                    r.addModuleSelection(new ComponentCDependencies.ModuleSelectionDep(k, mods, mbp.excludeDependencies));
                    continue;
                }
                ComponentBuildPlan cbp = (ComponentBuildPlan)bp;
                r.addComponent(new ComponentCDependencies.ComponentDep(k, cbp.cElement));
            }
            ComponentCDependencies componentCDependencies = r;
            return componentCDependencies;
        }
        finally {
            EBuildContext.end();
        }
    }

    @Override
    protected void resolveBuilders(Scope scope) throws EBuildException {
        this.resolveBuildersForPart(this.cElement);
    }

    @Override
    protected void buildActionList_(ActionQueue queue, Task task) throws Exception {
        if (!((Element)this.cElement.element).isWorkspace()) {
            if (task == Task.eclipse_setup) {
                task = Task.build_release;
            } else if (task == Task.eclipse_unsetup) {
                return;
            }
        }
        for (BuildPlan subPlan : this.subPlans.values()) {
            subPlan.buildActionList(queue, task);
        }
        this.buildActionListForPart(queue, task, this.cElement);
    }
}

