/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.repo.AbstractWorkingCopy;
import ebuild.api.repo.IRepository;
import ebuild.core.BuilderInstance;
import ebuild.core.EBuild;
import ebuild.core.Element;
import ebuild.core.ElementResolver;
import ebuild.core.RepositoryContext;
import ebuild.core.RepositoryRef;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.EKey;
import ebuild.core.impl.Version;
import ebuild.core.util.EBuildException;
import ebuild.core.util.ExceptionContext;
import ebuild.core.util.PObject;
import ebuild.util.FileUtil;
import ebuild.util.JSONUtil;
import ebuild.util.ObjectUtil;
import ebuild.util.tuple.Pair;
import ebuild.xml.Xml;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EBuildContext
extends ExceptionContext {
    private static final int REPOSITORIES = 0;
    private static final int BUILDERS = 1;
    private static final int SIZE = 2;
    private final PObject[] pobjs = new PObject[2];
    final ElementResolver resolver;
    public final Element element;
    final Type type;
    private List<EBuildContext> parents;
    private boolean inited;
    private Map<Pair<String, EKey>, Element> resolvedElements;
    private Map<String, String> upstreamRevisions;

    private EBuildContext(ElementResolver resolver, Element element, Type type) {
        int i = 0;
        while (i < 2) {
            this.pobjs[i] = new PObject();
            ++i;
        }
        this.parents = new LinkedList<EBuildContext>();
        this.inited = false;
        this.resolvedElements = new HashMap<Pair<String, EKey>, Element>();
        this.resolver = resolver;
        this.element = element;
        this.type = type;
    }

    public EBuildContext(ElementResolver resolver) {
        this(resolver, null, Type.builtin);
    }

    public EBuildContext(Element element, Type type) {
        this(element.resolver, element, type);
    }

    @Override
    public String getExceptionPreface() {
        return this.element == null ? "" : String.valueOf(this.element.toString()) + "\n";
    }

    public boolean isInited() {
        return this.inited;
    }

    public void init() {
        this.inited = true;
    }

    public void addParents(EBuildContext ... parentContexts) {
        EBuildContext[] eBuildContextArray = parentContexts;
        int n = parentContexts.length;
        int n2 = 0;
        while (n2 < n) {
            EBuildContext parentContext = eBuildContextArray[n2];
            this.parents.add(parentContext);
            ++n2;
        }
        int i = 0;
        while (i < 2) {
            PObject[] prototypes = new PObject[parentContexts.length];
            int j = 0;
            EBuildContext[] eBuildContextArray2 = parentContexts;
            int n3 = parentContexts.length;
            int n4 = 0;
            while (n4 < n3) {
                EBuildContext parentContext = eBuildContextArray2[n4];
                prototypes[j] = parentContext.pobjs[i];
                ++j;
                ++n4;
            }
            this.pobjs[i].addPrototypes(prototypes);
            ++i;
        }
        this.inited = true;
    }

    public BuilderInstance getBuilder(String id) {
        return (BuilderInstance)this.pobjs[1].get(id);
    }

    public void addBuilder(String id, BuilderInstance value) {
        this.pobjs[1].put(id, value);
    }

    public RepositoryRef getRepository(String key) {
        return (RepositoryRef)this.pobjs[0].get(key);
    }

    public void addRepository(RepositoryRef value) {
        this.pobjs[0].put(value.name, value);
    }

    public RepositoryRef addRepository(String name, final IRepository repository, String defaultOrg) {
        RepositoryRef repoRef = new RepositoryRef(this, name, defaultOrg){

            protected IRepository locateRepository() {
                return repository;
            }
        };
        this.addRepository(repoRef);
        return repoRef;
    }

    public void addRepository(Xml.Repository repoXml) throws EBuildException {
        if (repoXml.ref != null) {
            final RepositoryRef prototype = this.getRepository(repoXml.ref);
            RepositoryRef instance = new RepositoryRef(this, repoXml.name){

                protected IRepository locateRepository() {
                    return prototype.locateRepository();
                }
            };
            instance.setDefaultOrg(ObjectUtil.coalesce(repoXml.org, prototype.getDefaultOrg()));
            instance.setDefaultVersion(ObjectUtil.coalesce(EBuildUtil.asVersion(repoXml), prototype.getDefaultVersion()));
            this.addRepository(instance);
        } else {
            IRepository repo = ((EBuild)this.resolver).getRepository(repoXml.type, repoXml.url);
            this.addRepository(repoXml.name, repo, repoXml.org);
        }
    }

    public RepositoryRef lookupRepository(String source) throws EBuildException {
        if ("system".equals(source)) {
            return null;
        }
        RepositoryRef repo = this.getRepository(source);
        if (repo == null) {
            if (!this.isInited()) {
                throw new Error("!" + this + " " + source);
            }
            throw EBuildException.newProblem("Bad source, no repository defined in scope '" + this + "'for '" + source + "'");
        }
        return repo;
    }

    public EKey newModuleKey(Xml.SelectWithSource select) throws EBuildException {
        return this.newElementKey(ElementType.module, select);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EKey newElementKey(ElementType type, Xml.SelectWithSource select) throws EBuildException {
        String universe;
        String source = select.source;
        String name = select.name;
        if (source == null) {
            throw new Error("'source' not set: " + select);
        }
        if (name == null) {
            throw new Error("'name' not set: " + select);
        }
        boolean local = "local".equals(select.source);
        String org = select.org;
        Version version = EBuildUtil.asVersion(select);
        EKey ourKey = this.element.key;
        if (local) {
            universe = ourKey.universe;
            if (version == null) {
                Version ourV = ourKey.version;
                if (ourV.isWorking()) {
                    AbstractWorkingCopy wc = this.element.getWorkingCopy();
                    String branch = "trunk";
                    if (wc != null) {
                        branch = wc.getBranch();
                    }
                    version = Version.newRevision(branch, "head");
                } else {
                    version = ourV.isTag() ? (ourV.hasTagSub() ? ourV.withoutTagSub() : ourV) : ourV;
                }
            }
        } else {
            RepositoryRef repoRef = this.lookupRepository(select.source);
            if (repoRef == null) {
                if (!"system".equals(source)) throw EBuildException.newProblem("Unknown source: " + source);
                universe = source;
            } else {
                universe = repoRef.getUniverse();
                if (org == null) {
                    org = repoRef.getDefaultOrg();
                }
                if (version == null) {
                    version = repoRef.getDefaultVersion();
                }
            }
        }
        if (org == null) {
            org = ourKey.org;
        }
        if (version != null) return new EKey(type, universe, org, name, version);
        version = Version.TRUNK_HEAD;
        return new EKey(type, universe, org, name, version);
    }

    public Element resolveElement(String source, EKey dkey) throws EBuildException {
        Pair<String, EKey> key = new Pair<String, EKey>(source, dkey);
        Element r = this.resolvedElements.get(key);
        if (r == null) {
            r = this.resolveElement_(source, dkey);
            this.resolvedElements.put(key, r);
        }
        return r;
    }

    private Element resolveLibraryPart(RepositoryRef repoRef, EKey key) throws EBuildException {
        return this.resolver.resolveLibraryPart(repoRef, key);
    }

    private Element resolveElement_(String source, EKey dkey) throws EBuildException {
        RepositoryRef repoRef = this.lookupRepository(source);
        if (dkey.version.isMoving()) {
            return this.resolveMoving(repoRef, dkey);
        }
        return this.resolveLibraryPart(repoRef, dkey);
    }

    private Element resolveMoving(RepositoryRef repoRef, EKey dkey) throws EBuildException {
        boolean local = "local".equals(repoRef.name);
        RepositoryContext repoContext = repoRef.getContext();
        RepositoryContext.Source srepoContext = null;
        if (repoContext instanceof RepositoryContext.Source) {
            srepoContext = (RepositoryContext.Source)repoContext;
        }
        if (this.element == null || this.element.isWorkspace()) {
            String revision;
            Element we = this.resolver.resolveWorkspaceElement(dkey);
            if (we != null) {
                if (!local) {
                    if (srepoContext != null && srepoContext.context.element.isWorkspace()) {
                        srepoContext.setFixedRevisionToWorkspace(this, dkey);
                        return we;
                    }
                } else {
                    return we;
                }
            }
            if (srepoContext == null) {
                throw EBuildException.newProblem("Repository '" + repoRef.name + "' does not support head versions: " + dkey);
            }
            if (!local) {
                revision = srepoContext.getUpdatedFixedRevision(this, dkey);
            } else {
                if (srepoContext.getRepository() == null) {
                    throw EBuildException.newProblem("'" + this.element.key + "' not connected to a repository, and cannot resolve local depondency '" + dkey + "' in the workspace");
                }
                revision = EBuildUtil.getHeadRevision(srepoContext.getRepository());
            }
            Version v2 = dkey.version.withRevision(revision);
            EKey dkey2 = dkey.withVersion(v2);
            return this.resolveLibraryPart(repoRef, dkey2);
        }
        String revision = !local ? srepoContext.expectFixedRevision() : this.element.key.version.getRevision();
        Version v2 = dkey.version.withRevision(revision);
        EKey dkey2 = dkey.withVersion(v2);
        return this.resolveLibraryPart(repoRef, dkey2);
    }

    private File getUpstreamRevisionsFile() {
        File metaDir = this.element.getMetaDirectory();
        File old = new File(metaDir, "upstream.revisions");
        if (old.exists()) {
            return old;
        }
        String filename = String.valueOf(FileUtil.removeSuffix(this.filename())) + ".revisions";
        return new File(metaDir, filename);
    }

    private Map<String, String> readUpstreamRevisions() {
        File f = this.getUpstreamRevisionsFile();
        if (!f.exists()) {
            return new HashMap<String, String>();
        }
        try {
            return JSONUtil.readMap(new FileReader(f));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public Map<String, String> getUpstreamRevisions() {
        if (this.upstreamRevisions == null) {
            this.upstreamRevisions = this.readUpstreamRevisions();
        }
        return this.upstreamRevisions;
    }

    public void updateUpstreamRevisions(Map<String, String> upstreamRevisions) {
        this.upstreamRevisions = upstreamRevisions;
        File f = this.getUpstreamRevisionsFile();
        try {
            JSONUtil.writeObject(new FileWriter(f), upstreamRevisions);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to write: " + f, e);
        }
    }

    public int hashCode() {
        return ObjectUtil.hashOf(this.element) + ObjectUtil.hashOf((Object)this.type);
    }

    public boolean equals(Object obj) {
        EBuildContext b = (EBuildContext)obj;
        return ObjectUtil.areEqual(this.element, b.element) && ObjectUtil.areEqual((Object)this.type, (Object)b.type);
    }

    public String filename() {
        switch (this.type) {
            case main: {
                return EBuildUtil.elementType2xmlName(this.element.getType());
            }
            case build: {
                return EBuildUtil.elementType2buildXmlName(this.element.getType());
            }
            case builtin: {
                return "<builtin>";
            }
        }
        throw new Error("!");
    }

    public String toString() {
        return this.element + "," + this.filename();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        builtin,
        main,
        build;

    }
}

