/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.Scope;
import ebuild.api.log.ILogger;
import ebuild.core.Action;
import ebuild.core.ActionQueue;
import ebuild.core.ActionStatus;
import ebuild.core.BuildPlan;
import ebuild.core.BuildResolutionReport;
import ebuild.core.CElement;
import ebuild.core.ComponentBuildPlan;
import ebuild.core.EBuild;
import ebuild.core.EBuildContext;
import ebuild.core.Element;
import ebuild.core.ModuleBuildPlan;
import ebuild.core.ModuleVersion;
import ebuild.core.impl.Task;
import ebuild.core.util.EBuildException;
import ebuild.util.StringUtil;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class EBuildRunner {
    protected final EBuild ebuild;
    protected final ILogger logger;
    final BuildResolutionReport report;
    public final ActionQueue queue = new ActionQueue();
    final Map<Object, BuildPlan> buildPlans = new LinkedHashMap<Object, BuildPlan>();

    public EBuildRunner(EBuild ebuild) {
        this.ebuild = ebuild;
        this.logger = ebuild.logger;
        this.report = BuildResolutionReport.newReport(ebuild.isVerbose());
    }

    public EBuildRunner(ClassLoader apiClassLoader, EBuild.Options options) {
        this(new EBuild(apiClassLoader, options));
    }

    public abstract void go() throws Exception;

    protected void log(String msg, boolean cond) {
        if (cond) {
            this.log(msg);
        }
    }

    protected void log(String msg) {
        this.logger.log(msg);
    }

    protected void log(Throwable t) {
        this.logger.log(t);
    }

    private void printPath(ClassLoader cl) {
        URL[] urls = ((URLClassLoader)cl).getURLs();
        int i = 0;
        while (i < urls.length) {
            this.logger.log("    " + urls[i].getFile());
            ++i;
        }
    }

    public void run() throws Exception {
        if (this.ebuild.isDEBUG()) {
            this.logger.log("system classloader path: ");
            this.printPath(ClassLoader.getSystemClassLoader());
            this.logger.log("core classloader path: ");
            this.printPath(EBuildRunner.class.getClassLoader());
        }
        try {
            try {
                this.go();
            }
            catch (EBuildException e) {
                this.log("");
                this.log("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                if (this.ebuild.isDEBUG()) {
                    this.log(e);
                } else {
                    this.log("!!! PROBLEM: " + e.getMessage());
                    this.log("!!! (" + EBuildRunner.versionCode() + ")");
                    Throwable t = EBuildException.getUnknownCause(e);
                    if (t != null) {
                        this.log(t);
                    }
                }
                this.logger.prime();
            }
        }
        finally {
            this.logger.prime();
        }
    }

    private static String versionCode() {
        if (ModuleVersion.TAG != null) {
            return ModuleVersion.TAG;
        }
        String r = "";
        if ("0.7" != null) {
            r = "0.7/";
        }
        return String.valueOf(r) + "293";
    }

    public void go(CElement cElement, Task task) throws Exception {
        this.go(this.newBuildPlan(cElement), task);
    }

    public void go(BuildPlan mainPlan, Task task) throws Exception {
        this.log("");
        this.log("");
        this.log("////////////////////////////////////");
        this.log("////// Resolve And Configure ///////");
        this.log("");
        this.resolveAndConfigure(mainPlan, task.getScope(), task.getBuilderScope());
        this.log("");
        this.log("");
        this.log("////////////////////////////");
        this.log("////// Plan Task List //////");
        this.log("");
        this.buildActionList(mainPlan, task);
        this.log("");
        this.log("");
        this.log("//////////////////////////");
        this.log("////// Execute Plan //////");
        this.log("");
        this.run(this.queue);
    }

    protected void resolveAndConfigure(BuildPlan mainPlan, Scope scope, Scope builderScope) throws Exception {
        this.report.setMainPlan(mainPlan);
        mainPlan.resolveAndConfigure(scope, builderScope);
        if (this.ebuild.isDEBUG()) {
            this.log("Build Plans");
            for (Object k : this.buildPlans.keySet()) {
                this.log("" + k);
            }
        }
    }

    protected BuildPlan newBuildPlan(CElement cElement) throws EBuildException {
        switch (((Element)cElement.element).key.type) {
            case module: {
                return new ModuleBuildPlan(this, cElement);
            }
            case component: {
                return new ComponentBuildPlan(this, cElement);
            }
        }
        throw new Error("!");
    }

    private void buildActionList(BuildPlan mainPlan, Task task) throws Exception {
        mainPlan.buildActionList(this.queue, task);
        this.queue.removeDuplicates();
        for (Action a : this.queue) {
            this.log("queued " + StringUtil.rpad(7, a.status.displayString()) + " " + a.format());
        }
    }

    private void run(ActionQueue queue) throws Exception {
        for (Action action : queue) {
            EBuildContext.start(action.element.context);
            try {
                if (action.status == ActionStatus.done && !this.ebuild.options.noSkipping) {
                    this.log("- skipping  " + action + " -");
                    this.logger.setProvisionalHeading("\n");
                    action.finish(true);
                    this.logger.setProvisionalHeading(null);
                    continue;
                }
                this.log("- executing " + action + " -");
                this.logger.setProvisionalHeading("\n");
                action.run(this.logger);
                this.logger.setProvisionalHeading(null);
            }
            finally {
                EBuildContext.end();
            }
        }
    }
}

