/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IModuleBuildProject;
import ebuild.api.IModuleRelease;
import ebuild.api.IModuleWorkspaceProject;
import ebuild.api.common.IElementKey;
import ebuild.api.common.Scope;
import ebuild.api.plugin.IPropertyMap;
import ebuild.core.BuildProject;
import ebuild.core.BuilderChain;
import ebuild.core.BuilderInstance;
import ebuild.core.CElement;
import ebuild.core.Module;
import ebuild.core.ModuleCDependencies;
import ebuild.core.ModuleCPart;
import ebuild.core.ModuleProjectHelper;
import ebuild.core.ModuleRelease;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleBuildProject
extends BuildProject<Module>
implements IModuleBuildProject {
    private final Map<String, Collection<File>> artifacts = new HashMap<String, Collection<File>>();
    private final Module module;
    private final ModuleProjectHelper helper;

    public ModuleBuildProject(CElement<Module> cElement) {
        super((CElement)cElement);
        this.module = cElement.getPart();
        this.helper = this.module.getProjectHelper();
    }

    public Collection<File> getCheckedInArtifacts(Scope s) {
        return this.getCheckedInArtifacts(s, "java.classes.jar");
    }

    public Collection<File> getCheckedInArtifacts(Scope s, String type) {
        return this.helper.getCheckedInArtifacts(this.cElement, s, type);
    }

    public String getJavaVersion() {
        return this.helper.getJavaVersion();
    }

    public boolean isWorkspace() {
        return ((Module)this.getPart()).isWorkspace();
    }

    public String getVersionString() {
        return "" + this.getVersion();
    }

    public File getSrcDirectory(Scope scope, String type) {
        return this.helper.getSrcDirectory(scope, type);
    }

    public IElementKey getKey() {
        return this.module.key;
    }

    public File getGenDirectory(Scope s, String artifactType) {
        return new File(this.getIntermediateDirectory(), "gen/" + s.getName() + "/" + artifactType);
    }

    public File getIntermediateDirectory(String uniquePath) {
        return new File(this.getIntermediateDirectory(), "int/uniquePath");
    }

    @Override
    public long releaseLastModified() {
        return FileUtil.deepLastModified(this.cElement.getReleaseDirectory());
    }

    @Override
    public ModuleCPart getCPart() {
        return (ModuleCPart)super.getCPart();
    }

    public void contributeArtifacts(String type, Collection<File> artifacts) {
        this.artifacts.put(type, artifacts);
    }

    @Override
    public void buildRun() throws Exception {
        this.getModuleRelease().getFile().mkdirs();
        ModuleProjectHelper helper = this.module.getProjectHelper();
        BuilderChain chain = this.getCPart().configureAndParameterizeBuilderChain();
        for (BuilderInstance b : chain.getBuilders()) {
            IPropertyMap props = helper.configureProperties(this, b);
            ModuleProjectHelper.AbstractBuilderArgument arg = new ModuleProjectHelper.AbstractBuilderArgument(this, b.getBuilder(), Scope.MAIN, props){

                public boolean isBuild() {
                    return true;
                }

                public boolean isFirstCall() {
                    return true;
                }

                protected File getGenDirectory(String artifactType) {
                    return ModuleBuildProject.this.getGenDirectory(this.scope, artifactType);
                }

                public File getExportDirectory(String artifactType) {
                    return new File(ModuleBuildProject.this.getModuleRelease().getFile(), String.valueOf(Scope.MAIN.getName()) + "/" + artifactType);
                }

                public CElement getCPart() {
                    return ModuleBuildProject.this.cElement;
                }

                public File getIntermediateDir(String uniquePath) {
                    return ModuleBuildProject.this.getIntermediateDirectory(uniquePath);
                }

                public File getOutputDir(String artifactType) {
                    return this.getGenDirectory(artifactType);
                }

                public IModuleBuildProject getModuleBuildProject() {
                    return ModuleBuildProject.this;
                }
            };
            helper.build(arg, b);
        }
    }

    @Override
    protected void buildEnd() throws Exception {
        super.buildEnd();
        if (this.module.pluginFile != null) {
            FileUtil.copyToDirIfNewer(this.module.pluginFile, ((Module)this.getPart()).getReleaseDirectory());
        }
    }

    public ModuleRelease getModuleRelease() {
        return (ModuleRelease)this.cElement.release;
    }

    public Collection<IModuleRelease> getDependencies(Scope scope) {
        ModuleCDependencies deps = (ModuleCDependencies)this.cElement.getDependencies();
        return deps.asCollection(scope);
    }

    public Collection<IModuleRelease> getReleasedDependencies(Scope scope) {
        return this.getDependencies(scope);
    }

    public Collection<IModuleWorkspaceProject> getWorkspaceDependencies(Scope scope) {
        return CollectionUtil.EMPTY_LIST;
    }
}

