/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.core.BuilderChain;
import ebuild.core.BuilderInstance;
import ebuild.core.CElement;
import ebuild.core.EBuildContext;
import ebuild.core.Module;
import ebuild.core.ModuleBuildProject;
import ebuild.core.ModuleCDependencies;
import ebuild.core.ModuleEclipseProject;
import ebuild.core.ModuleProjectHelper;
import ebuild.core.ModuleRelease;
import ebuild.core.Release;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.EKey;
import ebuild.core.util.EBuildException;
import ebuild.xml.Xml;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleCPart
extends CElement<Module> {
    private BuilderChain buildChain;

    public ModuleCPart(Module module, ConfSet configuration, ConfSet configurationSelected) {
        super(module, configuration, configurationSelected);
    }

    @Override
    public ModuleBuildProject newBuildProject() {
        return new ModuleBuildProject((CElement<Module>)this);
    }

    @Override
    public ModuleEclipseProject newEclipseProject() {
        return new ModuleEclipseProject((CElement<Module>)this);
    }

    @Override
    public Release newRelease() {
        return new ModuleRelease(this.getReleaseDirectory(), this);
    }

    @Override
    public Release<Module> registerRelease() throws EBuildException {
        if (this.element instanceof Module) {
            Module m = (Module)this.element;
            try {
                m.registerRelease(this);
            }
            catch (Exception e) {
                System.err.println("[WARNING] Unable to register plugin: " + e.getMessage());
            }
        }
        return super.registerRelease();
    }

    public BuilderChain getBuildChain() {
        return this.buildChain;
    }

    @Override
    public ModuleCDependencies getDependencies() {
        return (ModuleCDependencies)super.getDependencies();
    }

    public BuilderChain configureAndParameterizeBuilderChain() throws EBuildException {
        ModuleProjectHelper phelper = ((Module)this.element).getProjectHelper();
        EBuildContext bcontext = phelper.context;
        Iterable builderXmls = phelper.getBuildDependencies(this.getConfiguration());
        ArrayList<BuilderInstance> builders = new ArrayList<BuilderInstance>(builderXmls.size());
        for (Xml.Builder bXml : builderXmls) {
            BuilderInstance builder;
            String refId = bXml.refid;
            if (refId != null) {
                builder = bcontext.getBuilder(refId);
                if (builder == null) {
                    throw EBuildException.newProblem("Unknown builder refId: " + refId);
                }
            } else {
                EKey bkey = phelper.context.newModuleKey(bXml);
                Module mod = (Module)this.getDependencies().builders.get(bkey);
                builder = new BuilderInstance(mod, bXml.propertiesList);
            }
            builder.init();
            builders.add(builder);
        }
        this.buildChain = new BuilderChain(builders);
        return this.buildChain;
    }
}

