/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IModuleRelease;
import ebuild.api.common.Scope;
import ebuild.core.CElement;
import ebuild.core.Module;
import ebuild.core.ModuleCDependencies;
import ebuild.core.Release;
import ebuild.util.CollectionUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleRelease
extends Release<Module>
implements IModuleRelease {
    private final CElement<Module> cElement;

    public ModuleRelease(File dir, CElement<Module> cElement) {
        super(dir);
        this.cElement = cElement;
    }

    public File getDirectory() {
        return this.getFile();
    }

    public Collection<File> getArtifacts(Scope scope, String artifactType) {
        File export = new File(this.getFile(), String.valueOf(scope.getName()) + "/" + artifactType);
        File exportGroup = new File(this.getFile(), String.valueOf(scope.getName()) + "/" + artifactType + ".group");
        ArrayList<File> r = new ArrayList<File>();
        if (exportGroup.isDirectory()) {
            File[] files;
            File[] fileArray = files = exportGroup.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (!"COPYRIGHT.txt".equals(f.getName())) {
                    r.add(f);
                }
                ++n2;
            }
            return r;
        }
        if (export.exists()) {
            r.add(export);
        }
        return r;
    }

    public Collection<IModuleRelease> getDependencies(Scope scope) {
        if (this.cElement != null) {
            ModuleCDependencies deps = (ModuleCDependencies)this.cElement.getDependencies();
            return deps.asCollection(scope);
        }
        return CollectionUtil.EMPTY_LIST;
    }

    public void buildClassPath(Scope scope, Collection<String> elements) {
        if (this.cElement != null && ((Module)this.cElement.element).isApi()) {
            return;
        }
        for (File f : this.getArtifacts(scope, "java.classes.jar")) {
            elements.add(f.getAbsolutePath());
        }
        if (this.cElement != null) {
            ModuleCDependencies mcdeps = (ModuleCDependencies)this.cElement.getDependencies();
            mcdeps.buildClassPath(scope, elements);
        }
    }

    public String toString() {
        return "ModuleRelease: " + this.cElement;
    }
}

