/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.Scope;
import ebuild.core.ActionQueue;
import ebuild.core.BuildPlan;
import ebuild.core.CElement;
import ebuild.core.impl.Task;
import ebuild.core.run.ReleaseRunner;
import ebuild.core.util.EBuildException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseBuildPlan
extends BuildPlan {
    final ReleaseRunner runner;
    final Collection<CElement> cElements;
    private final List<BuildPlan> subPlans;

    public ReleaseBuildPlan(ReleaseRunner runner, Collection<CElement> cElements) {
        super(runner, "release");
        this.cElements = cElements;
        this.subPlans = new ArrayList<BuildPlan>(cElements.size());
        this.runner = runner;
    }

    @Override
    protected Collection<CElement> gatherReleases() throws EBuildException {
        throw new Error("Should not happen!");
    }

    @Override
    protected void resolveBuilders(Scope scope) throws EBuildException {
    }

    @Override
    protected void resolveAndConfigure_(Scope scope, Scope builderScope) throws EBuildException {
        this.report.startResolveMain();
        this.resolveDependencies();
        this.report.endResolveMain();
        for (BuildPlan bp : this.subPlans) {
            bp.resolveAndConfigure(scope, builderScope);
            this.runner.releases.addAll(bp.gatherReleases());
        }
    }

    void resolveDependencies() throws EBuildException {
        for (CElement ce : this.cElements) {
            BuildPlan subPlan = this.runner.newBuildPlan(ce);
            this.subPlans.add(subPlan);
            this.report.addPlan(subPlan);
            this.report.configure(ce.key.ekey, ce.configurationSelected);
        }
    }

    @Override
    protected void buildActionList_(ActionQueue queue, Task task) throws Exception {
        for (BuildPlan subPlan : this.subPlans) {
            subPlan.buildActionList(queue, task);
        }
    }
}

