/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.impl;

import ebuild.api.common.ElementType;
import ebuild.api.common.IElementKey;
import ebuild.api.common.IVersion;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.Version;
import ebuild.core.util.EBuildException;
import ebuild.util.ObjectUtil;
import ebuild.util.StringUtil;
import java.io.File;

public class EKey
implements IElementKey {
    public static final String UNIVERSE_PROJECT = "project";
    public static final String UNIVERSE_RELEASE = "release";
    public final ElementType type;
    public final String universe;
    public final String org;
    public final String name;
    public final Version version;

    public static EKey newWorkingKey(ElementType type, File projectDir) throws EBuildException {
        if (type == null) {
            type = EBuildUtil.determineElementType(projectDir);
        }
        return EKey.newWorkingKey_(type, projectDir.getName(), "working");
    }

    private static EKey newWorkingKey_(ElementType type, String org_name, String revision) throws EBuildException {
        String[] ss = org_name.split("-");
        if (ss.length != 2) {
            throw EBuildException.newProblem("Expected form of ebuild project directories is [org]-[name], got: " + org_name);
        }
        return EKey.newRevision(type, UNIVERSE_PROJECT, ss[0], ss[1], null, revision);
    }

    public static EKey newRevision(ElementType type, String universe, String org, String name, String branch, String revision) throws EBuildException {
        return new EKey(type, universe, org, name, Version.newRevision(branch, revision));
    }

    public static EKey newTagged(ElementType type, String universe, String org, String name, String version) throws EBuildException {
        return new EKey(type, universe, org, name, Version.newTag(version));
    }

    public static EKey newUnversioned(String universe, String org, String name) {
        return new EKey(null, universe, org, name, null);
    }

    public EKey(ElementType type, String universe, String org, String name, Version version) {
        this.type = type;
        this.universe = universe;
        this.org = org;
        this.name = name;
        this.version = version;
    }

    public EKey withOrg(String newOrg) {
        return new EKey(this.type, this.universe, newOrg, this.name, this.version);
    }

    public EKey withVersion(Version version) {
        return new EKey(this.type, this.universe, this.org, this.name, version);
    }

    public EKey withTag(String tag) {
        return this.withVersion(Version.newTag(tag));
    }

    public EKey withRevision(String revision) {
        return this.withVersion(this.version.withRevision(revision));
    }

    public EKey withType(ElementType type) {
        return new EKey(type, this.universe, this.org, this.name, this.version);
    }

    public String getDefaultWorkspaceName() {
        return String.valueOf(this.org) + "-" + this.name;
    }

    public EKey asWorking() {
        return new EKey(this.type, UNIVERSE_PROJECT, this.org, this.name, this.version.withRevision("working"));
    }

    public String fullname() {
        return String.valueOf(this.org) + "-" + this.name;
    }

    public String fullnameAndVersion() {
        String r = this.fullname();
        if (this.version != null) {
            r = String.valueOf(r) + "-" + this.version;
        }
        return r;
    }

    public String fullnameAndVersionAndUniverse() {
        String r = this.fullnameAndVersion();
        if (this.universe != null) {
            r = String.valueOf(this.universe) + "/" + r;
        }
        return r;
    }

    public String toString() {
        return String.valueOf(StringUtil.rpad(9, "" + this.type)) + " " + this.fullnameAndVersionAndUniverse();
    }

    public File getSubDirectory(File libraryDir) {
        return new File(libraryDir, this.asLibraryPath());
    }

    public String asLibraryPath() {
        if (this.version.isTag()) {
            return String.valueOf(this.fullname()) + "/" + this.version.getTag() + "/";
        }
        return String.valueOf(this.fullname()) + "/" + this.version.getBranch() + "/" + this.version.getRevision() + "/";
    }

    public int hashCode() {
        return ObjectUtil.hashOf(this.type) + ObjectUtil.hashOf(this.universe) + ObjectUtil.hashOf(this.org) + ObjectUtil.hashOf(this.name) + ObjectUtil.hashOf(this.version);
    }

    public boolean equals(Object obj) {
        EKey b = (EKey)obj;
        return ObjectUtil.areEqual(this.type, b.type) && ObjectUtil.areEqual(this.universe, b.universe) && ObjectUtil.areEqual(this.org, b.org) && ObjectUtil.areEqual(this.name, b.name) && ObjectUtil.areEqual(this.version, b.version);
    }

    public String getOrg() {
        return this.org;
    }

    public String getName() {
        return this.name;
    }

    public ElementType getType() {
        return null;
    }

    public IVersion getVersion() {
        return this.version;
    }
}

