/*
 * Decompiled with CFR 0.152.
 */
package ebuild.api.plugin;

import ebuild.api.plugin.BuildPluginProblem;
import ebuild.api.plugin.IPropertyMap;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertyMap
implements IPropertyMap {
    @Override
    public String getString(String key) {
        Object o = this.get(key);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    @Override
    public String getString(String key, String default_) {
        String r = this.getString(key);
        if (r == null) {
            return default_;
        }
        return r;
    }

    @Override
    public String expectString(String key) throws BuildPluginProblem {
        String r = this.getString(key);
        if (r == null) {
            ArrayList<String> props = new ArrayList<String>();
            for (String s : this.listKeys()) {
                props.add(s);
            }
            throw new BuildPluginProblem("Expected string property '" + key + "'. Set props: " + AbstractPropertyMap.join(",", props));
        }
        return r;
    }

    @Override
    public Boolean getBool(String key) {
        String s = this.getString(key);
        if (s == null) {
            return null;
        }
        return Boolean.parseBoolean(s);
    }

    @Override
    public boolean getBool(String key, boolean default_) {
        Boolean r = this.getBool(key);
        if (r == null) {
            return default_;
        }
        return r;
    }

    @Override
    public boolean expectBool(String key) throws BuildPluginProblem {
        Boolean r = this.getBool(key);
        if (r == null) {
            throw new BuildPluginProblem("Expected bool property '" + key + "'");
        }
        return r;
    }

    @Override
    public <E extends Enum> E getEnum(Class<E> enumClass, String key) throws BuildPluginProblem {
        Enum[] es;
        String v = this.getString(key);
        if (v == null) {
            return null;
        }
        Enum[] enumArray = es = (Enum[])enumClass.getEnumConstants();
        int n = es.length;
        int n2 = 0;
        while (n2 < n) {
            Enum e = enumArray[n2];
            if (v.equals(e.name())) {
                return (E)e;
            }
            ++n2;
        }
        throw new BuildPluginProblem("Expected one of '" + AbstractPropertyMap.join(",", enumClass.getEnumConstants()) + "', got '" + v + "' for property '" + key + "'");
    }

    @Override
    public <E extends Enum> E getEnum(Class<E> enumClass, String key, E default_) throws BuildPluginProblem {
        E r = this.getEnum(enumClass, key);
        if (r == null) {
            return default_;
        }
        return r;
    }

    @Override
    public <E extends Enum> E expectEnum(Class<E> enumClass, String key) throws BuildPluginProblem {
        E r = this.getEnum(enumClass, key);
        if (r == null) {
            throw new BuildPluginProblem("Expected one of '" + AbstractPropertyMap.join(",", enumClass.getEnumConstants()) + "' property '" + key + "'");
        }
        return r;
    }

    public static String join(String separator, Object ... os) {
        int l = 0;
        Object[] objectArray = os;
        int n = os.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            String s = o.toString();
            l += (s == null ? 4 : s.length()) + 1;
            ++n2;
        }
        StringBuffer r = new StringBuffer(l);
        Object[] objectArray2 = os;
        int n3 = os.length;
        n = 0;
        while (n < n3) {
            Object o = objectArray2[n];
            String s = o.toString();
            if (r.length() > 0) {
                r.append(separator);
            }
            r.append(s == null ? "null" : s);
            ++n;
        }
        return r.toString();
    }
}

