/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.Scope;
import ebuild.base.EBuildException;
import ebuild.core.Artifact;
import ebuild.core.EBuild;
import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.Project;
import ebuild.core.impl.BuildMode;
import ebuild.core.util.WorkMarker;
import ebuild.util.FileUtil;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BuildProject<P extends Element>
extends Project<P> {
    private File intermediateDir;
    private WorkMarker buildMarker;

    public BuildProject(ElementC elementC) {
        super(elementC);
        String confDir = this.getConfiguration().asDirectoryName();
        this.intermediateDir = new File(((Element)this.getPart()).getBuildDirectory(), confDir);
        this.buildMarker = new WorkMarker(elementC.getReleaseFile());
    }

    public boolean isProjectDirty() {
        return false;
    }

    @Override
    public BuildMode mode() {
        return BuildMode.build;
    }

    public void clean() throws Exception {
        FileUtil.deleteDir(this.getIntermediateDirectory());
        for (Artifact r : this.elementC.getReleases().values()) {
            r.delete();
        }
    }

    public boolean isClean() throws EBuildException {
        return !this.hasIntermediateDirectory() && !this.hasReleases();
    }

    public abstract long releaseLastModified();

    public boolean isDirty(Scope scope) throws EBuildException {
        if (this.isClean()) {
            return false;
        }
        if (!this.buildMarker.isComplete()) {
            return true;
        }
        if (((Element)this.getPart()).key.version.isMoving()) {
            long outputDate;
            long inputDate = this.elementC.lastModificationOfInput(scope);
            return inputDate > (outputDate = this.releaseLastModified());
        }
        return false;
    }

    public File getIntermediateDirectory() {
        return this.intermediateDir;
    }

    public boolean hasIntermediateDirectory() {
        return this.intermediateDir.exists();
    }

    public boolean hasReleases() throws EBuildException {
        for (Artifact r : this.elementC.getReleases().values()) {
            if (r.exists()) continue;
            return false;
        }
        return true;
    }

    public void build() throws Exception {
        this.buildPrep();
        this.buildRun();
        this.buildEnd();
    }

    protected void buildPrep() throws IOException {
        this.buildMarker.create();
        this.getIntermediateDirectory().mkdirs();
    }

    public abstract void buildRun() throws Exception;

    protected void buildEnd() throws Exception {
        File metaFile = ((Element)this.getPart()).getMetaMainFile();
        FileUtil.copyToDirIfNewer(metaFile, ((Element)this.getPart()).getReleaseDirectory());
        if (((Element)this.elementC.element).isWorkspace()) {
            ((Element)this.elementC.getPart()).addIgnores("build", "release");
        }
        this.buildMarker.remove();
        EBuild ebuild = ((Element)this.elementC.element).ebuild;
        if (!ebuild.options.keepIntermediates(((Element)this.elementC.element).isWorkspace())) {
            ebuild.logger.log("Removing intermediate files: " + ebuild.formatAsDisplayPath(this.getIntermediateDirectory()));
            FileUtil.deleteDir(this.getIntermediateDirectory());
        }
        this.elementC.getReleaseFile().setLastModified(System.currentTimeMillis());
    }
}

