/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.core.Artifact;
import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.util.WorkMarker;
import ebuild.util.FileUtil;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementReleaseArtifact<P extends Element>
implements Artifact {
    public final ElementC<P> elementC;
    public final String artifact;
    private final WorkMarker workMarker;

    public ElementReleaseArtifact(ElementC elementC, String artifact, WorkMarker workMarker) {
        this.elementC = elementC;
        this.artifact = artifact;
        this.workMarker = workMarker;
    }

    @Override
    public String getName() {
        return this.artifact;
    }

    @Override
    public ElementC getElementC() {
        return this.elementC;
    }

    @Override
    public abstract File[] getRoots();

    public WorkMarker getWorkMarker() {
        return this.workMarker;
    }

    @Override
    public boolean exists() {
        File[] fileArray = this.getRoots();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.exists()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void delete() {
        File[] fileArray = this.getRoots();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            FileUtil.deleteDir(f);
            ++n2;
        }
    }
}

