/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.Scope;
import ebuild.base.Backtrace;
import ebuild.base.EBuildException;
import ebuild.core.ActionQueue;
import ebuild.core.BuildPlan;
import ebuild.core.EBuild;
import ebuild.core.EBuildContextOfXml;
import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.Module;
import ebuild.core.ModuleC;
import ebuild.core.ModuleCDep;
import ebuild.core.ModuleDeps;
import ebuild.core.Product;
import ebuild.core.ProductC;
import ebuild.core.ProductDeps;
import ebuild.core.conf.ConfExpr;
import ebuild.core.conf.ConfMap;
import ebuild.core.conf.ConfMapping;
import ebuild.core.impl.ConfKey;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.Exclude;
import ebuild.core.impl.KeyE;
import ebuild.core.impl.Task;
import ebuild.core.impl.TaskSet;
import ebuild.xml.ModXml;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleBuildPlan
extends BuildPlan {
    private final Map<Object, Node> nodes = new HashMap<Object, Node>();
    private final SelectionNode initialNode;
    final Exclude excludeDeep;
    private ConfMap groupConfs = ConfMap.EMPTY;
    private TaskSet resolvedFor = TaskSet.NONE;
    private static final KeyE INITNODE_KEY = KeyE.newUnversioned(null, "-system-", "-dummy-");

    public ModuleBuildPlan(EBuild ebuild, ElementC<Module> cmodule) {
        this(ebuild, cmodule, Exclude.NONE);
    }

    public ModuleBuildPlan(EBuild ebuild, ElementC<Module> cmodule, Exclude excludes) {
        this(ebuild, ((Module)cmodule.element).context, cmodule.key, excludes);
        this.addModule((Module)cmodule.element, cmodule.getConfiguration(), Exclude.NONE);
    }

    public ModuleBuildPlan(EBuild ebuild, EBuildContextOfXml context, Object key, Exclude excludeDeep) {
        super(ebuild, key);
        this.initialNode = new SelectionNode(context);
        this.nodes.put(this.initialNode.key, this.initialNode);
        this.excludeDeep = excludeDeep;
    }

    public void addModule(Module m, ConfMap confs, Exclude exclude) {
        ModuleNode mnode = this.addModuleNode(m, exclude);
        ConfMapping mapping = EBuildUtil.newMapping(confs);
        this.initialNode.addEdge(new ModuleEdge(this.initialNode, mnode, m.key, ConfExpr.TRUE, Scope.MAIN, mapping, false, null));
    }

    public void setGroupConfs(ConfMap groupConfs) {
        this.groupConfs = groupConfs;
    }

    public Module expectModule() {
        return (Module)this.expectLoneCPart().element;
    }

    public ModuleC expectLoneCPart() {
        Collection<ModuleCDep> cElements = this.getPrimaryModules();
        if (cElements.size() != 1) {
            throw new Error("Expected single module, got '" + cElements.size() + ". Is plan ModuleSelection?");
        }
        return cElements.iterator().next().moduleC;
    }

    private ModuleNode addModuleNode(Module p, Exclude exclude) {
        ModuleNode r = this.addModuleNode(p.key);
        r.set(p, exclude);
        return r;
    }

    private ModuleNode addModuleNode(KeyE key) {
        ModuleNode r = (ModuleNode)this.nodes.get(key);
        if (r == null) {
            r = new ModuleNode(key);
            this.nodes.put(r.key, r);
        }
        return r;
    }

    private ProductNode addProductNode(String role) {
        ProductNode r = (ProductNode)this.nodes.get(role);
        if (r == null) {
            r = new ProductNode(role);
            this.nodes.put(r.key, r);
        }
        return r;
    }

    public Collection<ModuleCDep> getPrimaryModules() {
        Map os = this.initialNode.outgoing;
        ArrayList<ModuleCDep> r = new ArrayList<ModuleCDep>(os.size());
        for (Object ekey : os.keySet()) {
            ModuleEdge o = ((Edge)os.get(ekey)).castToModuleEdge();
            if (o == null || o.scope != Scope.MAIN) continue;
            r.add(new ModuleCDep((ModuleC)o.getNode().elementC, o.exclude));
        }
        return r;
    }

    @Override
    public void resolveAndConfigureDependencies(TaskSet tasks) throws EBuildException {
        if (this.resolvedFor.includes(tasks)) {
            return;
        }
        this.resolvedFor = this.resolvedFor.combine(tasks);
        this.initialNode.resolve(tasks);
        this.configure();
    }

    protected Collection<ElementC> gatherReleases() {
        HashSet<ElementC> r = new HashSet<ElementC>();
        for (Node n : this.nodes.values()) {
            if (!(n instanceof ModuleNode)) continue;
            ModuleNode mn = (ModuleNode)n;
            r.add(mn.elementC);
        }
        return r;
    }

    @Override
    protected void resolveBuilders(TaskSet tasks) throws EBuildException {
        this.initialNode.resolveBuilders(tasks);
    }

    Map<String, BuildPlan> collectProductPlans(TaskSet tasks) throws EBuildException {
        LinkedHashMap<String, BuildPlan> plans = new LinkedHashMap<String, BuildPlan>();
        this.initialNode.collectProductPlans(plans, tasks.getScope());
        return plans;
    }

    private void configure() throws EBuildException {
        LinkedList<Node> reverseOrder;
        block8: {
            int sizeBefore;
            int sizeAfter;
            HashSet<Node> nodes = new HashSet<Node>(this.nodes.values());
            reverseOrder = new LinkedList<Node>();
            do {
                sizeBefore = nodes.size();
                Iterator I = nodes.iterator();
                while (I.hasNext()) {
                    Node n = (Node)I.next();
                    if (n.ignore() || n.isConfigured()) {
                        I.remove();
                        continue;
                    }
                    if (!n.isConfigurable()) continue;
                    Backtrace.start("configure module", n.key);
                    try {
                        n.configure();
                    }
                    finally {
                        Backtrace.end(n.key);
                    }
                    I.remove();
                    reverseOrder.addFirst(n);
                    break;
                }
                sizeAfter = nodes.size();
                if (sizeAfter == 0) break block8;
            } while (sizeAfter != sizeBefore);
            throw EBuildException.newConfProblem("Could not configure due to cyclical dependency: " + nodes);
        }
        for (Node n : reverseOrder) {
            if (!(n instanceof ModuleNode)) continue;
            ModuleNode mn = (ModuleNode)n;
            mn.setDependencies();
        }
    }

    @Override
    protected void buildActionListForPlan(ActionQueue queue, TaskSet tasks) throws Exception {
        Map<String, BuildPlan> plans = this.collectProductPlans(tasks);
        TaskSet ptasks = tasks.with(Task.build_release);
        for (BuildPlan subplan : plans.values()) {
            subplan.buildActionList(queue, ptasks);
        }
        this.initialNode.buildActionList(queue, tasks);
    }

    private abstract class Edge {
        final KeyE dkey;
        final Node from;
        final ElementNode to;
        final String source;
        final Scope scope;
        final ConfExpr confExpr;
        final ConfMapping confMapping;
        ConfMap conf;

        Edge(Node from, ElementNode to, KeyE dkey, ConfExpr confExpr, Scope scope, ConfMapping confMapping, String source) {
            this.from = from;
            this.to = to;
            this.dkey = dkey;
            this.confExpr = confExpr;
            this.scope = scope;
            this.confMapping = confMapping;
            this.source = source;
        }

        abstract Object getKey();

        abstract void resolveTarget(EBuildContextOfXml var1) throws EBuildException;

        public ModuleEdge castToModuleEdge() {
            if (this instanceof ModuleEdge) {
                return (ModuleEdge)this;
            }
            return null;
        }

        ElementNode getNode() {
            return this.to;
        }

        public String toString() {
            return this.from.key + "->" + this.dkey;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ElementNode<K, E extends Element, EC extends ElementC>
    extends Node<K> {
        protected E element;
        protected EC elementC;

        ElementNode(ModuleBuildPlan plan, K key) {
            super(ModuleBuildPlan.this, key);
        }

        @Override
        EBuildContextOfXml getContext() {
            return ((Element)this.element).context;
        }

        @Override
        void resolve(TaskSet tasks) throws EBuildException {
            if (((Element)this.element).META.isExternal()) {
                return;
            }
            super.resolve(tasks);
        }

        @Override
        void configure() throws EBuildException {
            super.configure();
            ModuleBuildPlan.this.report.configure(((Element)this.element).key, this.conf_node);
            this.elementC = ((Element)this.element).getCPart(new ConfKey(this.conf_node));
        }
    }

    private class ModuleEdge
    extends Edge {
        final boolean subsumed;
        final String loadgroup;
        final Exclude exclude;

        ModuleEdge(Node from, ModuleNode to, KeyE dkey, ConfExpr conf, Scope scope, ConfMapping mapping, boolean subsumed, String loadgroup) {
            this(from, to, dkey, conf, scope, mapping, subsumed, loadgroup, null, Exclude.NONE);
            assert (to.element != null);
        }

        ModuleEdge(Node from, ModuleNode to, KeyE dkey, ConfExpr conf, Scope scope, ConfMapping mapping, boolean subsumed, String loadgroup, String source, Exclude exclude) {
            super(from, to, dkey, conf, scope, mapping, source);
            this.subsumed = subsumed;
            this.loadgroup = loadgroup;
            this.exclude = exclude;
            assert (exclude != null);
        }

        Object getKey() {
            return this.dkey;
        }

        ModuleNode getNode() {
            return (ModuleNode)this.to;
        }

        void resolveTarget(EBuildContextOfXml from) throws EBuildException {
            if (this.getNode().element == null) {
                Module dmodule = from.resolveModule(this.source, this.dkey);
                this.getNode().set(dmodule, this.exclude);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModuleNode
    extends ElementNode<KeyE, Module, ModuleC> {
        private boolean processed;
        private Exclude exclude;

        public ModuleNode(KeyE paramKeyE) {
            super(ModuleBuildPlan.this, paramKeyE);
            this.processed = false;
            this.exclude = Exclude.ALL;
        }

        @Override
        EBuildContextOfXml getContext() {
            return ((Module)this.element).context;
        }

        void set(Module element, Exclude exclude) {
            this.element = element;
            this.exclude = Exclude.intersection(this.exclude, exclude);
        }

        @Override
        protected boolean skipDependency(Edge o) {
            ModuleEdge me = o.castToModuleEdge();
            if (me == null) {
                return false;
            }
            return this.skipDependency((KeyE)me.getNode().key, me.subsumed);
        }

        private boolean hasSourceInput() {
            if (((Module)this.element).isSource()) {
                return true;
            }
            for (Edge o : ((ModuleBuildPlan)ModuleBuildPlan.this).initialNode.outgoing.values()) {
                ModuleEdge me = o.castToModuleEdge();
                if (!((Module)me.getNode().element).isSource()) continue;
                return true;
            }
            return false;
        }

        private boolean skipDependency(KeyE dkey, boolean subsumed) {
            if (this.hasSourceInput()) {
                return false;
            }
            if (subsumed) {
                return true;
            }
            if (this.exclude.match(dkey)) {
                return true;
            }
            return ModuleBuildPlan.this.excludeDeep.match(dkey);
        }

        private void processDependencies(EBuildContextOfXml context, boolean ignoreSubsumed) throws EBuildException {
            KeyE dkey;
            String source;
            Iterable<ModXml.Dependency> deps = ((Module)this.element).xmlOfModuleDependencies();
            for (ModXml.Dependency dependency : deps) {
                source = dependency.source;
                if ("system".equals(source) || dependency.subsumed && ignoreSubsumed) continue;
                dkey = context.newModuleKeyE(dependency);
                Scope dscope = EBuildUtil.getScope(dependency.scope, Scope.MAIN);
                ConfExpr dconfs = EBuildUtil.parseConfExpr(dependency.conf);
                Exclude dexcludes = Exclude.newExclude(dependency.excludes);
                Backtrace.start("process dependency", dkey);
                try {
                    ModuleNode dnode = ModuleBuildPlan.this.addModuleNode(dkey);
                    ConfMapping dmapping = EBuildUtil.parseMapping(dependency.confMapping, ConfMapping.EMPTY);
                    this.addEdge(new ModuleEdge(this, dnode, dkey, dconfs, dscope, dmapping, dependency.subsumed, dependency.loadgroup, source, dexcludes));
                }
                finally {
                    Backtrace.end(dkey);
                }
            }
            for (ModXml.Product product : ((Module)this.element).xmlOfProductDependencies()) {
                source = product.source;
                dkey = context.newProductKeyE(product);
                ConfExpr dconfs = EBuildUtil.parseConfExpr(product.conf);
                Backtrace.start("process dependency", dkey);
                try {
                    ProductNode dnode = ModuleBuildPlan.this.addProductNode(product.role);
                    ConfMapping dmapping = EBuildUtil.parseMapping(product.confMapping, ConfMapping.EMPTY);
                    this.addEdge(new ProductEdge(this, dnode, dkey, dconfs, Scope.MAIN, dmapping, source, product.artifact, product.role));
                }
                finally {
                    Backtrace.end(dkey);
                }
            }
        }

        @Override
        void resolveSelf(boolean ignoreSubsumed) throws EBuildException {
            if (this.processed) {
                return;
            }
            this.processed = true;
            EBuildContextOfXml context = ((Module)this.element).context.resolveSelf();
            Backtrace.start("process dependencies", context);
            try {
                this.processDependencies(context, ignoreSubsumed);
            }
            finally {
                Backtrace.end(context);
            }
        }

        @Override
        public boolean ignore() {
            return this.element == null;
        }

        public void setDependencies() throws EBuildException {
            this.setDependencies(ModuleBuildPlan.this.resolvedFor.getScope());
        }

        public void setDependencies(Scope scope) throws EBuildException {
            if (((ModuleC)this.elementC).getDependencies(scope) != null) {
                return;
            }
            Scope pscope = scope.getParent();
            ModuleDeps pdeps = null;
            if (pscope != null) {
                this.setDependencies(pscope);
                pdeps = ((ModuleC)this.elementC).getDependencies(pscope);
            }
            ModuleDeps deps = new ModuleDeps((ModuleC)this.elementC, scope, pdeps);
            this.setDependencies(scope, deps);
            ((ModuleC)this.elementC).setDependencies(scope, deps);
        }

        private void setDependencies(Scope scope, ModuleDeps deps) throws EBuildException {
            if (((Module)this.element).META.isExternal()) {
                return;
            }
            Backtrace.start("setup dependencies", ((Module)this.element).context);
            try {
                Scope dscope;
                for (Edge o : this.outgoing.values()) {
                    if (o.scope != scope || !o.confExpr.evaluate(this.conf_node) || this.skipDependency(o)) continue;
                    ModuleEdge me = o.castToModuleEdge();
                    if (me != null) {
                        ModuleC elementC = (ModuleC)me.getNode().elementC;
                        deps.addModule(new ModuleDeps.ModuleDep(o.scope, elementC, me.subsumed, me.loadgroup, me.exclude));
                        continue;
                    }
                    ProductEdge pe = (ProductEdge)o;
                    ProductC elementC = (ProductC)pe.getNode().elementC;
                    deps.addProduct(new ProductDeps.ProductDep(pe.role, elementC, pe.artifact));
                }
                ModXml.Dependencies dependenciesXml = ((Module)this.element).getMETA().expectMainXml().dependencies;
                for (ModXml.CheckedIn checkedIn : dependenciesXml.checkedIns) {
                    dscope = EBuildUtil.getScope(checkedIn.scope, Scope.MAIN);
                    if (scope != dscope || !EBuildUtil.evaluateExpr(checkedIn.conf, this.conf_node)) continue;
                    ModuleDeps moduleDeps = deps;
                    moduleDeps.getClass();
                    deps.addCheckedIn(new ModuleDeps.CheckedInDep(moduleDeps, dscope, checkedIn.name, checkedIn.type));
                }
                for (ModXml.System system : dependenciesXml.systems) {
                    dscope = EBuildUtil.getScope(system.scope, Scope.MAIN);
                    if (scope != dscope || !EBuildUtil.evaluateExpr(system.conf, this.conf_node)) continue;
                    ModuleDeps moduleDeps = deps;
                    moduleDeps.getClass();
                    deps.addSystem(new ModuleDeps.SystemDep(moduleDeps, dscope, system.name, system.tag));
                }
            }
            finally {
                Backtrace.end(((Module)this.element).context);
            }
        }

        @Override
        void resolveBuilders(TaskSet tasks) throws EBuildException {
            ModuleBuildPlan.this.resolveBuildPluginsForPart(this.elementC);
            super.resolveBuilders(tasks);
        }

        @Override
        public void buildActionListForNode(ActionQueue queue, TaskSet tasks) throws Exception {
            ModuleBuildPlan.this.buildActionListForPart(queue, this.elementC, tasks);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class Node<K> {
        final K key;
        final Set<Edge> incoming = new HashSet<Edge>();
        final Map<Object, Edge> outgoing = new LinkedHashMap<Object, Edge>();
        ConfMap conf_node = null;
        private TaskSet resolvedFor = TaskSet.NONE;

        Node(ModuleBuildPlan buildPlan, K key) {
            this.key = key;
        }

        abstract EBuildContextOfXml getContext();

        public boolean ignore() {
            return false;
        }

        protected boolean skipDependency(Edge o) {
            return false;
        }

        private boolean skipDependency(Edge o, Scope scope) {
            if (!scope.includes(o.scope)) {
                return true;
            }
            if (!o.confExpr.evaluate(this.conf_node)) {
                return true;
            }
            return this.skipDependency(o);
        }

        void addOutgoing(Edge e) {
            this.outgoing.put(e.dkey, e);
        }

        void addIncoming(Edge e) {
            this.incoming.add(e);
        }

        void addEdge(Edge e) {
            this.addOutgoing(e);
            e.to.addIncoming(e);
        }

        void resolve(TaskSet tasks) throws EBuildException {
            if (this.resolvedFor.includes(tasks)) {
                return;
            }
            this.resolvedFor = this.resolvedFor.combine(tasks);
            this.resolveSelf(!tasks.hasIDE());
            this.resolveDependencies(tasks);
        }

        void resolveSelf(boolean subsumed) throws EBuildException {
        }

        void resolveDependencies(TaskSet tasks) throws EBuildException {
            EBuildContextOfXml FROM = this.getContext();
            Scope scope = tasks.getScope();
            Backtrace.start("resolve dependencies" + (this == ModuleBuildPlan.this.initialNode ? " top" : ""), FROM);
            try {
                ModuleBuildPlan.this.report.startResolve(FROM, "module dependencies");
                ArrayList<Edge> resolved = new ArrayList<Edge>(this.outgoing.size());
                for (Edge o : this.outgoing.values()) {
                    if (!scope.includes(o.scope) || this.skipDependency(o)) continue;
                    o.resolveTarget(FROM);
                    resolved.add(o);
                }
                ModuleBuildPlan.this.report.endResolve();
                for (Edge o : resolved) {
                    o.getNode().resolve(tasks);
                }
            }
            finally {
                Backtrace.end(FROM);
            }
        }

        void resolveBuilders(TaskSet tasks) throws EBuildException {
            Backtrace.start("resolve builders", this.key);
            try {
                Scope scope = tasks.getScope();
                for (Edge o : this.outgoing.values()) {
                    if (this.skipDependency(o, scope)) continue;
                    o.getNode().resolveBuilders(tasks);
                }
            }
            finally {
                Backtrace.end(this.key);
            }
        }

        boolean isConfigured() {
            return this.conf_node != null;
        }

        boolean isConfigurable() {
            for (Edge e : this.incoming) {
                if (e.from.isConfigured()) continue;
                return false;
            }
            return true;
        }

        void configure() throws EBuildException {
            Module m;
            ConfMap.Builder builder = new ConfMap.Builder();
            for (Edge e : this.incoming) {
                if (e.conf == null) continue;
                builder.addAll(e.conf);
            }
            if (this instanceof ModuleNode && (m = (Module)((ModuleNode)this).element).isSource()) {
                builder.addAll(ModuleBuildPlan.this.groupConfs);
            }
            this.conf_node = builder.build();
            for (Edge o : this.outgoing.values()) {
                if (!o.confExpr.evaluate(this.conf_node)) continue;
                o.conf = o.confMapping.evaluate(this.conf_node);
            }
        }

        void collectProductPlans(Map<String, BuildPlan> plans, Scope scope) throws EBuildException {
            Backtrace.start("collect product plans", this.key);
            try {
                for (Edge o : this.outgoing.values()) {
                    if (this.skipDependency(o, scope)) continue;
                    o.to.collectProductPlans(plans, scope);
                }
            }
            finally {
                Backtrace.end(this.key);
            }
        }

        private TaskSet requiredTasks(ElementC elementC, TaskSet tasks) {
            if (!((Element)elementC.element).isWorkspace()) {
                tasks = tasks.replace(Task.eclipse_unsetup, Task.build_clean);
                tasks = tasks.replace(Task.eclipse_setup, Task.build_release);
            }
            return tasks;
        }

        public void buildActionListForNode(ActionQueue queue, TaskSet tasks) throws Exception {
        }

        public void buildActionList(ActionQueue queue, TaskSet tasks) throws Exception {
            Backtrace.start("plan", this.key);
            try {
                Scope scope = tasks.getScope();
                for (Edge o : this.outgoing.values()) {
                    ModuleEdge me;
                    if (this.skipDependency(o, scope) || (me = o.castToModuleEdge()) == null) continue;
                    ModuleC moduleC = (ModuleC)me.getNode().elementC;
                    TaskSet tasks2 = this.requiredTasks(moduleC, tasks);
                    me.getNode().buildActionList(queue, tasks2);
                }
                this.buildActionListForNode(queue, tasks);
            }
            finally {
                Backtrace.end(this.key);
            }
        }

        public String toString() {
            return this.key + " " + (this.conf_node == null ? "[unconfigured]" : "" + this.conf_node);
        }
    }

    private class ProductEdge
    extends Edge {
        final String role;
        final String artifact;

        ProductEdge(Node paramNode, ProductNode paramProductNode, KeyE paramKeyE, ConfExpr paramConfExpr, Scope paramScope, ConfMapping paramConfMapping, String source, String artifact, String role) {
            super(paramNode, paramProductNode, paramKeyE, paramConfExpr, paramScope, paramConfMapping, source);
            this.role = role;
            this.artifact = artifact;
        }

        Object getKey() {
            return this.role;
        }

        ProductNode getNode() {
            return (ProductNode)this.to;
        }

        void resolveTarget(EBuildContextOfXml from) throws EBuildException {
            if (this.getNode().element == null) {
                this.getNode().element = (Product)from.resolveElement(this.source, this.dkey);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProductNode
    extends ElementNode<String, Product, ProductC> {
        ProductNode(String key) {
            super(ModuleBuildPlan.this, key);
        }

        @Override
        EBuildContextOfXml getContext() {
            return ((Product)this.element).context;
        }

        @Override
        void configure() throws EBuildException {
            super.configure();
            BuildPlan subplan = ModuleBuildPlan.this.ebuild.getBuildPlan(this.elementC);
            subplan.resolveAndConfigure(TaskSet.NONE.with(Task.build_release));
        }

        @Override
        void collectProductPlans(Map<String, BuildPlan> plans, Scope scope) throws EBuildException {
            BuildPlan subplan = ModuleBuildPlan.this.ebuild.getBuildPlan(this.elementC);
            plans.put((String)this.key, subplan);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelectionNode
    extends Node<KeyE> {
        final EBuildContextOfXml context;

        SelectionNode(EBuildContextOfXml paramEBuildContextOfXml) {
            super(ModuleBuildPlan.this, INITNODE_KEY);
            this.context = paramEBuildContextOfXml;
        }

        @Override
        EBuildContextOfXml getContext() {
            return this.context;
        }
    }
}

