/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IArtifact;
import ebuild.api.IModuleBuildProject;
import ebuild.api.IModuleProject;
import ebuild.api.common.IElementKey;
import ebuild.api.common.Scope;
import ebuild.api.log.ILogger;
import ebuild.api.plugin.IPropertyMap;
import ebuild.base.EBuildLogger;
import ebuild.base.MetaType;
import ebuild.compat.IModuleProjectInCompat;
import ebuild.core.Artifact;
import ebuild.core.BuildProject;
import ebuild.core.BuilderChain;
import ebuild.core.BuilderInstance;
import ebuild.core.EBuild;
import ebuild.core.ElementC;
import ebuild.core.Module;
import ebuild.core.ModuleBuildMeta;
import ebuild.core.ModuleC;
import ebuild.core.ModuleDeps;
import ebuild.core.ModuleProjectHelper;
import ebuild.core.impl.Exclude;
import ebuild.util.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleBuildProject
extends BuildProject<Module>
implements IModuleBuildProject,
IModuleProjectInCompat {
    private final Module module;
    private final ModuleC moduleC;
    private final ModuleProjectHelper helper;

    public ModuleBuildProject(ElementC<Module> elementC) {
        super((ElementC)elementC);
        this.module = elementC.getPart();
        this.moduleC = (ModuleC)elementC;
        this.helper = this.module.getProjectHelper();
    }

    public String getJavaVersion() {
        return this.helper.getJavaVersion();
    }

    public boolean isWorkspace() {
        return ((Module)this.getPart()).isWorkspace();
    }

    @Override
    public File getSrcDirectory(Scope scope, String type) {
        return this.helper.getSrcDirectory(scope, type);
    }

    public IElementKey getKey() {
        return this.module.key;
    }

    @Override
    public Collection<File> getCheckedInArtifacts(Scope s, String type) {
        return ModuleProjectHelper.getCheckedInArtifacts(this.elementC, s, type);
    }

    public String filePrefix() {
        return String.valueOf(this.getKey().fullnameAndVersion()) + this.getConfigurationSelected().asFileTrailingPart();
    }

    public ModuleBuildMeta getMETA() {
        return this.getMETA();
    }

    public Collection<String> getLoadGroups(Scope scope) {
        return this.moduleC.getDependencies(scope).getLoadGroups();
    }

    public Collection<File> getBuildDependencies(Scope scope, String artifactType) {
        ModuleDeps deps = this.moduleC.getDependencies(scope);
        ModuleDeps.GathererOfFiles gatherer = new ModuleDeps.GathererOfFiles(true, artifactType);
        deps.doDeepGather(gatherer, new ModuleDeps.RecurseRule(){

            public boolean ignore(ModuleDeps.ModuleDep md) {
                return md.loadgroup != null;
            }
        }, Exclude.NONE);
        Set<File> artifacts = gatherer.files;
        artifacts.addAll(this.getCheckedInArtifacts(scope, artifactType));
        Artifact.Module release = this.moduleC.getRelease(artifactType);
        Scope s = scope.getParent();
        while (s != null) {
            artifacts.addAll(release.getArtifactFiles());
            s = s.getParent();
        }
        return artifacts;
    }

    public File getCorespondingBuildDependency(Scope scope, String artifactType, File artifact) {
        return null;
    }

    public Collection<File> getDependencyArtifacts(String loadgroup, String artifactType) {
        return this.getBuildArtifactDependencies(artifactType);
    }

    public Collection<File> getBuildArtifactDependencies(String artifactType) {
        ModuleDeps deps = (ModuleDeps)this.elementC.getDependencies(Scope.MAIN);
        ModuleDeps.GathererOfFiles gatherer = new ModuleDeps.GathererOfFiles(true, artifactType);
        deps.doDeepGather(gatherer, new ModuleDeps.RecurseRule(){

            public boolean ignore(ModuleDeps.ModuleDep md) {
                return md.loadgroup != null;
            }
        }, Exclude.NONE);
        return gatherer.files;
    }

    private File getGenDirectory(Scope s, String artifactType) {
        return new File(this.getIntermediateDirectory(), "gen/" + s.getName() + "/" + artifactType);
    }

    private File getIntermediateDirectory(String uniquePath) {
        return new File(this.getIntermediateDirectory(), "int/uniquePath");
    }

    @Override
    public long releaseLastModified() {
        return FileUtil.deepLastModified(this.moduleC.getReleaseDirectory());
    }

    @Override
    public ModuleC getCPart() {
        return (ModuleC)super.getCPart();
    }

    private File getExportDirectory(Scope scope, String artifactType) {
        return new File(this.moduleC.getReleaseDirectory(), String.valueOf(scope.getName()) + "/" + artifactType);
    }

    @Override
    public void buildRun() throws Exception {
        this.moduleC.getReleaseDirectory().mkdirs();
        for (String artifact : this.moduleC.getReleases().keySet()) {
            this.moduleC.getRelease(artifact).subsumeDependencies(Scope.MAIN);
        }
        BuilderChain chain = this.getCPart().configureAndParameterizeBuilderChain();
        for (BuilderInstance b : chain.getBuilders()) {
            ModuleProjectHelper.AbstractBuilderArgument arg = new ModuleProjectHelper.AbstractBuilderArgument(this, Scope.MAIN, b){

                public boolean isBuild() {
                    return true;
                }

                public boolean isFirstCall() {
                    return true;
                }

                public File getGenDirectory(String artifactType) {
                    return ModuleBuildProject.this.getGenDirectory(this.scope, artifactType);
                }

                public File getExportDirectory(String artifactType) {
                    return ModuleBuildProject.this.getExportDirectory(Scope.MAIN, artifactType);
                }

                public File getIntermediateDir(String uniquePath) {
                    return ModuleBuildProject.this.getIntermediateDirectory(uniquePath);
                }

                private File getOutputDir(String artifactType) {
                    if (ModuleBuildProject.this.moduleC.isIntermediate(artifactType)) {
                        return this.getGenDirectory(artifactType);
                    }
                    return this.getExportDirectory(artifactType);
                }

                public File getOutputArtifact(String artifactType, boolean alwaysNamed) {
                    File export = this.getOutputDir(artifactType);
                    if (alwaysNamed) {
                        export = new File(export.getParentFile(), String.valueOf(export.getName()) + ".group");
                        String suffix = FileUtil.fileSuffix(artifactType);
                        artifactType = String.valueOf(artifactType) + ".group";
                        String fileName = ModuleBuildProject.this.filePrefix();
                        if (suffix != null) {
                            fileName = String.valueOf(fileName) + "." + suffix;
                        }
                        return new File(export, fileName);
                    }
                    return this.getOutputDir(artifactType);
                }

                public IModuleBuildProject getModuleBuildProject() {
                    return ModuleBuildProject.this;
                }
            };
            IPropertyMap props = arg.getPropertyMap();
            ILogger logger = arg.getLogger();
            logger.prime();
            logger.setProvisionalHeading("Properties");
            for (String k : props.listKeys()) {
                Object v = props.get(k);
                logger.log("    " + k + ": " + v);
            }
            b.build(arg);
        }
        FileFilter filter = this.module.getRepository().getFileFilter();
        for (String artifactType : this.helper.listSourceArtifacts(Scope.MAIN)) {
            if (this.moduleC.getRelease(artifactType) == null) continue;
            File target = this.getExportDirectory(Scope.MAIN, artifactType);
            target.mkdirs();
            File source = this.getSrcDirectory(Scope.MAIN, artifactType);
            EBuild ebuild = this.module.ebuild;
            EBuildLogger logger = ebuild.logger;
            logger.log("releasing source");
            logger.log("    " + ebuild.formatAsDisplayPath(source));
            logger.log(" -> " + ebuild.formatAsDisplayPath(target));
            FileUtil.copy(source, target, filter);
        }
    }

    @Override
    protected void buildEnd() throws Exception {
        super.buildEnd();
        if (this.module.buildPlugin != null) {
            FileUtil.copyToDirIfNewer(this.module.META.getMetaDir().getFile(MetaType.BUILD_PLUGIN), ((Module)this.getPart()).getReleaseDirectory());
        }
    }

    public Collection<IModuleProject> getProjectDependencies(Scope scope) {
        LinkedHashSet<IModuleProject> r = new LinkedHashSet<IModuleProject>();
        for (ModuleDeps.ModuleDep dep : ((ModuleC)this.elementC).getDependencies(scope).getModuleDeps()) {
            r.add((IModuleProject)dep.moduleC.getOrCreateBuildProject());
        }
        return r;
    }

    @Override
    public File getReleaseSubDir() {
        return ((ModuleC)this.elementC).getReleaseDirectory();
    }

    @Override
    public Collection getReleasedDependencies(Scope scope) {
        LinkedHashSet r = new LinkedHashSet();
        for (ModuleDeps.ModuleDep dep : ((ModuleC)this.elementC).getDependencies(scope).getModuleDeps()) {
            if (dep.scope != scope) continue;
            r.add(dep.moduleC.getOrCreateBuildProject());
        }
        return r;
    }

    public IArtifact getProductArtifactDependency(String role) {
        return this.moduleC.getDependencies(Scope.MAIN).getProduct(role);
    }
}

