/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IModuleBuildProject;
import ebuild.api.IModuleWorkspaceProject;
import ebuild.api.common.Scope;
import ebuild.api.log.ILogger;
import ebuild.api.plugin.BuildPluginException;
import ebuild.api.plugin.IPropertyMap;
import ebuild.base.EBuildException;
import ebuild.compat.BuilderSignature;
import ebuild.compat.IBuilderArgumentInCompat;
import ebuild.core.BuilderDef;
import ebuild.core.BuilderInstance;
import ebuild.core.EBuild;
import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.Module;
import ebuild.core.ModuleDeps;
import ebuild.core.Project;
import ebuild.core.ProjectHelper;
import ebuild.core.conf.ConfMapping;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.util.NameTemplate;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.version.EBuildVersion;
import ebuild.xml.CmnXml;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleProjectHelper
extends ProjectHelper {
    private final Module module;
    private Boolean singleFolderLayout = null;
    private static final FilenameFilter FILTER_HIDDEN = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return !name.startsWith(".");
        }
    };

    ModuleProjectHelper(Module module) throws EBuildException {
        super(module);
        this.module = module;
    }

    private boolean isSingleFolderLayout() {
        if (this.singleFolderLayout == null) {
            this.singleFolderLayout = new File(this.module.getProjectDirectory(), "src_main").exists();
        }
        return this.singleFolderLayout;
    }

    public Collection<String> listSourceArtifacts(Scope scope) {
        File dir = new File(this.module.getProjectDirectory(), "src/" + scope);
        if (dir.isDirectory()) {
            return CollectionUtil.newSet(dir.list(FILTER_HIDDEN));
        }
        return CollectionUtil.EMPTY_SET;
    }

    public File getSrcDirectory(Scope scope, String type) {
        return new File(this.module.getProjectDirectory(), this.getSrcFolder(false, scope, type));
    }

    public String getSrcFolder(boolean gen, Scope scope, String type) {
        return this.getSrcFolder(gen ? "gen" : "src", scope, type);
    }

    public String getSrcFolder(String kind, Scope scope, String type) {
        if (this.isSingleFolderLayout()) {
            return String.valueOf(kind) + "_" + scope;
        }
        return String.valueOf(kind) + "/" + scope + "/" + type;
    }

    private Module module() {
        return this.module;
    }

    public static File getCorespondingBuildDependency(IModuleWorkspaceProject project, Scope scope, String artifactType, File jar) {
        File attempt;
        Collection lookup = project.getIDESetupArtifactDependencies(scope, null, artifactType);
        if (lookup.contains(attempt = FileUtil.canonicalFile(new File(jar.getParentFile(), "../" + artifactType)))) {
            return attempt;
        }
        String filename = FileUtil.removeSuffix(jar.getName());
        String suffix = FileUtil.fileSuffix(artifactType);
        if (suffix != null) {
            filename = String.valueOf(filename) + "." + suffix;
        }
        if (lookup.contains(attempt = FileUtil.canonicalFile(new File(jar.getParentFile(), "../" + artifactType + ".group/" + filename)))) {
            return attempt;
        }
        return null;
    }

    public static Collection<File> getCheckedInArtifacts(ElementC cElement, Scope s, String type) {
        ModuleDeps mcdeps = (ModuleDeps)cElement.getDependencies(s);
        Iterable<ModuleDeps.CheckedInDep> deps = mcdeps.getCheckedInDeps();
        ArrayList<File> r = new ArrayList<File>();
        for (ModuleDeps.CheckedInDep d : deps) {
            if (type != null && !type.equals(d.type)) {
                EBuild ebuild = ((Element)cElement.element).ebuild;
                if (!ebuild.isVerbose()) continue;
                ebuild.log("  [ignoring checkedin] " + type + "!=" + d.type + ": ");
                ebuild.log("      " + d);
                continue;
            }
            r.add(d.getFile());
        }
        return r;
    }

    public String getJavaVersion() {
        return this.module().getJavaVersion();
    }

    public BuilderDef newBuildPluginDef(Module module, ConfMapping mapping, List props) {
        BuilderSignature signature = module.buildPlugin.getBuilderDef();
        return new BuilderDef(module, mapping, signature, (List<CmnXml.Property>)props);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractBuilderArgument
    implements IBuilderArgumentInCompat {
        final String filePrefix;
        final Project<Module> project;
        final ElementC<Module> cModule;
        final Module module;
        final String builderName;
        final IPropertyMap props;
        final Scope scope;

        AbstractBuilderArgument(Project<Module> project, Scope scope, BuilderInstance bi) throws BuildPluginException, EBuildException {
            this.filePrefix = ((IModuleBuildProject)project).filePrefix();
            this.project = project;
            this.cModule = project.elementC;
            this.module = (Module)this.cModule.element;
            this.builderName = bi.name();
            this.props = bi.props;
            this.scope = scope;
        }

        public Map<String, String> getConfs() {
            return new HashMap<String, String>(this.cModule.getConfiguration().asMap());
        }

        @Override
        public EBuildVersion getTargetVersion() {
            return this.module.META.expectMainXml().getEBuildVersion();
        }

        @Override
        public abstract File getExportDirectory(String var1);

        public EBuild getEBuild() {
            return this.module.ebuild;
        }

        public ILogger getLogger() {
            return this.getEBuild().logger.newSubLogger("Builder/" + this.builderName);
        }

        public IPropertyMap getPropertyMap() {
            return this.props;
        }

        public Scope getScope() {
            return this.scope;
        }

        public List<File> getInputDirs(String artifactType) {
            File genDir;
            ArrayList<File> r = new ArrayList<File>(2);
            ModuleProjectHelper phelper = this.module.getProjectHelper();
            File srcDir = this.project.getProjectFile(phelper.getSrcFolder("src", this.scope, artifactType));
            if (srcDir.exists()) {
                r.add(srcDir);
            }
            if ((genDir = this.getGenDirectory(artifactType)) != null && genDir.exists()) {
                r.add(genDir);
            }
            return r;
        }

        @Override
        public Collection<File> getCheckedInArtifacts(String type) {
            return ModuleProjectHelper.getCheckedInArtifacts(this.cModule, this.scope, type);
        }

        @Override
        public String getArchiveName(String suffix) {
            try {
                NameTemplate nt = NameTemplate.parse(String.valueOf(this.module.key.fullname()) + "{-|confs}{-|version}" + "." + suffix);
                return nt.apply(EBuildUtil.newNameTemplateModel(this.module.key.version, this.cModule.getConfiguration()));
            }
            catch (EBuildException e) {
                throw new Error(e);
            }
        }

        @Override
        public FileFilter getFileFilter() {
            return ((Module)this.project.elementC.element).getRepository().getFileFilter();
        }
    }
}

