/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.Scope;
import ebuild.base.Backtrace;
import ebuild.base.EBuildException;
import ebuild.core.Artifact;
import ebuild.core.ElementReleaseArtifact;
import ebuild.core.Module;
import ebuild.core.ModuleC;
import ebuild.core.ModuleDeps;
import ebuild.core.impl.Exclude;
import ebuild.core.util.WorkMarker;
import ebuild.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleReleaseArtifact
extends ElementReleaseArtifact<Module>
implements Artifact.Module {
    public final Scope scope;
    public final File artifactFile;
    public final File artifactGroup;

    public static ModuleReleaseArtifact newModuleRelease(ModuleC moduleC, String artifact, String filepart, Scope scope, File releaseConfDir) {
        File parentDir = new File(releaseConfDir, "" + scope);
        File artifactGroup = new File(parentDir, String.valueOf(filepart) + ".group");
        File artifactFile = new File(parentDir, filepart);
        WorkMarker marker = new WorkMarker(artifactFile, artifactGroup);
        return new ModuleReleaseArtifact(moduleC, artifact, marker, scope, artifactFile, artifactGroup);
    }

    private ModuleReleaseArtifact(ModuleC moduleC, String artifact, WorkMarker marker, Scope scope, File artifactFile, File artifactGroup) {
        super(moduleC, artifact, new WorkMarker(artifactFile, artifactGroup));
        this.scope = scope;
        this.artifactFile = artifactFile;
        this.artifactGroup = artifactGroup;
    }

    public File getParentDir() {
        return this.artifactFile.getParentFile();
    }

    @Override
    public File[] getRoots() {
        return new File[]{this.artifactFile, this.artifactGroup};
    }

    @Override
    public Collection<File> getArtifactFiles() {
        ArrayList<File> r = new ArrayList<File>();
        if (this.artifactGroup.isDirectory()) {
            File[] files;
            File[] fileArray = files = this.artifactGroup.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (!"COPYRIGHT.txt".equals(f.getName())) {
                    r.add(f);
                }
                ++n2;
            }
            return r;
        }
        if (this.artifactFile.exists()) {
            r.add(this.artifactFile);
        }
        return r;
    }

    @Override
    public void subsumeDependencies(Scope scope) throws EBuildException {
        Backtrace.startTop("subsume dependencies", this.elementC.key);
        try {
            ModuleDeps deps = (ModuleDeps)this.elementC.getDependencies(scope);
            for (ModuleDeps.ModuleDep pd : deps.getModuleDeps()) {
                if (!pd.subsumed) continue;
                this.artifactGroup.mkdirs();
                pd.getRelease(this.artifact).subsume(this, pd.scope, Exclude.NONE);
            }
        }
        finally {
            Backtrace.endTop(this.elementC.key);
        }
    }

    @Override
    public void subsume(ModuleReleaseArtifact subsumer, Scope subsumerScope, Exclude exclude) throws EBuildException {
        Backtrace.start("subsume", this.elementC.key);
        try {
            try {
                if (this.artifactGroup.isDirectory()) {
                    FileUtil.mergeCopy(this.artifactGroup, subsumer.artifactGroup);
                }
            }
            catch (IOException e) {
                throw EBuildException.newInternalError("Unable to subsume directory", e);
            }
            ModuleDeps deps = (ModuleDeps)this.elementC.getDependencies(Scope.MAIN);
            for (ModuleDeps.ModuleDep pd : deps.getModuleDeps()) {
                if (pd.subsumed) continue;
                ModuleReleaseArtifact d = (ModuleReleaseArtifact)pd.moduleC.getRelease(this.artifact);
                d.subsume(subsumer, subsumerScope, pd.exclude);
            }
        }
        finally {
            Backtrace.end(this.elementC.key);
        }
    }

    public String toString() {
        return "ModuleRelease: " + this.elementC + " " + this.scope + " " + this.artifact;
    }
}

