/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.base.Backtrace;
import ebuild.base.EBuildException;
import ebuild.core.ActionQueue;
import ebuild.core.BuildPlan;
import ebuild.core.EBuild;
import ebuild.core.EBuildContextOfXml;
import ebuild.core.ElementC;
import ebuild.core.Module;
import ebuild.core.ModuleBuildPlan;
import ebuild.core.ModuleCDep;
import ebuild.core.Product;
import ebuild.core.ProductBuildMeta;
import ebuild.core.ProductC;
import ebuild.core.ProductDeps;
import ebuild.core.ProductProjectHelper;
import ebuild.core.conf.ConfMap;
import ebuild.core.conf.ConfMapping;
import ebuild.core.impl.ConfKey;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.Exclude;
import ebuild.core.impl.KeyC;
import ebuild.core.impl.KeyE;
import ebuild.core.impl.TaskSet;
import ebuild.util.tuple.Pair;
import ebuild.xml.PrdXml;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductBuildPlan
extends BuildPlan {
    final Product product;
    private final ProductC productC;
    protected final Map<String, Dependency> subPlans = new LinkedHashMap<String, Dependency>();

    public ProductBuildPlan(EBuild ebuild, ElementC<Product> elementC) {
        super(ebuild, elementC.key);
        this.product = (Product)elementC.element;
        if (!this.product.isSource()) {
            throw new Error("Non-source components not currently supported");
        }
        this.productC = (ProductC)elementC;
    }

    public ConfMap getConf() {
        return this.productC.getConfiguration();
    }

    @Override
    public KeyC getKey() {
        return (KeyC)super.getKey();
    }

    public ElementC expectLoneCPart() {
        return this.productC;
    }

    @Override
    protected void resolveAndConfigureDependencies(TaskSet tasks) throws EBuildException {
        if (!((Product)this.productC.element).isWorkspace() && (tasks = tasks.withoutIDE()).isEmpty()) {
            return;
        }
        this.resolveDependencies(tasks);
        for (Dependency d : this.subPlans.values()) {
            d.buildPlan.resolveAndConfigure(tasks);
        }
        ProductDeps deps = this.newCDependencies();
        this.productC.setDependencies(deps);
    }

    void resolveDependencies(TaskSet tasks) throws EBuildException {
        ProductProjectHelper phelper = this.product.getProjectHelper();
        EBuildContextOfXml context = phelper.contextOfBuild.resolveSelf();
        this.report.startResolve(context, "product dependencies");
        Backtrace.start("resolve dependencies", context);
        try {
            Map<String, ProductBuildMeta.ModuleSelection> moduleSelections = this.product.getProject().getMETA().getModuleSelections(this.productC.key);
            for (String k : moduleSelections.keySet()) {
                ProductBuildMeta.ModuleSelection moduleSelection = moduleSelections.get(k);
                Pair<KeyC, String> key = new Pair<KeyC, String>(this.getKey(), k);
                ConfMapping groupMapping = EBuildUtil.parseMapping(moduleSelection.groupMapping);
                ConfMap groupConfs = groupMapping.evaluate(this.getConf());
                if (this.ebuild.buildPlans.containsKey(key)) {
                    throw new Error("Unexpected error, build plan exists already: " + key);
                }
                ModuleBuildPlan mbp = new ModuleBuildPlan(this.ebuild, this.product.context, key, moduleSelection.excludes);
                this.subPlans.put(k, new Dependency(moduleSelection.artifact, mbp));
                mbp.setGroupConfs(groupConfs);
                for (PrdXml.Include d : moduleSelection.includes) {
                    String source;
                    if (!EBuildUtil.evaluateExpr(d.conf, this.getConf()) || "system".equals(source = d.source) || "checkedin".equals(source)) continue;
                    KeyE dkey = context.newModuleKeyE(d);
                    Module dmodule = context.resolveModule(source, dkey);
                    ConfMap confs = EBuildUtil.evaluateMapping(d.confMapping, this.getConf());
                    Exclude exclude = d.dependencies ? Exclude.NONE : Exclude.ALL;
                    mbp.addModule(dmodule, confs, exclude);
                }
            }
            Map<String, PrdXml.Product> components = this.product.getProject().getMETA().getSelectedComponentsXml(this.productC.getSubKey());
            for (String k : components.keySet()) {
                PrdXml.Product d = components.get(k);
                KeyE dkey = context.newProductKeyE(d);
                Product delement = (Product)context.resolveElement(d.source, dkey);
                ConfMapping mapping = EBuildUtil.parseMapping(d.confMapping, ConfMapping.EMPTY);
                ConfMap dconf = mapping.evaluate(this.getConf());
                ElementC elementC = delement.getCPart(new ConfKey(dconf));
                BuildPlan subplan = this.ebuild.getBuildPlan(elementC);
                this.subPlans.put(k, new Dependency(d.artifact, subplan));
            }
        }
        finally {
            Backtrace.end(context);
        }
        this.report.endResolve();
    }

    ProductDeps newCDependencies() {
        ProductDeps r = new ProductDeps();
        for (String k : this.subPlans.keySet()) {
            Dependency d = this.subPlans.get(k);
            BuildPlan bp = d.buildPlan;
            if (bp instanceof ModuleBuildPlan) {
                ModuleBuildPlan mbp = (ModuleBuildPlan)bp;
                Collection<ModuleCDep> mods = mbp.getPrimaryModules();
                r.addModuleSelection(new ProductDeps.ModuleSelectionDep(k, mods));
                continue;
            }
            ProductBuildPlan cbp = (ProductBuildPlan)bp;
            r.addProduct(new ProductDeps.ProductDep(k, cbp.productC, d.artifact));
        }
        return r;
    }

    @Override
    protected void resolveBuilders(TaskSet tasks) throws EBuildException {
        if (!((Product)this.productC.element).isWorkspace() && (tasks = tasks.withoutIDE()).isEmpty()) {
            return;
        }
        this.resolveBuildPluginsForPart(this.productC);
    }

    @Override
    protected void buildActionListForPlan(ActionQueue queue, TaskSet tasks) throws Exception {
        if (!((Product)this.productC.element).isWorkspace()) {
            tasks = tasks.withoutIDE();
        }
        for (Dependency dep : this.subPlans.values()) {
            dep.buildPlan.buildActionList(queue, tasks);
        }
        this.buildActionListForPart(queue, (ElementC)this.productC, tasks);
    }

    protected static class Dependency {
        final String artifact;
        final BuildPlan buildPlan;

        protected Dependency(String artifact, BuildPlan buildPlan) {
            this.artifact = artifact;
            this.buildPlan = buildPlan;
        }
    }
}

