/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.common.IConfiguration;
import ebuild.api.common.IElementKey;
import ebuild.api.common.IVersion;
import ebuild.api.common.Scope;
import ebuild.api.repo.AbstractReleaseRepository;
import ebuild.api.repo.AbstractSourceRepository;
import ebuild.api.repo.IRepository;
import ebuild.api.repo.RepositoryPluginException;
import ebuild.base.EBuildException;
import ebuild.base.MetaType;
import ebuild.core.Artifact;
import ebuild.core.EBuild;
import ebuild.core.ElementC;
import ebuild.core.ElementMeta;
import ebuild.core.ElementNature;
import ebuild.core.MetaDir;
import ebuild.core.ModuleC;
import ebuild.core.ModuleMeta;
import ebuild.core.ModuleReleaseArtifact;
import ebuild.core.impl.EBuildMode;
import ebuild.core.impl.Exclude;
import ebuild.core.impl.KeyE;
import ebuild.core.impl.PersistentMap;
import ebuild.core.impl.Version;
import ebuild.core.util.WorkMarker;
import ebuild.util.CollectionUtil;
import ebuild.util.IOUtil;
import ebuild.util.StringUtil;
import ebuild.xml.CmnXml;
import ebuild.xml.MachineOptionsXml;
import ebuild.xml.ModXml;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepositoryInstance {
    static final None NOREPO = new None();
    private static final FileFilter FILEFILTER_DEFAULT = new FileFilter(){

        public boolean accept(File f) {
            return !".svn".equals(f.getName());
        }
    };

    public static RepositoryInstance create(EBuild ebuild, IRepository repo) {
        if (repo == null) {
            return NOREPO;
        }
        if (repo instanceof AbstractSourceRepository) {
            return new Source(ebuild, (AbstractSourceRepository)repo);
        }
        return new Release((AbstractReleaseRepository)repo);
    }

    public abstract String getUri();

    public abstract String getUniverse();

    public abstract boolean isSource();

    public abstract IRepository getRepo();

    public abstract ElementMeta resolveMeta(EBuild var1, KeyE var2) throws EBuildException;

    public boolean hasRepo() {
        return this.getRepo() != null;
    }

    public Source asSource() throws EBuildException {
        if (this.isSource()) {
            return (Source)this;
        }
        throw EBuildException.newInternalError("Not a source repository: " + this);
    }

    public Source asSourceSafe() {
        return (Source)this;
    }

    public Release asBinary() throws EBuildException {
        if (this.hasRepo() && !this.isSource()) {
            return (Release)this;
        }
        throw EBuildException.newInternalError("Not a binary repository: " + this);
    }

    public FileFilter getFileFilter() {
        if (!this.isSource()) {
            return FILEFILTER_DEFAULT;
        }
        FileFilter r = this.asSourceSafe().getRepo().getFileFilter();
        if (r == null) {
            r = FILEFILTER_DEFAULT;
        }
        return r;
    }

    public List<KeyE> listElements(Version version) throws RepositoryPluginException {
        return null;
    }

    public static class Machine
    extends RepositoryInstance {
        public String getUri() {
            return "machine://";
        }

        public String getUniverse() {
            return "ebuild";
        }

        public boolean isSource() {
            return false;
        }

        public IRepository getRepo() {
            return null;
        }

        public ElementMeta resolveMeta(EBuild ebuild, KeyE key) throws EBuildException {
            EBuild.MachineOptions options = ebuild.getMachineOptions();
            if (options.file == null) {
                throw EBuildException.newConfProblem("Could not find machine-options.xml. Looked in " + StringUtil.prefix("\n        ", ebuild.getMachineOptionsLocations()));
            }
            for (final MachineOptionsXml.Module m : options.xml.modules) {
                if (!m.org.equals(key.org) || !m.name.equals(key.name)) continue;
                final ModXml.EbuildModule fakeXml = new ModXml.EbuildModule();
                fakeXml.artifacts = new ArrayList<ModXml.Artifact>();
                fakeXml.repositories = CollectionUtil.EMPTY_LIST;
                fakeXml.usings = CollectionUtil.EMPTY_LIST;
                for (MachineOptionsXml.Artifact a : m.artifacts) {
                    ModXml.Artifact fakeArtifact = new ModXml.Artifact();
                    fakeArtifact.name = a.name;
                    fakeXml.artifacts.add(fakeArtifact);
                }
                return new ModuleMeta(){

                    @Override
                    public MetaDir getMetaDir() {
                        return null;
                    }

                    @Override
                    public boolean isSource() {
                        return false;
                    }

                    @Override
                    public boolean isExternal() {
                        return true;
                    }

                    @Override
                    public EBuildMode getMode() {
                        return EBuildMode.library;
                    }

                    @Override
                    public MetaType getMetaType() {
                        return MetaType.MODULE;
                    }

                    @Override
                    public ElementType getElementType() {
                        return ElementType.module;
                    }

                    @Override
                    public void check() throws EBuildException {
                    }

                    @Override
                    public CmnXml.Configuration getConfXml(String name) {
                        return null;
                    }

                    @Override
                    public Iterable<? extends CmnXml.SelectWithSource> getMainDependencies() {
                        return CollectionUtil.EMPTY_LIST;
                    }

                    @Override
                    public ModXml.EbuildModule expectMainXml() {
                        return fakeXml;
                    }

                    @Override
                    public Artifact.Module newModuleRelease(final ModuleC moduleC, final String artifact, String filepart, Scope main, File releaseDirectory) {
                        return new Artifact.Module(){

                            @Override
                            public String getName() {
                                return artifact;
                            }

                            @Override
                            public File[] getRoots() {
                                return this.getArtifactFiles().toArray(new File[this.getArtifactFiles().size()]);
                            }

                            @Override
                            public ElementC getElementC() {
                                return moduleC;
                            }

                            @Override
                            public boolean exists() {
                                return true;
                            }

                            @Override
                            public void delete() {
                            }

                            @Override
                            public void subsumeDependencies(Scope main) {
                            }

                            @Override
                            public void subsume(ModuleReleaseArtifact moduleReleaseArtifact, Scope scope, Exclude none) {
                            }

                            @Override
                            public Collection<File> getArtifactFiles() {
                                ArrayList<File> artifactFiles = new ArrayList<File>();
                                for (MachineOptionsXml.Artifact a : m.artifacts) {
                                    String[] files;
                                    if (!a.name.equals(artifact)) continue;
                                    String[] stringArray = files = a.files.split(",");
                                    int n = files.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String s = stringArray[n2];
                                        artifactFiles.add(new File(s));
                                        ++n2;
                                    }
                                }
                                return artifactFiles;
                            }
                        };
                    }
                };
            }
            throw EBuildException.newRepoIssue("No module specified in machine-options.xml '" + key + "'\n Options used: " + options.file + "\n      ------       \n" + IOUtil.fileToStringOrError(options.file));
        }
    }

    public static class None
    extends Project {
        public IRepository getRepo() {
            return null;
        }

        public boolean isSource() {
            return false;
        }

        public String getUri() {
            return null;
        }

        public String getUniverse() {
            return "project";
        }

        public IRepository expectRepo(KeyE key) throws EBuildException {
            throw EBuildException.newConfProblem("Repository cannot be located for element: " + key);
        }

        public ElementNature determineNatureOfLibraryProject(KeyE key, File dir4version) throws EBuildException {
            if (new File(dir4version, "project").exists()) {
                return ElementNature.source;
            }
            if (new File(dir4version, "release").exists()) {
                return ElementNature.binary;
            }
            throw EBuildException.newConfProblem("Cannot determine element nature (repository unknown, no project dir, no release dir): " + dir4version);
        }
    }

    public static abstract class Project
    extends RepositoryInstance {
        public abstract ElementNature determineNatureOfLibraryProject(KeyE var1, File var2) throws EBuildException;

        public boolean canResolveOtherVersion(IVersion version) {
            return false;
        }

        public void fetchMeta(KeyE key, File dir4meta) throws EBuildException {
            WorkMarker marker = new WorkMarker(dir4meta);
            if (!marker.isComplete()) {
                IRepository repo = this.getRepo();
                if (repo == null) {
                    throw EBuildException.newRepoIssue("Not connected to a repo: " + key);
                }
                marker.create();
                try {
                    repo.fetchMeta(dir4meta, (IElementKey)key);
                }
                catch (RepositoryPluginException e) {
                    throw EBuildException.newRepoIssue("Could not fetch meta for '" + key + "'", e);
                }
                marker.remove();
            }
        }

        private MetaDir getMetaDir(EBuild ebuild, KeyE key) throws EBuildException {
            File dir4version = key.getSubDirectoryOfLibrary(ebuild.LIBRARY.root);
            ebuild.LIBRARY.used.add(dir4version);
            File metaDir = new File(dir4version, "meta");
            WorkMarker marker = new WorkMarker(metaDir);
            if (!marker.isComplete()) {
                return null;
            }
            ElementNature nature = this.determineNatureOfLibraryProject(key, dir4version);
            return new MetaDir(ebuild, metaDir, key.withoutType(), nature, EBuildMode.library);
        }

        private MetaDir resolveMetaDir(EBuild ebuild, KeyE key0) throws EBuildException {
            KeyE key = key0.withoutType();
            MetaDir metaDir = this.getMetaDir(ebuild, key);
            if (metaDir != null) {
                return metaDir;
            }
            File dir4version = key.getSubDirectoryOfLibrary(ebuild.LIBRARY.root);
            File dir4meta = new File(dir4version, "meta");
            IVersion version = key.getVersion();
            if (this.canResolveOtherVersion(version)) {
                Source srepo = this.asSource();
                File projectDir = new File(dir4version, "project");
                if (projectDir.isFile()) {
                    String revision2 = IOUtil.fileToStringOrError(projectDir);
                    KeyE key2 = key.withRevision(revision2);
                    MetaDir metaDir2 = this.getMetaDir(ebuild, key2);
                    if (metaDir2 == null) {
                        throw EBuildException.newInternalError("Expected : " + ebuild.formatAsDisplayPath(dir4meta) + "\n" + "Redirected to project revision '" + key + "' -> " + revision2 + "'");
                    }
                    return metaDir2;
                }
                String revision = srepo.fetchRevisionOfLastChange(key);
                if (revision != null) {
                    int cmp = srepo.compareRevisions(version.getRevision(), revision);
                    if (cmp < 0) {
                        throw new Error("Last change revision greater than selected revision: " + version.getRevision() + " " + revision);
                    }
                    if (cmp > 0) {
                        KeyE key2 = key.withRevision(revision);
                        return this.resolveMetaDir(ebuild, key2);
                    }
                }
            }
            this.fetchMeta(key, dir4meta);
            return this.getMetaDir(ebuild, key);
        }

        public ElementMeta resolveMeta(EBuild ebuild, KeyE key) throws EBuildException {
            MetaDir metaDir = this.resolveMetaDir(ebuild, key);
            if (metaDir != null) {
                ElementType type = key.type;
                if (type == null) {
                    type = metaDir.getPrimaryType();
                }
                metaDir.init(type);
                return metaDir.getElementMeta(type);
            }
            return null;
        }
    }

    public static class Release
    extends Project {
        private final AbstractReleaseRepository repo;

        Release(AbstractReleaseRepository repo) {
            this.repo = repo;
        }

        public Release(Release prototype) {
            this.repo = prototype.repo;
        }

        public String getUri() {
            return this.repo.getUri();
        }

        public String getUniverse() {
            return this.repo.getUniverse();
        }

        public IRepository getRepo() {
            return this.repo;
        }

        public boolean isSource() {
            return false;
        }

        public IRepository expectRepo(KeyE key) throws EBuildException {
            return this.repo;
        }

        protected IElementKey check(IElementKey key) throws RepositoryPluginException {
            return key;
        }

        public void fetchMeta(File metaDir, IElementKey key) throws RepositoryPluginException {
            this.repo.fetchMeta(metaDir, this.check(key));
        }

        public void fetchModuleRelease(File artifactDir, IElementKey key, IConfiguration conf, String artifact) throws RepositoryPluginException {
            this.repo.fetchModuleRelease(artifactDir, this.check(key), conf, artifact);
        }

        public void fetchComponentRelease(File releaseDir, IElementKey key, String releaseFileName) throws RepositoryPluginException {
            this.repo.fetchComponentRelease(releaseDir, this.check(key), releaseFileName);
        }

        public ElementNature determineNatureOfLibraryProject(KeyE key, File dir4version) throws EBuildException {
            return ElementNature.binary;
        }

        public String toString() {
            return "" + this.repo;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Source
    extends Project {
        public final AbstractSourceRepository repo;
        private String headRevision;
        final PersistentMap branchStarts;
        private Map<String, String> branchHeads = new HashMap<String, String>();

        public Source(EBuild ebuild, AbstractSourceRepository repo) {
            this.branchStarts = ebuild.LIBRARY.BRANCH_STARTS;
            this.repo = repo;
        }

        @Override
        public ElementNature determineNatureOfLibraryProject(KeyE key, File dir4version) throws EBuildException {
            return ElementNature.source;
        }

        @Override
        public String getUri() {
            return this.repo.getUri();
        }

        @Override
        public String getUniverse() {
            return "project";
        }

        public AbstractSourceRepository getRepo() {
            return this.repo;
        }

        @Override
        public boolean isSource() {
            return true;
        }

        @Override
        public List<KeyE> listElements(Version version) throws RepositoryPluginException {
            List names = this.repo.listProjects((IVersion)version);
            ArrayList<KeyE> r = new ArrayList<KeyE>(names.size());
            for (String n : names) {
                String[] org_name = n.split("-", 2);
                if (org_name.length != 2) continue;
                r.add(new KeyE(null, this.getUniverse(), org_name[0], org_name[1], version));
            }
            return r;
        }

        public AbstractSourceRepository getRepository() {
            return this.repo;
        }

        public int compareRevisions(String ra, String rb) {
            return this.repo.compareRevisions(ra, rb);
        }

        public void fetchProject(File projectDir, IElementKey key) throws RepositoryPluginException {
            this.repo.fetchProject(projectDir, key);
        }

        public String getRevisionOfHead() throws EBuildException {
            if (this.headRevision == null) {
                try {
                    this.headRevision = this.repo.fetchRevisionOfHead();
                }
                catch (RepositoryPluginException e) {
                    throw EBuildException.newRepoIssue("Could not fetch head revision of '" + this.repo.getUri() + "'", e);
                }
            }
            return this.headRevision;
        }

        public String getRevisionOfBranchHead(IVersion version) throws EBuildException {
            String branch = version.getBranch();
            String r = this.branchHeads.get(branch);
            if (r == null) {
                try {
                    r = this.repo.fetchRevisionOfBranchHead(version);
                    this.branchHeads.put(branch, r);
                }
                catch (RepositoryPluginException e) {
                    throw EBuildException.newRepoIssue("Could not fetch branch head revision of '" + this.repo.getUri() + "', branch '" + branch + "'", e);
                }
            }
            return r;
        }

        public String getRevisionOfBranchCreation(IVersion version) throws EBuildException {
            String branch = version.getBranch();
            String lookup = String.valueOf(this.getUri()) + ":" + branch;
            String r = this.branchStarts.get(lookup);
            if (r == null) {
                try {
                    r = this.repo.fetchRevisionOfBranchCreation(version);
                    this.branchStarts.putAndUpdate(lookup, r);
                }
                catch (RepositoryPluginException e) {
                    throw EBuildException.newRepoIssue("Could not fetch branch creation revision of '" + this.repo.getUri() + "', branch '" + branch + "'", e);
                }
            }
            return r;
        }

        public String fetchRevisionOfLastChange(IElementKey key) throws EBuildException {
            try {
                String rA = this.repo.fetchRevisionOfLastChange(key);
                String rB = this.getRevisionOfBranchCreation(key.getVersion());
                return this.maxRevision(rA, rB);
            }
            catch (RepositoryPluginException e) {
                throw EBuildException.newRepoIssue("Could not fetch latest revision of '" + this.repo.getUri() + "' " + key, e);
            }
        }

        @Override
        public boolean canResolveOtherVersion(IVersion version) {
            return !version.isTag();
        }

        public String toString() {
            return "" + this.repo;
        }

        public String maxRevision(String r1, String r2) {
            if (r1 == null) {
                return r2;
            }
            if (r2 == null) {
                return r1;
            }
            return this.repo.compareRevisions(r1, r2) < 0 ? r2 : r1;
        }
    }
}

