/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.impl;

import ebuild.core.impl.KeyE;
import ebuild.core.impl.Version;
import ebuild.util.CollectionUtil;
import ebuild.util.StringUtil;
import ebuild.xml.CmnXml;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Exclude {
    public static final Exclude NONE = new Exclude(CollectionUtil.EMPTY_LIST);
    public static final Exclude ALL = Exclude.newExclude(Rule.access$0());
    private final Collection<Rule> rules;

    public static Exclude newExclude(List<CmnXml.SelectWithSource> xml) {
        if (xml.size() == 0) {
            return NONE;
        }
        ArrayList<Rule> r = new ArrayList<Rule>(xml.size());
        for (CmnXml.SelectWithSource x : xml) {
            r.add(new Rule(x));
        }
        return new Exclude(r);
    }

    public static Exclude newExclude(Rule ... rules) {
        if (rules.length == 0) {
            return NONE;
        }
        return new Exclude(CollectionUtil.newImmutableList(rules));
    }

    public static Exclude union(Exclude a, Exclude b) {
        if (a == ALL || b == ALL) {
            return ALL;
        }
        if (a == NONE) {
            return b;
        }
        if (b == NONE) {
            return a;
        }
        ArrayList<Rule> l = new ArrayList<Rule>(a.rules.size() + b.rules.size());
        l.add((Rule)((Object)Integer.valueOf(a.rules.size())));
        l.add((Rule)((Object)Integer.valueOf(b.rules.size())));
        return new Exclude(l);
    }

    public static Exclude intersection(Exclude a, Exclude b) {
        if (a == NONE || b == NONE) {
            return NONE;
        }
        if (a == ALL) {
            return b;
        }
        if (b == ALL) {
            return a;
        }
        throw new Error("General intersection of excludes not currently supported");
    }

    private Exclude(Collection<Rule> rules) {
        this.rules = rules;
    }

    public boolean match(KeyE key) {
        for (Rule r : this.rules) {
            if (!r.match(key)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this == ALL) {
            return "*";
        }
        return StringUtil.join(" && ", this.rules);
    }

    private static class Pattern {
        public static final Pattern ALL = Pattern.compile("*");
        private final boolean negative;
        private final java.util.regex.Pattern regexp;

        private Pattern(boolean negative, java.util.regex.Pattern regexp) {
            this.regexp = regexp;
            this.negative = negative;
        }

        public boolean matches(String s) {
            boolean r = this.regexp.matcher(s).matches();
            if (this.negative) {
                r = !r;
            }
            return r;
        }

        public static Pattern compile(String pattern) {
            if (pattern == null) {
                return ALL;
            }
            boolean negative = (pattern = pattern.trim()).startsWith("!");
            if (negative) {
                pattern = pattern.substring(1);
            }
            String regex = pattern.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*");
            return new Pattern(negative, java.util.regex.Pattern.compile(regex));
        }

        public String toString() {
            return String.valueOf(this.negative ? "!" : "") + this.regexp.pattern();
        }
    }

    public static class Rule {
        private static final Rule ALL = new Rule(null, null, null, null, null);
        final Pattern org;
        final Pattern name;
        final Pattern tag;
        final Pattern branch;
        final Pattern revision;

        public Rule(String org, String name, String tag, String branch, String revision) {
            this.org = Pattern.compile(org);
            this.name = Pattern.compile(name);
            this.tag = Pattern.compile(tag);
            this.branch = Pattern.compile(branch);
            this.revision = Pattern.compile(revision);
        }

        private Rule(CmnXml.SelectWithSource pattern) {
            this(pattern.org, pattern.name, pattern.getTag(), pattern.branch, pattern.revision);
        }

        private boolean match(KeyE key) {
            if (!this.org.matches(key.org)) {
                return false;
            }
            if (!this.name.matches(key.name)) {
                return false;
            }
            Version v = key.version;
            if (v.isTag()) {
                if (!this.tag.matches(v.getTag())) {
                    return false;
                }
            } else {
                if (!this.branch.matches(v.getBranch())) {
                    return false;
                }
                if (!this.revision.matches(v.getRevision())) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder r = new StringBuilder();
            if (Pattern.ALL != this.org) {
                r.append("org=/" + this.org + "/ ");
            }
            if (Pattern.ALL != this.name) {
                r.append("name=/" + this.name + "/ ");
            }
            if (Pattern.ALL != this.tag) {
                r.append("tag=/" + this.tag + "/ ");
            }
            if (Pattern.ALL != this.branch) {
                r.append("branch=/" + this.branch + "/ ");
            }
            if (Pattern.ALL != this.revision) {
                r.append("revision=/" + this.revision + "/ ");
            }
            return r.toString();
        }

        static /* synthetic */ Rule access$0() {
            return ALL;
        }
    }
}

