/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.impl;

import ebuild.api.IInput;
import ebuild.api.plugin.BuildPluginProblem;
import ebuild.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Input
implements IInput {
    final String key;
    final Collection<File> artifacts;

    public Input(String key, Collection<File> artifacts) {
        this.key = key;
        this.artifacts = artifacts;
    }

    public Collection<File> getArtifacts() {
        return this.artifacts;
    }

    public File expectLoneArtifact() throws BuildPluginProblem {
        if (this.artifacts.size() != 1) {
            boolean directories = true;
            for (File f : this.artifacts) {
                if (f.isDirectory()) continue;
                directories = false;
            }
            if (directories) {
                try {
                    File dir = FileUtil.createTempDirectory();
                    for (File f : this.artifacts) {
                        FileUtil.mergeCopy(f, dir);
                    }
                    return dir;
                }
                catch (IOException e) {
                    throw new BuildPluginProblem("Expected single artifact in input '" + this.key + "', got  " + this.artifacts.size() + ". Could not combine: " + e.getMessage());
                }
            }
            throw new BuildPluginProblem("Expected single artifact in input '" + this.key + "', got  " + this.artifacts.size());
        }
        return this.artifacts.iterator().next();
    }
}

