/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.impl;

import ebuild.api.common.Scope;
import ebuild.core.impl.Task;
import ebuild.util.StringUtil;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskSet
implements Iterable<Task> {
    public static TaskSet NONE = new TaskSet(EnumSet.noneOf(Task.class));
    private final EnumSet<Task> tasks;

    public TaskSet(Task task) {
        this(EnumSet.of(task));
    }

    private TaskSet(EnumSet<Task> tasks) {
        this.tasks = tasks;
    }

    public boolean has(Task t) {
        return this.tasks.contains((Object)t);
    }

    public boolean includes(TaskSet ts) {
        return this.tasks.containsAll(ts.tasks);
    }

    public TaskSet combine(TaskSet ts) {
        Object tasks2 = this.tasks.clone();
        ((AbstractCollection)tasks2).addAll(ts.tasks);
        return new TaskSet((EnumSet<Task>)tasks2);
    }

    public TaskSet replace(Task a, Task b) {
        TaskSet r = this;
        if (this.has(a)) {
            r = this.without(a).with(b);
        }
        return r;
    }

    public TaskSet with(Task task) {
        Object tasks2 = this.tasks.clone();
        ((AbstractCollection)tasks2).add(task);
        return new TaskSet((EnumSet<Task>)tasks2);
    }

    public TaskSet without(Task task) {
        if (!this.has(task)) {
            return this;
        }
        Object tasks2 = this.tasks.clone();
        ((AbstractCollection)tasks2).remove((Object)task);
        return new TaskSet((EnumSet<Task>)tasks2);
    }

    public boolean hasIDE() {
        return this.has(Task.eclipse_setup) || this.has(Task.eclipse_unsetup);
    }

    public TaskSet withoutIDE() {
        TaskSet r = this;
        r = r.without(Task.eclipse_setup);
        r = r.without(Task.eclipse_unsetup);
        return r;
    }

    public TaskSet tasksForBuilders() {
        TaskSet r = this;
        if (this.has(Task.eclipse_setup)) {
            r = this.with(Task.build_release);
        }
        if (this.has(Task.eclipse_unsetup)) {
            r = this.with(Task.build_clean);
        }
        return r;
    }

    public Scope getScope() {
        if (this.has(Task.eclipse_setup) || this.has(Task.eclipse_unsetup)) {
            return Scope.POKE;
        }
        return Scope.MAIN;
    }

    public boolean isEmpty() {
        return this.tasks.isEmpty();
    }

    @Override
    public Iterator<Task> iterator() {
        return this.tasks.iterator();
    }

    public String toString() {
        return StringUtil.join(",", this.tasks);
    }
}

