/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.util;

import ebuild.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionNumber
implements Comparable<VersionNumber> {
    private final int[] value;

    public VersionNumber(int ... value) {
        this.value = value;
    }

    public static VersionNumber fromString(String s) {
        String[] ss = s.split("\\.");
        int[] is = new int[ss.length];
        if (is.length == 0) {
            return null;
        }
        int i = 0;
        while (i < ss.length) {
            Integer n = StringUtil.tryParseInt(ss[i]);
            if (n == null) {
                return null;
            }
            is[i] = n;
            ++i;
        }
        return new VersionNumber(is);
    }

    public boolean equals(Object obj) {
        if (obj instanceof VersionNumber) {
            VersionNumber b = (VersionNumber)obj;
            if (b.value.length != this.value.length) {
                return false;
            }
            int i = 0;
            while (i < this.value.length) {
                if (b.value[i] != this.value[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        while (i < this.value.length) {
            h = 31 * h + this.value[i];
            ++i;
        }
        return h;
    }

    @Override
    public int compareTo(VersionNumber b) {
        int la = this.value.length;
        int lb = b.value.length;
        int l = Math.min(la, lb);
        int i = 0;
        while (i < l) {
            int va = this.value[i];
            int vb = b.value[i];
            if (va > vb) {
                return 1;
            }
            if (vb > va) {
                return -1;
            }
            ++i;
        }
        return la - lb;
    }

    public String toString() {
        return StringUtil.join(".", this.value);
    }
}

