/*
 * Decompiled with CFR 0.152.
 */
package ebuild.base;

import ebuild.api.repo.RepositoryPluginException;
import ebuild.base.Backtrace;

public class EBuildException
extends Exception {
    public final Category category;
    public final boolean handledCause;

    private EBuildException(String msg, Throwable t, Category category) {
        this(msg, t, category, false);
    }

    private EBuildException(String msg, Throwable t, Category category, boolean handledCause) {
        super(Backtrace.modifyMessage("[" + (Object)((Object)category) + "] " + msg), t);
        this.category = category;
        this.handledCause = handledCause;
    }

    public static EBuildException wrapPluginException(String msg, RepositoryPluginException e) {
        return EBuildException.newProblem(msg, (Throwable)e);
    }

    public static EBuildException wrapException(String msg, Throwable t) {
        if (t instanceof EBuildException) {
            return new EBuildException(msg, t, Category.not_possible);
        }
        return EBuildException.newInternalError(msg, t);
    }

    public static EBuildException newBadRequest(String msg) {
        return new EBuildException(msg, null, Category.bad_request);
    }

    public static EBuildException newRepoIssue(String msg) {
        return new EBuildException(msg, null, Category.repository_issue);
    }

    public static EBuildException newRepoIssue(String msg, Throwable cause) {
        return new EBuildException(msg, cause, Category.repository_issue);
    }

    public static EBuildException newPluginProblem(String msg) {
        return new EBuildException(msg, null, Category.plugin_problem);
    }

    public static EBuildException newPluginProblem(String msg, Throwable cause) {
        return new EBuildException(msg, cause, Category.plugin_problem);
    }

    public static EBuildException newConfProblem(String msg) {
        return new EBuildException(msg, null, Category.conf_problem);
    }

    public static EBuildException newConfProblem(String msg, Throwable cause) {
        return new EBuildException(msg, cause, Category.conf_problem, true);
    }

    public static EBuildException newInternalError(String msg) {
        return new EBuildException(msg, null, Category.internal_error);
    }

    public static EBuildException newInternalError(String msg, Throwable cause) {
        return new EBuildException(msg, cause, Category.internal_error);
    }

    @Deprecated
    public static EBuildException newProblem(String msg) {
        return EBuildException.newProblem(msg, null);
    }

    @Deprecated
    public static EBuildException newProblem(String msg, Throwable cause) {
        return new EBuildException(msg, cause, Category.uncategorised_problem);
    }

    @Deprecated
    public static EBuildException newError(String msg, Throwable cause) {
        return new EBuildException(msg, cause, Category.internal_error);
    }

    public String toString() {
        return this.getMessage();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Category {
        bad_request,
        plugin_problem,
        conf_problem,
        internal_error,
        repository_issue,
        not_possible,
        uncategorised_problem;


        public String toString() {
            return super.toString().replace('_', ' ');
        }
    }
}

