/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.base.Backtrace;
import ebuild.base.EBuildException;
import ebuild.core.BuildPluginDef;
import ebuild.core.EBuild;
import ebuild.core.EBuildContextOfXml;
import ebuild.core.Element;
import ebuild.core.Module;
import ebuild.core.RepositoryInstance;
import ebuild.core.RepositoryRef;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.KeyE;
import ebuild.core.impl.Version;
import ebuild.core.util.PObject;
import ebuild.util.Callable;
import ebuild.util.tuple.Pair;
import ebuild.xml.CmnXml;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class EBuildContext {
    private static final int REPOSITORIES = 0;
    private static final int BUILDERS = 1;
    private static final int SIZE = 2;
    private Map<Object, BuildPluginDef> localBuildPluginDefMap = new HashMap<Object, BuildPluginDef>(0);
    private final PObject[] pobjs = new PObject[2];
    final String name;
    final EBuild ebuild;
    private List<EBuildContext> parents;
    private boolean inited;
    private Map<Pair<String, KeyE>, Element> resolvedElements;

    public EBuildContext(String name, EBuild ebuild) {
        int i = 0;
        while (i < 2) {
            this.pobjs[i] = new PObject();
            ++i;
        }
        this.parents = new LinkedList<EBuildContext>();
        this.inited = false;
        this.resolvedElements = new HashMap<Pair<String, KeyE>, Element>();
        this.name = name;
        this.ebuild = ebuild;
    }

    public EBuildContext(EBuild ebuild) {
        this("root context", ebuild);
    }

    public Version assignDefaults(RepositoryRef repoRef, KeyE dkey0) throws EBuildException {
        Version dversion = (Version)dkey0.getVersion();
        return dversion.withDefault(Version.TRUNK_HEAD);
    }

    public boolean isInited() {
        return this.inited;
    }

    public void init() {
        this.inited = true;
    }

    public boolean isXmlContext() {
        return this instanceof EBuildContextOfXml;
    }

    public void addParents(EBuildContext ... parentContexts) {
        EBuildContext[] eBuildContextArray = parentContexts;
        int n = parentContexts.length;
        int n2 = 0;
        while (n2 < n) {
            EBuildContext parentContext = eBuildContextArray[n2];
            this.parents.add(parentContext);
            ++n2;
        }
        int i = 0;
        while (i < 2) {
            PObject[] prototypes = new PObject[parentContexts.length];
            int j = 0;
            EBuildContext[] eBuildContextArray2 = parentContexts;
            int n3 = parentContexts.length;
            int n4 = 0;
            while (n4 < n3) {
                EBuildContext parentContext = eBuildContextArray2[n4];
                prototypes[j] = parentContext.pobjs[i];
                ++j;
                ++n4;
            }
            this.pobjs[i].addPrototypes(prototypes);
            ++i;
        }
    }

    public BuildPluginDef getBuildPluginDefById(String id) {
        return (BuildPluginDef)this.pobjs[1].get(id);
    }

    public void addBuildPluginDef(Object localKey, String id, BuildPluginDef value) {
        if (id != null) {
            this.pobjs[1].put(id, value);
        }
        this.localBuildPluginDefMap.put(localKey, value);
    }

    public BuildPluginDef expectBuildPluginDefById(String id) throws EBuildException {
        BuildPluginDef r = this.getBuildPluginDefById(id);
        if (r == null) {
            throw EBuildException.newConfProblem("No such build plugin in scope: " + id);
        }
        return r;
    }

    public BuildPluginDef expectBuildPluginDefByLocalKey(Object localKey) throws EBuildException {
        BuildPluginDef r = this.localBuildPluginDefMap.get(localKey);
        if (r == null) {
            throw new Error("Build plugin not registered: " + localKey);
        }
        return r;
    }

    public RepositoryRef getRepository(String key) {
        return (RepositoryRef)this.pobjs[0].get(key);
    }

    public RepositoryRef addRepository(RepositoryRef value) {
        this.pobjs[0].put(value.name, value);
        return value;
    }

    public RepositoryRef addLocalRepository(RepositoryInstance repository, String defaultOrg) {
        RepositoryRef.LocalRef r = new RepositoryRef.LocalRef(this, repository);
        r.setDefaultOrg(defaultOrg);
        return this.addRepository(r);
    }

    public RepositoryRef addNamedRepository(String name, RepositoryInstance repository, String defaultOrg) throws EBuildException {
        if ("local".equals(name)) {
            throw EBuildException.newConfProblem("Cannot name a repository 'local'");
        }
        RepositoryRef.NamedRef r = new RepositoryRef.NamedRef(this, name, repository);
        r.setDefaultOrg(defaultOrg);
        return this.addRepository(r);
    }

    public void addRepository(final CmnXml.Repository repoXml) throws EBuildException {
        RepositoryRef r;
        String msg = repoXml.validate();
        if (msg != null) {
            throw EBuildException.newConfProblem("Invalid repository definition: " + msg);
        }
        if (repoXml.ref != null) {
            RepositoryRef prototype = this.getRepository(repoXml.ref);
            Version v = EBuildUtil.asVersion(repoXml);
            if (v == null && prototype.isLocal()) {
                throw EBuildException.newConfProblem("Unsupported operation. Not currently possible to derive from a local reference: " + prototype.name);
            }
            r = new RepositoryRef.DerivedRef(prototype, this, repoXml.name);
            this.addRepository(r);
        } else {
            r = new RepositoryRef.LazyRef(this, repoXml.name, null, new Callable<RepositoryInstance, EBuildException>(){

                @Override
                public RepositoryInstance run() throws EBuildException {
                    return EBuildContext.this.ebuild.REPOS.getRepository(repoXml.type, repoXml.url);
                }
            });
            this.addRepository(r);
        }
        r.setDefaultOrg(repoXml.org);
        r.setDefaultVersion(EBuildUtil.asVersion(repoXml));
    }

    public RepositoryRef lookupRepository(String source) throws EBuildException {
        if ("system".equals(source)) {
            return null;
        }
        RepositoryRef repo = this.getRepository(source);
        if (repo == null) {
            if (!this.isInited()) {
                throw new Error("Context not initialised " + this + " " + source);
            }
            throw EBuildException.newConfProblem("Bad source, no repository defined in scope '" + this + "'for '" + source + "'");
        }
        return repo;
    }

    protected Element resolveMoving(RepositoryRef repoRef, KeyE dkey) throws EBuildException {
        String revision = repoRef.getRepo().asSource().getRevisionOfHead();
        dkey = dkey.withRevision(revision);
        return this.resolveLibraryPart(repoRef, dkey);
    }

    public Element resolveElement(String source, KeyE dkey) throws EBuildException {
        Backtrace.start("resolve", dkey);
        try {
            Pair<String, KeyE> key = new Pair<String, KeyE>(source, dkey);
            Element r = this.resolvedElements.get(key);
            if (r == null) {
                r = this.resolveElementInner(source, dkey);
                this.resolvedElements.put(key, r);
            }
            this.ebuild.report.resolve(dkey, r);
            Element element = r;
            return element;
        }
        finally {
            Backtrace.end(dkey);
        }
    }

    public Module resolveModule(String source, KeyE dkey) throws EBuildException {
        return (Module)this.resolveElement(source, dkey);
    }

    Element resolveLibraryPart(RepositoryRef repoRef, KeyE key) throws EBuildException {
        return this.ebuild.LIBRARY.resolveElement(repoRef, key);
    }

    Element resolveElementInner(String source, KeyE dkey0) throws EBuildException {
        RepositoryRef repoRef = this.lookupRepository(source);
        KeyE dkey = dkey0.withVersion(this.assignDefaults(repoRef, dkey0));
        if (dkey.version.isMoving()) {
            if (repoRef.xmlContextTrait == null) {
                throw EBuildException.newConfProblem("Element source '" + repoRef.name + "' does not support moving version '" + dkey.version.getRevision() + "'");
            }
            return this.resolveMoving(repoRef, dkey);
        }
        return this.resolveLibraryPart(repoRef, dkey);
    }

    public String toString() {
        return this.name;
    }
}

