/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.base.EBuildException;
import ebuild.core.EBuild;
import ebuild.core.EBuildContextOfXml;
import ebuild.core.ElementC;
import ebuild.core.ElementMeta;
import ebuild.core.ElementProject;
import ebuild.core.ElementRelease;
import ebuild.core.ProjectHelper;
import ebuild.core.RepositoryInstance;
import ebuild.core.WorkspaceElementProject;
import ebuild.core.WorkspaceProject;
import ebuild.core.conf.ConfMap;
import ebuild.core.impl.ConfKey;
import ebuild.core.impl.EBuildMode;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.KeyE;
import ebuild.core.impl.Version;
import ebuild.util.FileUtil;
import ebuild.util.StringUtil;
import ebuild.xml.CmnXml;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Element {
    public final EBuild ebuild;
    public final EBuildContextOfXml context;
    private RepositoryInstance repository = null;
    private WorkspaceProject workingCopy = null;
    public final KeyE key;
    public final ElementMeta META;
    public final ElementProject PROJECT;
    public final ElementRelease RELEASE;
    private ProjectHelper projectHelper;
    private WorkspaceElementProject eclipseProject;
    private Map<ConfKey, ElementC> elementCs = new HashMap<ConfKey, ElementC>();
    private final Map<String, ConfMap> confMap = new HashMap<String, ConfMap>();
    private final Set<String> confNorecur = new LinkedHashSet<String>();

    public Element(EBuild ebuild, KeyE key, ElementMeta meta, ElementProject project, ElementRelease release, EBuildContextOfXml.Type contextType) throws EBuildException {
        assert (key.universe != null);
        this.ebuild = ebuild;
        this.key = key;
        this.META = meta;
        this.PROJECT = project;
        this.RELEASE = release;
        this.context = new EBuildContextOfXml(this, contextType);
        if (this.isSource()) {
            this.projectHelper = this.newProjectHelper();
        }
    }

    public abstract ElementC newCElement(ConfKey var1, ConfMap var2);

    public abstract ProjectHelper newProjectHelper() throws EBuildException;

    public abstract ElementType getType();

    public EBuildMode getMode() {
        return this.getMETA().getMode();
    }

    public ElementMeta getMETA() {
        return this.META;
    }

    public boolean isWorkspace() {
        return this.getMode() == EBuildMode.workspace;
    }

    public RepositoryInstance getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryInstance repository) {
        this.repository = repository;
        this.context.addLocalRepository(repository, this.key.org);
        if (this.isSourceWithBuild()) {
            this.getProjectHelper().contextOfBuild.addLocalRepository(repository, this.key.org);
        }
    }

    public WorkspaceProject getWorkspaceProject() {
        return this.workingCopy;
    }

    public void setWorkspaceProject(WorkspaceProject workingCopy) {
        this.workingCopy = workingCopy;
    }

    public String getName() {
        return this.key.fullname();
    }

    public Version getVersion() {
        return this.key.version;
    }

    public String toString() {
        return "" + this.key;
    }

    public boolean hasBuildDirectory() {
        return this.RELEASE.buildDir.exists();
    }

    public File getBuildDirectory() {
        return this.RELEASE.buildDir;
    }

    public boolean hasReleaseDirectory() {
        return this.RELEASE.releaseDir.exists();
    }

    public File getReleaseDirectory() {
        return this.RELEASE.releaseDir;
    }

    public boolean hasProjectDirectory() {
        return this.PROJECT != null;
    }

    public File getProjectDirectory() {
        return this.PROJECT.dir;
    }

    public boolean buildIsClean() {
        return !this.hasBuildDirectory() && !this.hasReleaseDirectory();
    }

    public void buildClean() {
        FileUtil.deleteDir(this.getBuildDirectory());
        FileUtil.deleteDir(this.getReleaseDirectory());
    }

    public ProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    public ProjectHelper expectProjectHelper() throws EBuildException {
        ProjectHelper r = this.getProjectHelper();
        if (r == null) {
            throw EBuildException.newConfProblem("Build context unavailable: " + this.key);
        }
        return r;
    }

    private ConfMap getConfs(String conf) throws EBuildException {
        if (this.confNorecur.contains(conf)) {
            throw EBuildException.newConfProblem("Loop: " + StringUtil.join(",", this.confNorecur));
        }
        this.confNorecur.add(conf);
        try {
            ConfMap r = this.confMap.get(conf);
            if (r == null) {
                ConfMap.Builder b = new ConfMap.Builder();
                CmnXml.Configuration cxml = this.META.getConfXml(conf);
                boolean isDefault = "[default]".equals(conf);
                if (cxml == null) {
                    if (!isDefault) {
                        b.add(conf);
                    }
                } else {
                    ConfMap inc = EBuildUtil.parseConfMap(cxml.includes);
                    for (String c : inc) {
                        b.addAll(this.getConfs(c));
                    }
                    if (!cxml.alias && !isDefault) {
                        b.add(conf);
                    }
                    ConfMap exc = EBuildUtil.parseConfMap(cxml.excludes);
                    for (String c : exc.asCollection()) {
                        b.removeAll(this.getConfs(c));
                    }
                }
                r = b.build();
                this.confMap.put(conf, r);
            }
            ConfMap confMap = r;
            return confMap;
        }
        finally {
            this.confNorecur.remove(conf);
        }
    }

    private ConfMap actualConfiguration(ConfMap configurationSelected) throws EBuildException {
        ConfMap.Builder b = new ConfMap.Builder();
        ConfMap defaultConfs = this.getConfs("[default]");
        b.addAll(defaultConfs);
        for (String c : configurationSelected) {
            b.addAll(this.getConfs(c));
        }
        return b.build();
    }

    public ElementC getDefault() throws EBuildException {
        return this.getCPart(ConfKey.DEFAULT);
    }

    public ElementC getCPart(ConfKey subKey0) throws EBuildException {
        ConfMap configuration = this.actualConfiguration(subKey0.conf);
        ConfKey subKey = new ConfKey(configuration);
        ElementC r = this.elementCs.get(subKey);
        if (r == null) {
            r = this.newCElement(subKey, subKey0.conf);
            this.elementCs.put(r.key.subkey, r);
        }
        return r;
    }

    public WorkspaceElementProject createEclipseProject(ElementC cElement) {
        if (this.eclipseProject == null) {
            this.eclipseProject = cElement.newEclipseProject();
            try {
                this.eclipseProject.storeConfiguration();
            }
            catch (IOException e) {
                throw new Error("Unable to store configuration", e);
            }
            return this.eclipseProject;
        }
        if (cElement.getConfiguration().equals(this.eclipseProject.getConfiguration())) {
            return this.eclipseProject;
        }
        throw new Error("Attempted to have eclipse project for '" + this.key + "'with 2 different configurations: " + "\n" + cElement.getConfiguration() + "\n" + this.eclipseProject.getConfiguration());
    }

    public WorkspaceElementProject expectEclipseProject() {
        if (this.eclipseProject == null) {
            throw new RuntimeException("No eclipse project for " + this.key);
        }
        return this.eclipseProject;
    }

    public boolean isSource() {
        return this.META.isSource();
    }

    public boolean isSourceWithBuild() {
        return this.META.isSource() && this.getProjectHelper().contextOfBuild != null;
    }

    public void addIgnores(String ... patterns) {
        if (!this.isWorkspace()) {
            throw new Error("Tryed to add a ignores to a non-workspace element: " + this);
        }
        WorkspaceProject wc = this.getWorkspaceProject();
        if (wc == null) {
            return;
        }
        wc.workingCopy.addIgnores(patterns);
    }

    public Date getLastCommitDate() {
        if (this.isWorkspace()) {
            return new Date();
        }
        Date r = this.META.getMetaDir().getTimestamp();
        if (r == null) {
            r = new Date(this.getProjectDirectory().lastModified());
        }
        return r;
    }

    public String elementName() {
        return this.key.type.name();
    }

    public String builderName() {
        if (this.key.type == ElementType.product) {
            return "assembler";
        }
        return "builder";
    }

    public List<File> getMetaFiles() throws EBuildException {
        return this.META.getMetaDir().getMetaFiles(this.key.type);
    }

    public File getMetaMainFile() throws EBuildException {
        return this.META.getMetaDir().getMetaFile(this.key.type);
    }
}

