/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.conf.ConfMap;
import ebuild.core.impl.BuildMode;
import ebuild.core.impl.Version;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Project<P extends Element> {
    protected final ElementC<P> elementC;

    protected Project(ElementC<P> cElement) {
        this.elementC = cElement;
    }

    public P getPart() {
        return this.elementC.element;
    }

    public ConfMap getConfiguration() {
        return this.elementC.getConfiguration();
    }

    public ConfMap getConfigurationSelected() {
        return this.elementC.getConfigurationSelected();
    }

    public abstract BuildMode mode();

    public ElementC getCPart() {
        return this.elementC;
    }

    public String getName() {
        return ((Element)this.getPart()).getName();
    }

    public Version getVersion() {
        return ((Element)this.getPart()).getVersion();
    }

    public File getProjectFile(String path) {
        return new File(((Element)this.getPart()).getProjectDirectory(), path);
    }

    public boolean isBuilt() {
        return this.elementC.getReleaseFile().exists();
    }

    public String toString() {
        return String.valueOf(this.mode().code) + " " + ((Element)this.getPart()).key + " " + this.getConfiguration();
    }
}

