/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.impl;

import ebuild.api.common.IVersion;
import ebuild.util.ObjectUtil;

public abstract class Version
implements IVersion {
    public static final String DEFAULT_STR = "[default]";
    public static final Version DEFAULT = Version.newRevision(null);
    public static final Version TRUNK_HEAD = Version.newRevision("trunk", "head");

    public static Version newTag(String tag) {
        return new Tag(tag);
    }

    public static Version newRevision(String revision) {
        return Version.newRevision(null, revision);
    }

    public static Version newRevision(String branch, String revision) {
        if (branch == null) {
            branch = DEFAULT_STR;
        }
        if (revision == null) {
            revision = DEFAULT_STR;
        }
        return new Revision(branch, revision);
    }

    public abstract boolean isDefaultBranch();

    public abstract String getBranchNoDefault();

    public abstract String getRevisionNoDefault();

    public Version withBranch(String branch) {
        if (branch == this.getBranch()) {
            return this;
        }
        return Version.newRevision(branch, this.getRevisionNoDefault());
    }

    public Version withRevision(String revision) {
        if (revision == this.getRevision()) {
            return this;
        }
        return Version.newRevision(this.getBranchNoDefault(), revision);
    }

    public Version withTag(String tag) {
        return Version.newTag(tag);
    }

    public Version withDefault(Version default_) {
        boolean defaultBranch = DEFAULT_STR.equals(this.getBranch());
        boolean defaultRevision = DEFAULT_STR.equals(this.getRevision());
        if (defaultBranch && defaultRevision) {
            return default_;
        }
        Version r = this;
        if (defaultBranch) {
            r = r.withBranch("trunk");
        }
        if (defaultRevision) {
            r = r.withRevision("head");
        }
        return r;
    }

    public boolean isMoving() {
        return this.isHead() || this.isWorking();
    }

    public boolean isTrunk() {
        return "trunk".equals(this.getBranch());
    }

    public String getTagSuper() {
        String t = this.getTag();
        int dash = t.indexOf(45);
        if (dash == -1) {
            return t;
        }
        return t.substring(0, dash);
    }

    public boolean hasTagSub() {
        return this.getTag().indexOf(45) != -1;
    }

    public Version withoutTagSub() {
        return this.withTag(this.getTagSuper());
    }

    public static Version fromString(String s, Version v) {
        if (s == null) {
            return v;
        }
        return Version.fromString(s);
    }

    public static Version fromString(String s) {
        String revision = null;
        String branch = null;
        if (s.startsWith("branch_")) {
            int dash = (s = s.substring("branch_".length())).indexOf(45);
            branch = dash != -1 ? s.substring(0, dash) : s;
            s = s.substring(branch.length());
        }
        if (s.startsWith("rev_")) {
            revision = s = s.substring("rev_".length());
        } else if (s.equals("working")) {
            revision = s;
        }
        if (revision == null && branch == null) {
            return Version.newTag(s);
        }
        return Version.newRevision(branch, revision);
    }

    static class Revision
    extends Version {
        private final String branch;
        private final String revision;

        private Revision(String branch, String revision) {
            this.branch = branch;
            this.revision = revision;
        }

        public boolean isTag() {
            return false;
        }

        public boolean isWorking() {
            return "working".equals(this.revision);
        }

        public boolean isHead() {
            return "head".equals(this.getRevision());
        }

        public String getBranch() {
            return this.branch == null ? "trunk" : this.branch;
        }

        public String getRevision() {
            return this.revision == null ? "head" : this.revision;
        }

        public String getTag() {
            return null;
        }

        public String getBranchNoDefault() {
            return Version.DEFAULT_STR.equals(this.branch) ? null : this.branch;
        }

        public String getRevisionNoDefault() {
            return Version.DEFAULT_STR.equals(this.revision) ? null : this.revision;
        }

        public boolean isDefaultBranch() {
            return Version.DEFAULT_STR.equals(this.branch);
        }

        public int hashCode() {
            return ObjectUtil.hashOf(this.branch) + ObjectUtil.hashOf(this.revision);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Revision)) {
                return false;
            }
            Revision b = (Revision)obj;
            return ObjectUtil.areEqual(this.getBranch(), b.getBranch()) && ObjectUtil.areEqual(this.getRevision(), b.getRevision());
        }

        public String toString() {
            String r = this.isWorking() ? "working" : "rev_" + this.getRevision();
            if (!"trunk".equals(this.getBranch())) {
                r = "branch_" + this.branch + "-" + r;
            }
            return r;
        }
    }

    static class Tag
    extends Version {
        private final String tag;

        private Tag(String tag) {
            this.tag = tag;
        }

        public boolean isTag() {
            return true;
        }

        public boolean isWorking() {
            return false;
        }

        public boolean isHead() {
            return false;
        }

        public String getBranch() {
            return null;
        }

        public String getRevision() {
            return null;
        }

        public String getTag() {
            return this.tag;
        }

        public String getBranchNoDefault() {
            return null;
        }

        public String getRevisionNoDefault() {
            return null;
        }

        public boolean isDefaultBranch() {
            return false;
        }

        public int hashCode() {
            return ObjectUtil.hashOf(this.tag);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Tag)) {
                return false;
            }
            Tag b = (Tag)obj;
            return ObjectUtil.areEqual(this.tag, b.tag);
        }

        public String toString() {
            return this.tag;
        }
    }
}

