/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.Scope;
import ebuild.base.Backtrace;
import ebuild.base.EBuildException;
import ebuild.base.Task;
import ebuild.core.Action;
import ebuild.core.ActionQueue;
import ebuild.core.BuildPluginDef;
import ebuild.core.BuildResolutionReport;
import ebuild.core.EBuild;
import ebuild.core.EBuildContextOfXml;
import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.ElementDeps;
import ebuild.core.Module;
import ebuild.core.ModuleBuildPlan;
import ebuild.core.ModuleC;
import ebuild.core.ProjectHelper;
import ebuild.core.conf.ConfMap;
import ebuild.core.impl.BuildTask;
import ebuild.core.impl.BuildTaskSet;
import ebuild.core.impl.ConfKey;
import ebuild.core.impl.KeyC;
import ebuild.core.util.WorkMarker;
import ebuild.xml.CmnXml;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class BuildPlan {
    final EBuild ebuild;
    final BuildResolutionReport report;
    final Object key;
    protected Set<Object> builderPlans = new LinkedHashSet<Object>();
    private boolean resolvedAndConfigured = false;

    public BuildPlan(EBuild ebuild, Object key) {
        this.ebuild = ebuild;
        this.report = ebuild.report;
        this.key = key;
        ebuild.buildPlans.put(this.getKey(), this);
    }

    public Object getKey() {
        return this.key;
    }

    protected abstract void resolveBuilders(BuildTaskSet var1) throws EBuildException;

    protected abstract void resolveAndConfigureDependencies(BuildTaskSet var1) throws EBuildException;

    protected abstract void buildActionListForPlan(ActionQueue var1, BuildTaskSet var2) throws Exception;

    private BuildTaskSet buildTasks(BuildTaskSet tasks) {
        if (this instanceof ModuleBuildPlan) {
            return tasks.tasksForBuilders();
        }
        return tasks;
    }

    public void resolveAndConfigure(BuildTaskSet tasks) throws EBuildException {
        if (this.resolvedAndConfigured) {
            return;
        }
        Object key = this.getKey();
        Task.start("resolve and configure", key);
        try {
            this.resolveAndConfigureDependencies(tasks);
            this.resolveBuilders(tasks);
            BuildTaskSet btasks = this.buildTasks(tasks);
            for (Object subKey : this.builderPlans) {
                ModuleBuildPlan subPlan = (ModuleBuildPlan)this.ebuild.buildPlans.get(subKey);
                subPlan.resolveAndConfigure(btasks);
            }
            this.resolvedAndConfigured = true;
        }
        finally {
            Task.end(key);
        }
    }

    public void buildActionList(ActionQueue queue, BuildTaskSet tasks) throws Exception {
        BuildTaskSet btasks = this.buildTasks(tasks);
        for (Object subKey : this.builderPlans) {
            ModuleBuildPlan subPlan = (ModuleBuildPlan)this.ebuild.buildPlans.get(subKey);
            subPlan.buildActionList(queue, btasks);
        }
        this.buildActionListForPlan(queue, tasks);
    }

    protected void buildActionListForPart(ActionQueue queue, ElementC elementC, BuildTaskSet tasks) throws Exception {
        if (((Element)elementC.element).META.isExternal()) {
            return;
        }
        for (BuildTask t : tasks) {
            this.buildActionListForPart(queue, elementC, t);
        }
    }

    protected void buildActionListForPart(ActionQueue queue, ElementC cElement, BuildTask task) throws Exception {
        Object element = cElement.getPart();
        if (!((Element)element).isWorkspace()) {
            if (((Element)element).isSource()) {
                WorkMarker marker = new WorkMarker(((Element)element).getProjectDirectory());
                Action.FetchSource action = new Action.FetchSource(marker, (Element)element);
                queue.add(action);
            } else {
                ElementC elementC1 = cElement.getCompiled();
                queue.add(new Action.FetchArtifacts(elementC1));
            }
            if (task.isIDE()) {
                throw new Error("Tried to do IDE task on a library element: " + cElement);
            }
            if (task == BuildTask.release_source) {
                return;
            }
        }
        switch (task) {
            case build_release: {
                if (!((Element)element).isSource()) break;
                queue.add(new Action.BuildRelease(cElement.getCompiled()));
                break;
            }
            case build_clean: {
                if (!((Element)element).isSource()) break;
                queue.add(new Action.BuildClean(cElement));
                break;
            }
            case eclipse_setup: {
                if (!((Element)element).isWorkspace()) break;
                queue.add(new Action.EclipseSetup(cElement));
                break;
            }
            case eclipse_unsetup: {
                cElement.createEclipseProject();
                queue.add(new Action.EclipseUnsetup(cElement));
            }
        }
    }

    protected void resolveBuildPluginsForPart(ElementC elementC) throws EBuildException {
        Object element = elementC.element;
        if (!((Element)element).isSourceWithBuild()) {
            return;
        }
        ProjectHelper phelper = ((Element)element).getProjectHelper();
        EBuildContextOfXml bcontext = phelper.contextOfBuild.resolveSelf();
        ElementDeps deps = elementC.getDependencies(Scope.MAIN);
        Map<Object, ? extends CmnXml.SelectBuildPlugin> ds = ((Element)element).PROJECT.META.getBuildDependencies(elementC.getSubKey());
        for (Object localKey : ds.keySet()) {
            BuildPluginDef pluginDef = bcontext.expectBuildPluginDefByLocalKey(localKey);
            ConfMap bconf = pluginDef.mapping.evaluate(elementC.getConfiguration());
            Module bmodule = pluginDef.module;
            ModuleC bmoduleC = bmodule.getCPart(new ConfKey(bconf)).getCompiled();
            KeyC bkey = bmoduleC.key;
            Backtrace.start("resolve builder", bkey);
            try {
                ModuleBuildPlan bplan = (ModuleBuildPlan)this.ebuild.buildPlans.get(bkey);
                if (bplan == null) {
                    bplan = new ModuleBuildPlan(this.ebuild, bmoduleC);
                    assert (bplan.getKey().equals(bkey));
                    assert (this.ebuild.buildPlans.get(bkey) != null);
                }
                Backtrace.checkCycle("resolve and configure", bplan.getKey());
                this.builderPlans.add(bplan.getKey());
                deps.addBuilder(bmoduleC);
            }
            finally {
                Backtrace.end(bkey);
            }
        }
    }

    public String toString() {
        return "" + this.getKey();
    }
}

