/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.log.ILogger;
import ebuild.core.EBuild;
import ebuild.core.EBuildContext;
import ebuild.core.Element;
import ebuild.core.conf.ConfMap;
import ebuild.core.impl.DependencyType;
import ebuild.core.impl.KeyE;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;

public interface BuildResolutionReport {
    public void startResolve(EBuildContext var1, String var2);

    public void endResolve();

    public void resolve(DependencyType var1, KeyE var2, Element var3);

    public void configure(KeyE var1, ConfMap var2);

    public static class Database
    implements BuildResolutionReport {
        public final Map<Object, Entry> entries = new HashMap<Object, Entry>();
        private final Stack<EBuildContext> stack = new Stack();

        private EBuildContext context() {
            return this.stack.peek();
        }

        private Comparable currentKey() {
            return (Comparable)this.context().getKey();
        }

        public void startResolve(EBuildContext context, String dependencyType) {
            this.stack.push(context);
        }

        public void endResolve() {
            this.stack.pop();
        }

        public Entry getEntry(Object key) {
            Entry r = this.entries.get(key);
            if (r == null) {
                r = new Entry(key);
                this.entries.put(key, r);
            }
            return r;
        }

        public void resolve(DependencyType depType, KeyE k0, Element resolved) {
            KeyE k1 = resolved.key;
            ResolvedKey rk = new ResolvedKey(depType, k0, k1);
            this.getEntry((Object)this.currentKey()).outgoing.add(rk);
            this.getEntry((Object)k1).incoming.put(this.currentKey(), rk);
        }

        public void configure(KeyE key, ConfMap conf) {
        }

        public static class Entry {
            public final Object key;
            public final Set<ResolvedKey> outgoing = new TreeSet<ResolvedKey>();
            public final Map<Comparable, ResolvedKey> incoming = new TreeMap<Comparable, ResolvedKey>(new Comparator<Comparable>(){

                @Override
                public int compare(Comparable o1, Comparable o2) {
                    if (o1.equals(o2)) {
                        return 0;
                    }
                    boolean s1 = o1 instanceof String;
                    boolean s2 = o2 instanceof String;
                    if (s1 != s2) {
                        return s1 ? -1 : 1;
                    }
                    return o1.compareTo(o2);
                }
            });

            Entry(Object key) {
                this.key = key;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ResolvedKey
        implements Comparable<ResolvedKey> {
            public final DependencyType depType;
            public final KeyE selected;
            public final KeyE resolved;

            ResolvedKey(DependencyType depType, KeyE selected, KeyE resolved) {
                if (depType == null) {
                    throw new NullPointerException();
                }
                this.depType = depType;
                this.selected = selected;
                this.resolved = resolved;
            }

            public boolean isDifferent() {
                return !this.selected.equals(this.resolved);
            }

            @Override
            public int compareTo(ResolvedKey b) {
                int r = this.depType.compareTo(b.depType);
                if (r != 0) {
                    return r;
                }
                r = this.selected.compareTo(b.selected);
                if (r != 0) {
                    return r;
                }
                r = this.resolved.compareTo(b.resolved);
                return r;
            }

            public int hashCode() {
                return this.depType.hashCode() + this.selected.hashCode() + this.resolved.hashCode();
            }

            public boolean equals(Object obj) {
                ResolvedKey b = (ResolvedKey)obj;
                return this.resolved.equals(b.resolved) && this.selected.equals(b.selected);
            }
        }
    }

    public static class Tee
    implements BuildResolutionReport {
        final BuildResolutionReport[] subs;

        public Tee(BuildResolutionReport ... subs) {
            this.subs = subs;
        }

        public void resolve(DependencyType depType, KeyE k0, Element resolved) {
            BuildResolutionReport[] buildResolutionReportArray = this.subs;
            int n = this.subs.length;
            int n2 = 0;
            while (n2 < n) {
                BuildResolutionReport bsr = buildResolutionReportArray[n2];
                bsr.resolve(depType, k0, resolved);
                ++n2;
            }
        }

        public void configure(KeyE key, ConfMap conf) {
            BuildResolutionReport[] buildResolutionReportArray = this.subs;
            int n = this.subs.length;
            int n2 = 0;
            while (n2 < n) {
                BuildResolutionReport bsr = buildResolutionReportArray[n2];
                bsr.configure(key, conf);
                ++n2;
            }
        }

        public void startResolve(EBuildContext context, String dependencyType) {
            BuildResolutionReport[] buildResolutionReportArray = this.subs;
            int n = this.subs.length;
            int n2 = 0;
            while (n2 < n) {
                BuildResolutionReport bsr = buildResolutionReportArray[n2];
                bsr.startResolve(context, dependencyType);
                ++n2;
            }
        }

        public void endResolve() {
            BuildResolutionReport[] buildResolutionReportArray = this.subs;
            int n = this.subs.length;
            int n2 = 0;
            while (n2 < n) {
                BuildResolutionReport bsr = buildResolutionReportArray[n2];
                bsr.endResolve();
                ++n2;
            }
        }
    }

    public static class Terse
    implements BuildResolutionReport {
        final ILogger logger;
        Set done = new HashSet();

        public Terse(ILogger logger) {
            this.logger = logger;
        }

        private void log(String msg) {
            if (!this.done.contains(msg)) {
                this.logger.log(msg);
                this.done.add(msg);
            }
        }

        public void resolve(DependencyType depType, KeyE k0, Element resolved) {
            this.log("  resolve: " + Verbose.resolutionMessage(k0, resolved.key));
        }

        public void configure(KeyE key, ConfMap conf) {
            if (!conf.isEmpty()) {
                this.log("configure: " + key + " <--- " + conf);
            }
        }

        public void startResolve(EBuildContext context, String dependencyType) {
        }

        public void endResolve() {
        }
    }

    public static class Verbose
    implements BuildResolutionReport {
        final ILogger logger;
        final Stack<EBuildContext> stack = new Stack();
        private String __ = "  ";

        static String resolutionMessage(KeyE k1, KeyE k2) {
            if (k1.version.equals(k2.version)) {
                return "" + k1;
            }
            return k1 + " -> " + k2.version;
        }

        public Verbose(ILogger logger) {
            this.logger = logger;
        }

        public void startResolve(EBuildContext context, String dependencyType) {
            this.logger.log(String.valueOf(this.__) + dependencyType + " of " + context);
            this.__ = String.valueOf(this.__) + "    ";
            this.stack.push(context);
        }

        public void endResolve() {
            this.stack.pop();
            this.__ = this.__.substring(0, this.__.length() - 4);
        }

        public void resolve(DependencyType depType, KeyE k0, Element resolved) {
            this.logger.log(String.valueOf(this.__) + "resolve: " + Verbose.resolutionMessage(k0, resolved.key));
            if (resolved.key.version.isWorking()) {
                EBuild ebuild = resolved.ebuild;
                if (ebuild.WORKSPACES.getWorkspaceCount() > 1) {
                    this.logger.log(String.valueOf(this.__) + resolved.ebuild.formatAsDisplayPath(resolved.getProjectDirectory()));
                }
            }
        }

        public void configure(KeyE key, ConfMap conf) {
            this.logger.log(String.valueOf(this.__) + "configure: " + key + " <--- " + conf);
        }
    }
}

