/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IBuilderArgument;
import ebuild.api.IGenConfArgument;
import ebuild.api.plugin.AbstractBuilder;
import ebuild.api.plugin.BuildPluginException;
import ebuild.api.plugin.IEclipseNature;
import ebuild.api.plugin.IPropertyMap;
import ebuild.compat.BuilderSignature;
import ebuild.core.ModuleC;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderInstance {
    final ModuleC moduleC;
    final AbstractBuilder builder;
    final BuilderSignature signature;
    final IPropertyMap props;

    public BuilderInstance(ModuleC moduleC, AbstractBuilder builder, BuilderSignature signature, IPropertyMap props) {
        this.moduleC = moduleC;
        this.builder = builder;
        this.signature = signature;
        this.props = props;
    }

    public String name() {
        return String.valueOf(this.moduleC.key.ekey.fullnameAndVersion()) + " " + this.moduleC.getConfiguration();
    }

    public AbstractBuilder getBuilder() {
        return this.builder;
    }

    public void build(IBuilderArgument argument) throws BuildPluginException {
        Thread t = Thread.currentThread();
        ClassLoader old = t.getContextClassLoader();
        t.setContextClassLoader(this.getBuilder().getClass().getClassLoader());
        try {
            AbstractBuilder b = this.getBuilder();
            argument.getLogger().prime();
            b.build(argument);
        }
        finally {
            t.setContextClassLoader(old);
        }
    }

    public void generateEclipseProjectSettings(IGenConfArgument argument) throws BuildPluginException {
        Thread t = Thread.currentThread();
        ClassLoader old = t.getContextClassLoader();
        t.setContextClassLoader(this.getBuilder().getClass().getClassLoader());
        try {
            this.getEclipseNature().generateEclipseProjectSettings(argument);
        }
        finally {
            t.setContextClassLoader(old);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(this.name()) + " ");
        for (String k : this.props.listKeys()) {
            String v = "" + this.props.get(k);
            if (v.length() > 30) {
                v = String.valueOf(v.substring(0, 30)) + "... ";
            }
            sb.append(String.valueOf(k) + "=" + v);
        }
        return sb.toString();
    }

    public Set<String> getInputs() {
        return this.signature.inputs;
    }

    public Set<String> getOutputs() {
        return this.signature.outputs;
    }

    public boolean hasEclipseNature() {
        return this.getEclipseNature() != null;
    }

    public IEclipseNature getEclipseNature() {
        return this.builder.getEclipseNature();
    }
}

