/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.Scope;
import ebuild.base.EBuildException;
import ebuild.core.Artifact;
import ebuild.core.BuildProject;
import ebuild.core.Element;
import ebuild.core.ElementDeps;
import ebuild.core.ElementReleaseArtifact;
import ebuild.core.WorkspaceElementProject;
import ebuild.core.conf.ConfMap;
import ebuild.core.impl.ConfKey;
import ebuild.core.impl.KeyC;
import ebuild.util.FileUtil;
import ebuild.version.EBuildVersion;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementC<P extends Element, A extends Artifact> {
    public final KeyC key;
    public final P element;
    public final ConfMap configurationSelected;
    private Map<String, A> releases;
    public BuildProject build;
    public WorkspaceElementProject eclipse;
    private Long lastModificationOfInput = null;

    public BuildProject createBuildProject() {
        this.build = this.newBuildProject();
        return this.build;
    }

    public WorkspaceElementProject createEclipseProject() {
        this.eclipse = this.newEclipseProject();
        return this.eclipse;
    }

    public WorkspaceElementProject getWorkspaceProject() {
        return this.eclipse;
    }

    public BuildProject getOrCreateBuildProject() {
        if (this.build == null) {
            return this.newBuildProject();
        }
        return this.build;
    }

    public ElementC(P element, ConfKey subKey, ConfMap configurationSelected) {
        this.key = new KeyC(((Element)element).key, subKey);
        this.element = element;
        this.configurationSelected = configurationSelected;
    }

    protected boolean is0_7() {
        return ((Element)this.element).META.expectMainXml().getEBuildVersion() == EBuildVersion._0_7;
    }

    public abstract WorkspaceElementProject newEclipseProject();

    public abstract BuildProject newBuildProject();

    public abstract File getReleaseFile();

    public abstract List listReleases();

    public abstract ElementDeps getDependencies(Scope var1);

    public ConfKey getSubKey() {
        return this.key.subkey;
    }

    public P getPart() {
        return this.element;
    }

    public ConfMap getConfiguration() {
        return this.key.subkey.conf;
    }

    public ConfMap getConfigurationSelected() {
        return this.configurationSelected;
    }

    public A expectRelease(String artifact) throws EBuildException {
        A r;
        if (artifact == null) {
            if (this.getReleases().size() == 0) {
                throw EBuildException.newConfProblem("No default artifact, because there are no released artifacts: " + this);
            }
            artifact = this.getReleases().keySet().iterator().next();
        }
        if ((r = this.getRelease(artifact)) == null) {
            throw EBuildException.newConfProblem("No such released artifact '" + artifact + "': " + this);
        }
        return r;
    }

    public A getRelease(String artifact) {
        return (A)((Artifact)this.getReleases().get(artifact));
    }

    public Map<String, A> getReleases(String ... artifactTypes) {
        if (artifactTypes == null) {
            return this.getReleases();
        }
        LinkedHashMap<String, A> r = new LinkedHashMap<String, A>(artifactTypes.length);
        String[] stringArray = artifactTypes;
        int n = artifactTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            A v = this.getRelease(a);
            if (v != null) {
                r.put(a, v);
            }
            ++n2;
        }
        return r;
    }

    public Map<String, A> getReleases() {
        if (this.releases == null) {
            List rs = this.listReleases();
            this.releases = new LinkedHashMap<String, A>(rs.size());
            for (Artifact r : rs) {
                this.releases.put(r.getName(), r);
            }
        }
        return this.releases;
    }

    public Collection<ElementReleaseArtifact> iterateReleases() {
        return this.getReleases().values();
    }

    public long lastModificationOfInput(Scope scope) throws EBuildException {
        if (this.lastModificationOfInput == null) {
            long r = this.getDependencies(scope).lastModified();
            if (((Element)this.element).isSource()) {
                r = Math.max(r, ((Element)this.element).META.getMetaDir().lastModification());
                r = Math.max(r, ((Element)this.element).PROJECT.lastModification());
            }
            this.lastModificationOfInput = r;
        }
        return this.lastModificationOfInput;
    }

    public long lastModification(Scope scope) throws EBuildException {
        long r = this.lastModificationOfInput(scope);
        r = Math.max(r, FileUtil.deepLastModified(this.getReleaseFile()));
        return r;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ElementC)) {
            return false;
        }
        ElementC b = (ElementC)obj;
        return this.key.equals(b.key);
    }

    public String toString() {
        return this.key.toString();
    }

    public ElementC getCompiled() throws EBuildException {
        return this;
    }
}

