/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.common.Scope;
import ebuild.base.Backtrace;
import ebuild.base.EBuildException;
import ebuild.base.MetaType;
import ebuild.compat.AbstractCompatability;
import ebuild.core.Artifact;
import ebuild.core.EBuild;
import ebuild.core.ElementBuildMeta;
import ebuild.core.ElementMeta;
import ebuild.core.ElementNature;
import ebuild.core.ModuleBuildMeta;
import ebuild.core.ModuleC;
import ebuild.core.ModuleMeta;
import ebuild.core.ModuleReleaseArtifact;
import ebuild.core.ProductBuildMeta;
import ebuild.core.ProductMeta;
import ebuild.core.RepositoryInstance;
import ebuild.core.conf.ConfMap;
import ebuild.core.impl.EBuildMode;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.KeyE;
import ebuild.core.impl.Version;
import ebuild.core.util.NameTemplate;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.version.EBuildVersion;
import ebuild.xml.CmnXml;
import ebuild.xml.ModXml;
import ebuild.xml.PrdXml;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDir {
    public final EBuild ebuild;
    public final File dir;
    public final KeyE key;
    public final String projectRevision;
    public final ElementNature nature;
    public final EBuildMode mode;
    private final Map<MetaType, CmnXml.EBuildRoot> metas = new HashMap<MetaType, CmnXml.EBuildRoot>(3);
    public final Module MODULE;
    public final ModuleBuildMeta MODULE_BUILD;
    public final Product PRODUCT;
    public final ProductBuildMeta PRODUCT_BUILD;
    final Map<String, String> releaseRevisions = new HashMap<String, String>();
    private Long lastModified = null;

    public MetaDir(EBuild ebuild, File dir, KeyE key, ElementNature nature, EBuildMode mode) throws EBuildException {
        this.ebuild = ebuild;
        this.dir = dir;
        assert (key.type == null);
        this.key = key;
        this.projectRevision = key.version.getRevision();
        this.nature = nature;
        this.mode = mode;
        File moduleMeta = this.getFile(MetaType.MODULE);
        File moduleBuildMeta = this.getFile(MetaType.MODULE_BUILD);
        File productMeta = this.getFile(MetaType.PRODUCT);
        File productBuildMeta = this.getFile(MetaType.PRODUCT_ASSEMBLY);
        this.MODULE = moduleMeta == null ? null : new Module();
        this.PRODUCT = productMeta == null ? null : new Product();
        this.MODULE_BUILD = moduleBuildMeta == null ? null : new ModuleBuildMeta(this);
        ProductBuildMeta productBuildMeta2 = this.PRODUCT_BUILD = productBuildMeta == null ? null : new ProductBuildMeta(this);
        if (this.MODULE == null && this.PRODUCT == null) {
            throw EBuildException.newConfProblem("Neither module, nor product: " + FileUtil.canonicalFile(dir).getPath());
        }
    }

    public ElementType getPrimaryType() {
        if (this.PRODUCT != null) {
            return ElementType.product;
        }
        if (this.MODULE != null) {
            return ElementType.module;
        }
        return null;
    }

    private ElementType other(ElementType type) {
        switch (type) {
            case module: {
                return ElementType.product;
            }
            case product: {
                return ElementType.module;
            }
        }
        throw new Error("!");
    }

    public Element getElementMeta(ElementType type) {
        switch (type) {
            case module: {
                return this.MODULE;
            }
            case product: {
                return this.PRODUCT;
            }
        }
        throw new Error("!");
    }

    public ElementBuildMeta getElementBuildMeta(ElementType type) {
        switch (type) {
            case module: {
                return this.MODULE_BUILD;
            }
            case product: {
                return this.PRODUCT_BUILD;
            }
        }
        throw new Error("!");
    }

    public void init(ElementType type) throws EBuildException {
        if (type == null) {
            type = this.getPrimaryType();
        }
        this.getElementMeta(type).init();
        ElementBuildMeta buildMeta = this.getElementBuildMeta(type);
        if (buildMeta != null) {
            buildMeta.init();
        }
        try {
            ElementBuildMeta otherBuildMeta;
            Element other = this.getElementMeta(this.other(type));
            if (other != null) {
                other.init();
            }
            if ((otherBuildMeta = this.getElementBuildMeta(type)) != null) {
                otherBuildMeta.init();
            }
        }
        catch (EBuildException e) {
            this.ebuild.logger.warn("Unable to parse meta of " + type, e);
        }
    }

    public boolean hasFile(MetaType type) throws EBuildException {
        return this.getFile(type) != null;
    }

    public File getFile(MetaType type) throws EBuildException {
        File r = new File(this.dir, String.valueOf(EBuildVersion.getLatest().string) + "/" + type.name);
        if (r.isFile()) {
            return r;
        }
        r = new File(this.dir, type.name);
        if (r.isFile()) {
            return r;
        }
        String name = type.getAlternativeName();
        if (name != null && (r = new File(this.dir, name)).isFile()) {
            return r;
        }
        return null;
    }

    public File expectFile(MetaType metaType) throws EBuildException {
        File r = this.getFile(metaType);
        if (r == null) {
            throw EBuildException.newInternalError("Expected file: " + r);
        }
        return r;
    }

    public File getUpstreamRevisions(MetaType type) {
        String filename = "?";
        if (type != null) {
            filename = type.name;
        }
        filename = String.valueOf(FileUtil.removeSuffix(filename)) + ".revisions";
        return new File(this.dir, filename);
    }

    protected EBuildVersion readXmlVersion(File f) throws EBuildException {
        block4: {
            if (f != null) break block4;
            return null;
        }
        try {
            return MetaDir.readVersion(f);
        }
        catch (EBuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw EBuildException.newConfProblem(String.valueOf(this.ebuild.formatAsDisplayPath(this.dir)) + "\n" + e.getMessage());
        }
    }

    private CmnXml.EBuildRoot readXml(MetaType type) throws EBuildException {
        FileInputStream fi;
        File f = this.getFile(type);
        if (f == null) {
            return null;
        }
        try {
            fi = new FileInputStream(f);
        }
        catch (IOException e) {
            throw EBuildException.newInternalError("Could not read file: " + f, e);
        }
        EBuildVersion v = this.readXmlVersion(f);
        if (v == null) {
            return null;
        }
        AbstractCompatability compat = this.ebuild.getCompatability(v);
        boolean verbose = false;
        CmnXml.EBuildRoot r = compat.parseXml(type, fi, verbose);
        r.setEBuildVersion(v);
        return r;
    }

    public CmnXml.EBuildRoot getXml(MetaType type) throws EBuildException {
        if (!this.metas.containsKey((Object)type)) {
            CmnXml.EBuildRoot r = this.readXml(type);
            this.metas.put(type, r);
        }
        return this.metas.get((Object)type);
    }

    public CmnXml.EBuildRoot expectXml(MetaType type) throws EBuildException {
        CmnXml.EBuildRoot r = this.getXml(type);
        if (r == null) {
            throw EBuildException.newConfProblem("Expected meta file: " + type.name);
        }
        return r;
    }

    public CmnXml.EBuildRoot getXmlAlreadyParsed(MetaType type) {
        CmnXml.EBuildRoot r = this.metas.get((Object)type);
        if (r instanceof Exception) {
            throw new RuntimeException("Invalid conf " + (Object)((Object)type), (Exception)((Object)r));
        }
        return r;
    }

    public CmnXml.EBuildRoot expectXmlAlreadyParsed(MetaType type) {
        CmnXml.EBuildRoot r = this.getXmlAlreadyParsed(type);
        if (r == null) {
            throw new Error("Expected " + (Object)((Object)type) + " " + this);
        }
        return r;
    }

    public static EBuildVersion readVersion(Reader reader) throws Exception {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader xreader = factory.createXMLStreamReader(reader);
        xreader.nextTag();
        String versionAttr = xreader.getAttributeValue(null, "ebuild-version");
        if (versionAttr == null) {
            throw EBuildException.newConfProblem("No 'ebuild-version' attribute defined in root element");
        }
        Object[] versions = versionAttr.split(",");
        Arrays.sort(versions);
        EBuildVersion r = null;
        Object[] objectArray = versions;
        int n = versions.length;
        int n2 = 0;
        while (n2 < n) {
            Object v = objectArray[n2];
            EBuildVersion ebv = EBuildVersion.map.get(v);
            if (ebv != null) {
                r = ebv;
            }
            ++n2;
        }
        if (r == null) {
            throw new Exception("Unsupported format-version attribute defined in root element: " + versionAttr);
        }
        return r;
    }

    public static EBuildVersion readVersion(File f) throws Exception {
        FileReader r = new FileReader(f);
        try {
            EBuildVersion eBuildVersion = MetaDir.readVersion(r);
            return eBuildVersion;
        }
        finally {
            r.close();
        }
    }

    public Date getTimestamp() {
        return FileUtil.readTimestampFile(this.dir);
    }

    public String getReleaseRevision(KeyE selected, RepositoryInstance repoContext) throws EBuildException {
        return this.getReleaseRevision(selected.type, selected.version.getRevision(), repoContext);
    }

    private String getReleaseRevision(String selectedRevision, RepositoryInstance repoContext, CmnXml.SelectWithSource dep) throws EBuildException {
        if (!"local".equals(dep.source)) {
            return null;
        }
        if (dep.hasTag()) {
            return null;
        }
        if (dep.hasRevision()) {
            return null;
        }
        KeyE dkey = this.key.withName(dep.name);
        if (dep.org != null) {
            dkey = dkey.withOrg(dep.org);
        }
        ElementType depType = dep.isModule() ? ElementType.module : ElementType.product;
        dkey = dkey.withType(depType);
        ElementMeta dmeta = this.ebuild.LIBRARY.resolveMeta(repoContext, dkey = dkey.withRevision(selectedRevision));
        if (this == dmeta.getMetaDir()) {
            return null;
        }
        return dmeta.getMetaDir().getReleaseRevision(depType, selectedRevision, repoContext);
    }

    private String getReleaseRevision(ElementMeta MAIN, ElementBuildMeta BUILD, String selectedRevision, RepositoryInstance repoContext) throws EBuildException {
        Iterable<Object> deps = MAIN.expectMainXml().usings;
        if (MAIN instanceof ModuleMeta) {
            deps = CollectionUtil.concat(deps, ((ModuleMeta)MAIN).getMainDependencies());
        }
        if (BUILD != null) {
            if (BUILD instanceof ProductBuildMeta) {
                deps = CollectionUtil.concat(deps, ((ProductBuildMeta)BUILD).getMainDependencies());
            }
            deps = CollectionUtil.concat(deps, BUILD.getBuildXml().usings, BUILD.getBuildDependencies().values());
        }
        RepositoryInstance.Source srepo = repoContext.asSource();
        Backtrace.start("check dependency revisions", this.key);
        try {
            String r = null;
            for (Object o : deps) {
                CmnXml.SelectWithSource d = (CmnXml.SelectWithSource)o;
                r = srepo.maxRevision(r, this.getReleaseRevision(selectedRevision, repoContext, d));
            }
            String string = r;
            return string;
        }
        finally {
            Backtrace.end(this.key);
        }
    }

    private String getReleaseRevision(ElementType selectedType, String selectedRevision, RepositoryInstance repoContext) throws EBuildException {
        String selectedKey = selectedType + " " + selectedRevision;
        String r = this.releaseRevisions.get(selectedKey);
        if (r == null) {
            r = this.getReleaseRevision(this.getElementMeta(selectedType), this.getElementBuildMeta(selectedType), selectedRevision, repoContext);
            RepositoryInstance.Source srepo = repoContext.asSource();
            Element other = this.getElementMeta(this.other(selectedType));
            if (other != null) {
                String revisionOfOther = this.getReleaseRevision(other, this.getElementBuildMeta(this.other(selectedType)), selectedRevision, repoContext);
                r = srepo.maxRevision(r, revisionOfOther);
            }
            r = srepo.maxRevision(r, this.projectRevision);
            this.releaseRevisions.put(selectedKey, r);
        }
        return r;
    }

    public boolean hasPrimaryFile(ElementType type) throws EBuildException {
        if (type == ElementType.module) {
            return this.hasFile(MetaType.MODULE);
        }
        return this.hasFile(MetaType.PRODUCT);
    }

    public List<File> getMetaFiles(MetaType ... types) throws EBuildException {
        ArrayList<File> r = new ArrayList<File>(types.length);
        MetaType[] metaTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            MetaType mt = metaTypeArray[n2];
            File f = this.getFile(mt);
            if (f != null) {
                r.add(f);
            }
            ++n2;
        }
        return r;
    }

    public List<File> getMetaFiles(ElementType type) throws EBuildException {
        if (type == ElementType.module) {
            return this.getMetaFiles(MetaType.MODULE, MetaType.MODULE_BUILD, MetaType.BUILD_PLUGIN);
        }
        return this.getMetaFiles(MetaType.PRODUCT, MetaType.PRODUCT_ASSEMBLY);
    }

    public List<File> getMetaFiles() throws EBuildException {
        return this.getMetaFiles(MetaType.values());
    }

    public File getMetaFile(ElementType type) throws EBuildException {
        if (type == ElementType.module) {
            return this.getFile(MetaType.MODULE);
        }
        return this.getFile(MetaType.PRODUCT);
    }

    public long lastModification() throws EBuildException {
        if (this.lastModified == null) {
            long r = Long.MIN_VALUE;
            for (File f : this.getMetaFiles()) {
                r = Math.max(r, FileUtil.deepLastModified(f));
            }
            this.lastModified = r;
        }
        return this.lastModified;
    }

    public String toString() {
        return "META " + this.key.toString();
    }

    public abstract class Element
    implements ElementMeta {
        public MetaDir getMetaDir() {
            return MetaDir.this;
        }

        public CmnXml.EBuildElement getMainXml() throws EBuildException {
            return (CmnXml.EBuildElement)MetaDir.this.getXml(this.getMetaType());
        }

        public CmnXml.EBuildElement expectMainXml() {
            return (CmnXml.EBuildElement)MetaDir.this.expectXmlAlreadyParsed(this.getMetaType());
        }

        public EBuildMode getMode() {
            return MetaDir.this.mode;
        }

        public boolean isSource() {
            return MetaDir.this.nature.isSource();
        }

        public boolean isExternal() {
            return false;
        }

        public void init() throws EBuildException {
            MetaDir.this.expectXml(this.getMetaType());
            this.check();
        }

        public CmnXml.Configuration getConfXml(String name) throws EBuildException {
            for (CmnXml.Configuration c : this.expectMainXml().configurations) {
                if (!name.equals(c.name)) continue;
                return c;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Module
    extends Element
    implements ModuleMeta {
        @Override
        public void check() throws EBuildException {
        }

        @Override
        public ElementType getElementType() {
            return ElementType.module;
        }

        @Override
        public MetaType getMetaType() {
            return MetaType.MODULE;
        }

        public MetaType getMetaTypeOfBuild() {
            return MetaType.MODULE_BUILD;
        }

        @Override
        public ModXml.EbuildModule expectMainXml() {
            return (ModXml.EbuildModule)super.expectMainXml();
        }

        @Override
        public Iterable<? extends CmnXml.SelectWithSource> getMainDependencies() throws EBuildException {
            ModXml.Dependencies deps = this.expectMainXml().dependencies;
            return CollectionUtil.concat(deps.list, deps.products);
        }

        @Override
        public Artifact.Module newModuleRelease(ModuleC moduleC, String artifact, String filepart, Scope scope, File releaseDirectory) {
            return ModuleReleaseArtifact.newModuleRelease(moduleC, artifact, filepart, scope, releaseDirectory);
        }
    }

    public class Product
    extends Element
    implements ProductMeta {
        private Map<String, NameTemplate> artifacts;
        private String defaultArtifact;

        public void check() throws EBuildException {
            PrdXml.EbuildProduct declaration = (PrdXml.EbuildProduct)this.expectMainXml();
            LinkedHashMap<String, NameTemplate> artifacts = new LinkedHashMap<String, NameTemplate>();
            for (PrdXml.Artifact a : declaration.artifacts) {
                artifacts.put(a.name, this.getNameTemplate(a));
            }
            if (artifacts.size() == 0) {
                throw EBuildException.newConfProblem("Expected at least one <artifact/> in product declaration.");
            }
            this.defaultArtifact = (String)artifacts.keySet().iterator().next();
            this.artifacts = artifacts;
        }

        public ElementType getElementType() {
            return ElementType.product;
        }

        public MetaType getMetaType() {
            return MetaType.PRODUCT;
        }

        public String getDefaultArtifact() {
            return this.defaultArtifact;
        }

        public String expectArtifactName(Version version, String artifact, ConfMap confs) {
            String r = this.getArtifactName(version, artifact, confs);
            if (r == null) {
                throw new Error("No such artifact: " + artifact);
            }
            return r;
        }

        public String getArtifactName(Version version, String artifact, ConfMap confs) {
            NameTemplate nt;
            if (artifact == null) {
                artifact = this.defaultArtifact;
            }
            if ((nt = this.artifacts.get(artifact)) == null) {
                return null;
            }
            return nt.apply(EBuildUtil.newNameTemplateModel(version, confs));
        }

        private NameTemplate getNameTemplate(PrdXml.Artifact a) throws EBuildException {
            String pattern = a.pattern;
            if (pattern == null) {
                String prefix = a.prefix;
                if (prefix == null) {
                    prefix = a.name;
                }
                pattern = String.valueOf(prefix) + "{confs}{-|version}";
                String suffix = a.suffix;
                if (suffix != null) {
                    pattern = String.valueOf(pattern) + suffix;
                }
            }
            return NameTemplate.parse(pattern);
        }
    }
}

