/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.base.EBuildException;
import ebuild.base.MetaType;
import ebuild.compat.IBuildPlugin;
import ebuild.core.EBuild;
import ebuild.core.EBuildContextOfXml;
import ebuild.core.Element;
import ebuild.core.ModuleC;
import ebuild.core.ModuleMeta;
import ebuild.core.ModuleProject;
import ebuild.core.ModuleProjectHelper;
import ebuild.core.ModuleRelease;
import ebuild.core.conf.ConfMap;
import ebuild.core.impl.ConfKey;
import ebuild.core.impl.KeyE;
import ebuild.version.EBuildVersion;
import ebuild.xml.ModXml;
import java.io.File;
import org.simpleframework.xml.core.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Module
extends Element {
    final IBuildPlugin buildPlugin = this.getBuildPlugin();

    public Module(EBuild ebuild, KeyE key, ModuleMeta meta, ModuleProject project, ModuleRelease release) throws EBuildException {
        super(ebuild, key, meta, project, release, EBuildContextOfXml.Type.module);
    }

    private IBuildPlugin getBuildPlugin() throws EBuildException {
        if (this.META.isExternal()) {
            return null;
        }
        File pluginFile = this.META.getMetaDir().getFile(MetaType.BUILD_PLUGIN);
        EBuildVersion v = this.META.getMetaDir().readXmlVersion(pluginFile);
        if (v == null) {
            return null;
        }
        try {
            return this.ebuild.getCompatability(v).getPlugin(pluginFile);
        }
        catch (PersistenceException e) {
            throw EBuildException.newConfProblem("Could not parse build plugin.\n[Simple Xml Exception Message] " + e.getMessage());
        }
        catch (Exception e) {
            throw EBuildException.wrapException("Could not load build plugin: " + this.key, e);
        }
    }

    @Override
    public ModuleMeta getMETA() {
        return (ModuleMeta)super.getMETA();
    }

    public ModuleProject getProject() {
        return (ModuleProject)this.PROJECT;
    }

    @Override
    public ModuleC newCElement(ConfKey subKey, ConfMap confSelected) {
        return new ModuleC(this, subKey, confSelected);
    }

    @Override
    public ModuleC getCPart(ConfKey subKey) throws EBuildException {
        return (ModuleC)super.getCPart(subKey);
    }

    @Override
    public ModuleProjectHelper newProjectHelper() throws EBuildException {
        return new ModuleProjectHelper(this);
    }

    @Override
    public ModuleProjectHelper getProjectHelper() {
        return (ModuleProjectHelper)super.getProjectHelper();
    }

    @Override
    public ElementType getType() {
        return ElementType.module;
    }

    public boolean isPlugin() {
        return this.buildPlugin != null;
    }

    public Iterable<ModXml.Dependency> getDependenciesXml() {
        return this.getMETA().expectMainXml().dependencies.list;
    }

    public Iterable<ModXml.Dependency> xmlOfModuleDependencies() {
        return this.getMETA().expectMainXml().dependencies.list;
    }

    public Iterable<ModXml.Product> xmlOfProductDependencies() {
        return this.getMETA().expectMainXml().dependencies.products;
    }

    public String getJavaVersion() {
        for (ModXml.System d : this.getMETA().expectMainXml().dependencies.systems) {
            if (!"java.jre".equals(d.name) || d.tag == null) continue;
            return d.tag;
        }
        return "1.6";
    }
}

