/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IArtifact;
import ebuild.api.IEBuild;
import ebuild.api.IGenConfArgument;
import ebuild.api.IModuleBuildProject;
import ebuild.api.IModuleProject;
import ebuild.api.IModuleWorkspaceProject;
import ebuild.api.common.IElementKey;
import ebuild.api.common.Scope;
import ebuild.api.eclipse.IEclipseProject;
import ebuild.api.log.ILogger;
import ebuild.api.plugin.BuildPluginException;
import ebuild.api.plugin.IPropertyMap;
import ebuild.base.EBuildException;
import ebuild.base.Task;
import ebuild.compat.IModuleProjectInCompat;
import ebuild.core.Artifact;
import ebuild.core.BuildProject;
import ebuild.core.BuilderChain;
import ebuild.core.BuilderInstance;
import ebuild.core.EBuild;
import ebuild.core.Module;
import ebuild.core.ModuleC;
import ebuild.core.ModuleDeps;
import ebuild.core.ModuleProjectHelper;
import ebuild.core.ModuleReleaseArtifact;
import ebuild.core.WorkspaceElementProject;
import ebuild.core.impl.Exclude;
import ebuild.eclipse.EclipseProject;
import ebuild.util.FileUtil;
import ebuild.util.IOUtil;
import ebuild.util.Logger;
import ebuild.util.ObjectUtil;
import ebuild.util.tuple.Pair;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleWorkspaceProject
extends WorkspaceElementProject
implements IModuleWorkspaceProject,
IModuleBuildProject,
IModuleProjectInCompat {
    public final Module module;
    public final ModuleC moduleC;
    private final ModuleProjectHelper helper;
    private final EclipseProject eclipseProject;
    private static final Scope[] CALL_ORDER = new Scope[]{Scope.MAIN, Scope.TEST, Scope.POKE};

    public ModuleWorkspaceProject(ModuleC moduleC) {
        super(moduleC);
        this.moduleC = moduleC;
        this.module = (Module)moduleC.element;
        this.helper = this.module.getProjectHelper();
        this.eclipseProject = new EclipseProject(this);
    }

    public boolean hasOutput(String artifactType) {
        return this.helper.hasOutput(artifactType);
    }

    @Override
    public ModuleC getCPart() {
        return (ModuleC)super.getCPart();
    }

    @Override
    public File getSrcDirectory(Scope scope, String type) {
        return this.helper.getSrcDirectory(scope, type);
    }

    public String getArtifactPath(String kind, Scope scope, String type) {
        return this.helper.getSrcFolder(kind, scope, type);
    }

    @Override
    public Collection<File> getCheckedInArtifacts(Scope s, String type) {
        return ModuleProjectHelper.getCheckedInArtifacts(this.elementC, s, type);
    }

    public String getJavaVersion() {
        return this.helper.getJavaVersion();
    }

    public IElementKey getKey() {
        return this.module.key;
    }

    public Collection<String> getLoadGroups(Scope scope) {
        return this.moduleC.getDependencies(scope).getLoadGroups();
    }

    public Collection<File> getBuildDependencies(Scope scope, String artifactType) {
        ModuleDeps.GathererOfFiles gatherer = new ModuleDeps.GathererOfFiles(true, artifactType);
        ModuleDeps deps = this.moduleC.getDependencies(scope);
        deps.doDeepGather(gatherer, new ModuleDeps.RecurseRule(){

            public boolean ignore(ModuleDeps.ModuleDep md) {
                if (md.isWorkspace()) {
                    return true;
                }
                return md.loadgroup != null;
            }
        }, Exclude.NONE);
        Set<File> r = gatherer.files;
        this.addWorkspaceArtifacts(r, scope, artifactType);
        return r;
    }

    private void addWorkspaceArtifacts(Collection<File> r, String kind, String artifact, ModuleWorkspaceProject p) {
        String path = p.getArtifactPath(kind, Scope.MAIN, artifact);
        File f = p.getProjectFile(path);
        if (f.exists()) {
            r.add(f);
        }
    }

    private void addWorkspaceArtifacts(Collection<File> r, Scope scope, String artifact) {
        Collection<IModuleWorkspaceProject> projects = this.getWorkspaceDependencies(scope);
        for (IModuleWorkspaceProject ip : projects) {
            ModuleWorkspaceProject p = (ModuleWorkspaceProject)ip;
            this.addWorkspaceArtifacts(r, "gen", artifact, p);
            this.addWorkspaceArtifacts(r, "src", artifact, p);
            p.addWorkspaceArtifacts(r, Scope.MAIN, artifact);
        }
    }

    public File getCorespondingArtifactDependency(Scope scope, String artifactType, File artifact) {
        return ModuleProjectHelper.getCorespondingBuildDependency(this, scope, artifactType, artifact);
    }

    private String getSrcPath(boolean gen, Scope scope, String type) {
        return this.helper.getSrcFolder(gen, scope, type);
    }

    public ModuleReleaseArtifact getModuleRelease() {
        throw new UnsupportedOperationException();
    }

    public void addIgnores(String ... patterns) {
        this.module.addIgnores(patterns);
    }

    public IEclipseProject asEclipseProject() {
        return this.eclipseProject;
    }

    public String filePrefix() {
        return null;
    }

    private void setupBuilders() throws EBuildException, BuildPluginException {
        final EBuild ebuild = this.module.ebuild;
        BuilderChain chain = this.getCPart().configureAndParameterizeBuilderChain();
        Pair<Collection<BuilderInstance>, Collection<BuilderInstance>> builders = chain.getBuildersForEclipse();
        for (final BuilderInstance b : (Collection)builders.a) {
            Scope[] scopeArray = CALL_ORDER;
            int n = CALL_ORDER.length;
            int n2 = 0;
            while (n2 < n) {
                Scope s = scopeArray[n2];
                ModuleProjectHelper.AbstractBuilderArgument arg = new ModuleProjectHelper.AbstractBuilderArgument(this, s, b){

                    public boolean isBuild() {
                        return false;
                    }

                    public boolean isFirstCall() {
                        return this.scope == CALL_ORDER[0];
                    }

                    public File getExportDirectory(String artifactType) {
                        return this.getGenDirectory(artifactType);
                    }

                    public File getGenDirectory(String artifactType) {
                        return new File(this.module.getProjectDirectory(), ModuleWorkspaceProject.this.getSrcPath(true, this.getScope(), artifactType));
                    }

                    public File getIntermediateDir(String uniquePath) {
                        throw new UnsupportedOperationException();
                    }

                    public IModuleBuildProject getModuleBuildProject() {
                        return ModuleWorkspaceProject.this;
                    }

                    public File getOutputArtifact(String artifactType, boolean alwaysNamed) {
                        File export = this.getExportDirectory(artifactType);
                        if (alwaysNamed) {
                            String suffix = FileUtil.fileSuffix(artifactType);
                            String fileName = this.filePrefix;
                            if (suffix != null) {
                                fileName = String.valueOf(fileName) + "." + suffix;
                            }
                            return new File(export, fileName);
                        }
                        return export;
                    }
                };
                b.build(arg);
                ++n2;
            }
        }
        for (final BuilderInstance b : (Collection)builders.b) {
            if (!b.hasEclipseNature()) continue;
            final Logger logger = ebuild.logger.newSubLogger("Eclipse/" + b.name());
            Task.start("Gen eclipse settings", b, logger);
            try {
                b.generateEclipseProjectSettings(new IGenConfArgument(){

                    public IModuleWorkspaceProject getModuleWorkspaceProject() {
                        return ModuleWorkspaceProject.this;
                    }

                    public ILogger getLogger() {
                        return logger;
                    }

                    public IEBuild getEBuild() {
                        return ebuild;
                    }

                    public IPropertyMap getPropertyMap() {
                        return b.props;
                    }
                });
            }
            finally {
                Task.end(b);
            }
        }
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        this.eclipseProject.init();
        if (this.module.isSourceWithBuild()) {
            this.setupBuilders();
        }
        this.eclipseProject.commit();
    }

    @Override
    public void unsetup() throws Exception {
        super.unsetup();
        FileUtil.deleteDir(this.module.PROJECT.getFile("gen"));
        this.module.PROJECT.getFile(".classpath").delete();
    }

    public String readProjectFile(String path) throws IOException {
        return IOUtil.fileToString(this.getProjectFile(path));
    }

    public void writeProjectFile(String path, String text) throws IOException {
        File f = this.getProjectFile(path);
        String path1 = this.module.ebuild.formatAsDisplayPath(f);
        ILogger logger = Task.expect().logger;
        logger.log(" gen -> " + path1);
        IOUtil.stringToFile(text, f);
    }

    @Override
    public File getReleaseSubDir() {
        return null;
    }

    @Override
    public Collection getReleasedDependencies(Scope scope) {
        LinkedHashSet<BuildProject> r = new LinkedHashSet<BuildProject>();
        for (ModuleDeps.ModuleDep pd : ((ModuleC)this.elementC).getDependencies(scope).getModuleDeps()) {
            if (pd.moduleC.eclipse != null || pd.subsumed) continue;
            r.add(pd.moduleC.getOrCreateBuildProject());
        }
        return r;
    }

    public Collection<IModuleProject> getProjectDependencies(Scope scope) {
        LinkedHashSet<IModuleProject> r = new LinkedHashSet<IModuleProject>();
        for (ModuleDeps.ModuleDep dep : ((ModuleC)this.elementC).getDependencies(scope).getModuleDeps()) {
            if (dep.moduleC.eclipse != null) {
                r.add((IModuleProject)dep.moduleC.eclipse);
                continue;
            }
            if (dep.subsumed) continue;
            r.add((IModuleProject)dep.moduleC.getOrCreateBuildProject());
        }
        return r;
    }

    public Collection<File> getBuildArtifactDependencies(String artifactType) {
        ModuleDeps deps = (ModuleDeps)this.elementC.getDependencies(Scope.MAIN);
        ModuleDeps.GathererOfFiles gatherer = new ModuleDeps.GathererOfFiles(true, artifactType);
        gatherer.setContinueRule(new ModuleDeps.RecurseRule(){

            public boolean ignore(ModuleDeps.ModuleDep md) {
                return DEFAULT_CONT.ignore(md);
            }
        });
        deps.doDeepGather(gatherer, new ModuleDeps.RecurseRule(){

            public boolean ignore(ModuleDeps.ModuleDep md) {
                return md.loadgroup != null;
            }
        }, Exclude.NONE);
        return gatherer.files;
    }

    public Collection<IModuleWorkspaceProject> getIDESetupProjectDependencies(Scope scope, String loadgroup) {
        LinkedHashSet<IModuleWorkspaceProject> r = new LinkedHashSet<IModuleWorkspaceProject>();
        for (ModuleDeps.ModuleDep pd : this.moduleC.getDependencies(scope).getModuleDeps()) {
            if (!pd.isWorkspace() || !ObjectUtil.areEqual(pd.loadgroup, loadgroup)) continue;
            r.add((IModuleWorkspaceProject)pd.moduleC.eclipse);
        }
        return r;
    }

    public void gatherDependencies(Scope scope, final String loadgroup, ModuleDeps.Gatherer gatherer) {
        ModuleDeps deps = (ModuleDeps)this.elementC.getDependencies(scope);
        gatherer.setContinueRule(new ModuleDeps.RecurseRule(){

            public boolean ignore(ModuleDeps.ModuleDep md) {
                return DEFAULT_CONT.ignore(md);
            }

            public boolean use(ModuleDeps.ModuleDep md) {
                return !md.isWorkspace();
            }
        });
        deps.doDeepGather(gatherer, new ModuleDeps.RecurseRule(){

            public boolean ignore(ModuleDeps.ModuleDep md) {
                if (!ObjectUtil.areEqual(loadgroup, md.loadgroup)) {
                    return true;
                }
                return md.isWorkspace();
            }

            public boolean use(ModuleDeps.ModuleDep md) {
                return !md.isWorkspace();
            }
        }, Exclude.NONE);
    }

    public Collection<Artifact.Module> getIDESetupArtifactDependencies(Scope scope, String loadgroup) {
        ModuleDeps.GathererOfReleases gatherer = new ModuleDeps.GathererOfReleases();
        this.gatherDependencies(scope, loadgroup, gatherer);
        return gatherer.getModules();
    }

    public Collection<File> getIDESetupArtifactDependencies(Scope scope, String loadgroup, String artifactType) {
        ModuleDeps.GathererOfFiles gatherer = new ModuleDeps.GathererOfFiles(true, artifactType);
        this.gatherDependencies(scope, loadgroup, gatherer);
        return gatherer.files;
    }

    public Collection<IModuleWorkspaceProject> getWorkspaceDependencies(Scope scope) {
        return this.getIDESetupProjectDependencies(scope, null);
    }

    public Collection<File> getDependencyArtifacts(String loadgroup, String artifactType) {
        return this.getBuildArtifactDependencies(artifactType);
    }

    public Collection<IModuleWorkspaceProject> getDependencyProjects(final String loadgroup, String artifact) {
        ModuleDeps deps = (ModuleDeps)this.elementC.getDependencies(Scope.MAIN);
        ModuleDeps.GathererOfWSProjects gatherer = new ModuleDeps.GathererOfWSProjects();
        deps.doDeepGather(gatherer, new ModuleDeps.RecurseRule(){

            public boolean ignore(ModuleDeps.ModuleDep md) {
                if (!ObjectUtil.areEqual(loadgroup, md.loadgroup)) {
                    return true;
                }
                if (md.subsumed) {
                    return true;
                }
                return !md.isWorkspace();
            }
        }, Exclude.NONE);
        return gatherer.projects;
    }

    public IArtifact getProductArtifactDependency(String role) {
        return this.moduleC.getDependencies(Scope.MAIN).getProduct(role);
    }
}

