/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IArtifact;
import ebuild.api.common.IElementKey;
import ebuild.api.common.Scope;
import ebuild.base.EBuildException;
import ebuild.core.ElementDeps;
import ebuild.core.ModuleC;
import ebuild.core.ModuleCDep;
import ebuild.core.ModuleDeps;
import ebuild.core.ProductC;
import ebuild.core.impl.Exclude;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ProductDeps
extends ElementDeps {
    public final Map<String, ProductDep> products = new HashMap<String, ProductDep>();
    public final Map<String, ModuleSelectionDep> moduleSelections = new HashMap<String, ModuleSelectionDep>();

    public void addProduct(ProductDep dep) {
        this.products.put(dep.key, dep);
    }

    public void addModuleSelection(ModuleSelectionDep dep) {
        this.moduleSelections.put(dep.key, dep);
    }

    public long lastModified() throws EBuildException {
        long r = Long.MIN_VALUE;
        for (ModuleC m : this.builders.values()) {
            r = Math.max(r, m.lastModification(Scope.MAIN));
        }
        for (ProductDep cd : this.products.values()) {
            r = Math.max(r, cd.productC.lastModification(Scope.MAIN));
        }
        for (ModuleSelectionDep msd : this.moduleSelections.values()) {
            for (ModuleCDep cp : msd.modules) {
                r = Math.max(r, cp.moduleC.lastModification(Scope.MAIN));
            }
        }
        return r;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ModuleSelectionDep {
        final String key;
        final Collection<ModuleCDep> modules;

        public ModuleSelectionDep(String key, Collection<ModuleCDep> modules) {
            this.key = key;
            this.modules = modules;
        }

        public Collection<File> getArtifacts(final Exclude deepExclude, String[] artifactTypes) {
            ModuleDeps.RecurseRule rule = new ModuleDeps.RecurseRule(){

                public boolean ignore(ModuleDeps.ModuleDep md) {
                    if (deepExclude.match(md.key)) {
                        return true;
                    }
                    return DEFAULT_CONT.ignore(md);
                }
            };
            ModuleDeps.GathererOfModuleSelection gatherer = new ModuleDeps.GathererOfModuleSelection(artifactTypes);
            gatherer.setContinueRule(rule);
            for (ModuleCDep dep : this.modules) {
                ModuleDeps mcdeps = dep.moduleC.getDependencies(Scope.MAIN);
                mcdeps.doDeepGather(gatherer, rule, dep.exclude);
                gatherer.add(dep.moduleC);
            }
            return gatherer.getFiles();
        }
    }

    public static class ProductDep
    implements IArtifact {
        final String key;
        final ProductC productC;
        final String artifact;

        public ProductDep(String key, ProductC productC, String artifact) {
            this.key = key;
            this.productC = productC;
            this.artifact = artifact;
        }

        public String getArtifactType() {
            return this.artifact;
        }

        public File getFile() {
            return this.productC.getRelease((String)this.artifact).artifactFile;
        }

        public IElementKey getKey() {
            return this.productC.key.ekey;
        }
    }
}

