/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.base.EBuildException;
import ebuild.core.EBuild;
import ebuild.core.EBuildContext;
import ebuild.core.EBuildContextOfXml;
import ebuild.core.RepositoryInstance;
import ebuild.core.impl.KeyE;
import ebuild.core.impl.Version;
import ebuild.util.Callable;

public abstract class RepositoryRef {
    private static final String WORKSPACE = "workspace";
    public final EBuildContext context;
    public final String name;
    public final XmlContextRefTrait xmlContextTrait;
    private String defaultOrg;
    private Version defaultVersion;
    private boolean defaultOrgIsMandatory = false;

    public RepositoryRef(EBuildContext context, String name) {
        this.context = context;
        this.name = name;
        this.xmlContextTrait = context instanceof EBuildContextOfXml ? new XmlContextRefTrait(this, (EBuildContextOfXml)context) : null;
    }

    public abstract RepositoryInstance getRepo() throws EBuildException;

    public abstract boolean isLocal();

    public boolean isSource() throws EBuildException {
        return this.getRepo().isSource();
    }

    public boolean hasRepo() throws EBuildException {
        return this.getRepo().hasRepo();
    }

    public String expectDefaultOrg() throws EBuildException {
        String r = this.getDefaultOrg();
        if (r == null) {
            throw EBuildException.newConfProblem("\"org\" must be specified for repository: " + this.name);
        }
        return r;
    }

    public void setMandatoryOrg(String mandatoryOrg) {
        this.defaultOrgIsMandatory = true;
        this.setDefaultOrg(mandatoryOrg);
    }

    public String getDefaultOrg() {
        return this.defaultOrg;
    }

    public void setDefaultOrg(String defaultOrg) {
        this.defaultOrg = defaultOrg;
    }

    public Version getDefaultVersion(String org, String name) {
        return this.defaultVersion;
    }

    public void setDefaultVersion(Version defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public String expectOrg(String org) throws EBuildException {
        if (org == null) {
            String r = this.getDefaultOrg();
            if (r == null) {
                throw EBuildException.newConfProblem("'org' must be specified for repository: " + this.name);
            }
            return r;
        }
        if (this.defaultOrgIsMandatory && !this.getDefaultOrg().equals(org)) {
            throw EBuildException.newConfProblem("'org' must be '" + org + "' for repository: " + this.name);
        }
        return org;
    }

    public String getUniverse() throws EBuildException {
        return this.getRepo().getUniverse();
    }

    public RepositoryInstance.Source expectSourceRepo() throws EBuildException {
        return this.getRepo().asSource();
    }

    public String toString() {
        return this.context + "--" + this.name;
    }

    public static class DerivedRef
    extends RepositoryRef {
        final RepositoryRef prototype;

        DerivedRef(RepositoryRef prototype, EBuildContext context, String name) {
            super(context, name);
            this.prototype = prototype;
        }

        public boolean isLocal() {
            return this.prototype.isLocal();
        }

        public RepositoryInstance getRepo() throws EBuildException {
            return this.prototype.getRepo();
        }

        public String getDefaultOrg() {
            String r = super.getDefaultOrg();
            if (r == null) {
                return this.prototype.getDefaultOrg();
            }
            return r;
        }

        public Version getDefaultVersion(String org, String name) {
            Version r = super.getDefaultVersion(org, name);
            if (r == null) {
                return this.prototype.getDefaultVersion(org, name);
            }
            return r;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LazyRef
    extends NamedRef {
        final Callable<RepositoryInstance, EBuildException> locator;
        final String universe;
        private RepositoryInstance repo;

        LazyRef(EBuildContext context, String name, String universe, Callable<RepositoryInstance, EBuildException> locator) {
            super(context, name, null);
            this.universe = universe;
            this.locator = locator;
        }

        @Override
        public RepositoryInstance getRepo() throws EBuildException {
            if (this.repo == null) {
                this.repo = this.locator.run();
            }
            return this.repo;
        }

        @Override
        public String getUniverse() throws EBuildException {
            if (this.universe != null) {
                return this.universe;
            }
            return this.getRepo().getUniverse();
        }
    }

    public static class LocalRef
    extends RepositoryRef {
        final RepositoryInstance repo;

        public LocalRef(EBuildContext context, RepositoryInstance repo) {
            super(context, "local");
            this.repo = repo;
        }

        public boolean isLocal() {
            return true;
        }

        public RepositoryInstance getRepo() throws EBuildException {
            return this.repo;
        }
    }

    public static class NamedRef
    extends RepositoryRef {
        final String name;
        final RepositoryInstance repo;

        NamedRef(EBuildContext context, String name, RepositoryInstance repo) {
            super(context, name);
            this.name = name;
            this.repo = repo;
        }

        public RepositoryInstance getRepo() throws EBuildException {
            return this.repo;
        }

        public boolean isLocal() {
            return false;
        }

        public String toString() {
            return this.context + "--" + this.name;
        }
    }

    public static class XmlContextRefTrait {
        final RepositoryRef ref;
        final EBuildContextOfXml context;
        private String fixedRevision;

        XmlContextRefTrait(RepositoryRef ref, EBuildContextOfXml context) {
            this.ref = ref;
            this.context = context;
        }

        public String expectFixedRevision(KeyE dkey) throws EBuildException {
            if (this.ref.isLocal()) {
                if (this.ref.hasRepo() && !this.ref.isSource()) {
                    String r = this.context.UPSTREAM_REVISIONS.get(dkey);
                    if (r == null) {
                        this.context.ebuild.logger.warn("Expected entry '" + this.context.UPSTREAM_REVISIONS.lookup(dkey) + "' in '" + this.context.element.key.fullnameAndVersionAndUniverse() + ":meta/" + this.context.UPSTREAM_REVISIONS.getFileName() + "'");
                        return this.context.element.key.version.getRevision();
                    }
                    return r;
                }
                return this.context.element.key.version.getRevision();
            }
            if (this.fixedRevision == null) {
                this.fixedRevision = this.readFixedRevision();
            }
            if (this.fixedRevision == null) {
                throw EBuildException.newConfProblem("Upstream dependency not fixed to a revision: " + this.context + "-" + this.ref.name);
            }
            if (this.fixedRevision.equals(RepositoryRef.WORKSPACE)) {
                throw EBuildException.newConfProblem("Upstream dependency fixed to workspace: " + this.context + "-" + this.ref.name);
            }
            return this.fixedRevision;
        }

        private String readFixedRevision() throws EBuildException {
            String repoUrl = this.ref.getRepo().getUri();
            return this.context.UPSTREAM_REVISIONS.get(repoUrl);
        }

        public String getUpdatedFixedRevision(EBuildContext from, KeyE dkey) throws EBuildException {
            if (this.ref.isLocal()) {
                return this.context.ebuild.getWorkspaceHeadRevision(this.ref.expectSourceRepo());
            }
            if (this.context.element.isWorkspace()) {
                if (!this.context.ebuild.updateUpstream) {
                    this.fixedRevision = this.readFixedRevision();
                }
                if (this.fixedRevision == null) {
                    EBuild ebuild = from.ebuild;
                    try {
                        String latest = ebuild.getWorkspaceHeadRevision(this.ref.getRepo().asSource());
                        this.fixedRevision = this.writeFixedRevision(from, dkey, latest);
                        ebuild.logger.log("  head revision of '" + this.ref.name + "' -> " + latest);
                    }
                    catch (EBuildException e) {
                        this.fixedRevision = this.readFixedRevision();
                        if (this.fixedRevision != null) {
                            ebuild.logger.warn(" problem updating revision, using stored revision '" + this.ref.name + "' -> " + this.fixedRevision, e);
                        }
                        throw EBuildException.newRepoIssue("Unable to get revision. No previous revision stored", e);
                    }
                } else if (this.fixedRevision.equals(RepositoryRef.WORKSPACE)) {
                    return this.context.ebuild.getWorkspaceHeadRevision(this.ref.expectSourceRepo());
                }
                return this.fixedRevision;
            }
            return this.expectFixedRevision(dkey);
        }

        public boolean fixRevisionToWorkspace(EBuildContext from, KeyE key) throws EBuildException {
            if (this.ref.isLocal()) {
                return true;
            }
            if (RepositoryRef.WORKSPACE.equals(this.fixedRevision)) {
                return true;
            }
            if (this.ref.isSource() && this.context.element.isWorkspace()) {
                this.fixedRevision = this.writeFixedRevision(from, key, RepositoryRef.WORKSPACE);
                return true;
            }
            return false;
        }

        private String writeFixedRevision(EBuildContext from, KeyE dkey, String latest) throws EBuildException {
            String repoUrl = this.ref.getRepo().getUri();
            String latestPreviously = this.context.UPSTREAM_REVISIONS.get(repoUrl);
            if (!latest.equals(latestPreviously)) {
                if (!this.context.element.isWorkspace()) {
                    throw EBuildException.newInternalError("Cannot update revision for '" + dkey + "' " + latestPreviously + "->" + latest);
                }
                this.context.UPSTREAM_REVISIONS.putAndUpdate(repoUrl, latest);
            }
            return latest;
        }
    }
}

