/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.base.EBuildException;
import ebuild.base.Task;
import ebuild.core.EBuild;
import ebuild.core.Element;
import ebuild.core.ElementNature;
import ebuild.core.MetaDir;
import ebuild.core.Module;
import ebuild.core.Product;
import ebuild.core.RepositoryWorkingCopy;
import ebuild.core.impl.EBuildMode;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.KeyE;
import java.io.File;
import java.util.EnumMap;

public class WorkspaceProject {
    final EBuild ebuild;
    public final File dir;
    public final RepositoryWorkingCopy workingCopy;
    final MetaDir meta;
    private final KeyE key;
    private final EnumMap<ElementType, Element> elements = new EnumMap(ElementType.class);

    WorkspaceProject(EBuild ebuild, File dir, RepositoryWorkingCopy workingCopy) throws EBuildException {
        this.ebuild = ebuild;
        this.dir = dir;
        this.workingCopy = workingCopy;
        this.key = KeyE.newWorkingKey(null, dir.getName(), workingCopy.getBranch());
        this.meta = new MetaDir(ebuild, new File(dir, "meta"), this.key, ElementNature.source, EBuildMode.workspace);
    }

    public KeyE getKey(ElementType type) {
        return this.key.withType(type);
    }

    private Element newElement(ElementType type) throws EBuildException {
        if (!this.meta.hasPrimaryFile(type)) {
            return null;
        }
        KeyE key2 = this.key.withType(type);
        File releaseDir = new File(this.dir, "release");
        File buildDir = new File(this.dir, "build");
        Element r = this.ebuild.newElement(key2, this.meta.getElementMeta(type), this.dir, releaseDir, buildDir);
        r.setRepository(this.workingCopy.getRepository());
        r.setWorkspaceProject(this);
        return r;
    }

    public Element getElement(ElementType type) throws EBuildException {
        if (this.elements.containsKey(type)) {
            return this.elements.get(type);
        }
        Element r = this.newElement(type);
        this.elements.put(type, r);
        if (r != null) {
            r.META.getMetaDir().init(r.key.type);
        }
        return r;
    }

    public Element expectElement(ElementType type) throws EBuildException {
        Element r = this.getElement(type);
        if (r == null) {
            throw EBuildException.newConfProblem("No such element " + type + " for " + this.key);
        }
        return r;
    }

    public Element getPrimary() throws EBuildException {
        ElementType type = EBuildUtil.getElementType(this.dir);
        if (type == null) {
            return null;
        }
        Task.start("resolve first", this.dir);
        try {
            Element element = this.getElement(type);
            return element;
        }
        finally {
            Task.end(this.dir);
        }
    }

    public boolean hasModule() {
        return this.getModule() != null;
    }

    public Module getModule() {
        return (Module)this.elements.get(ElementType.module);
    }

    public boolean hasProduct() {
        return this.getProduct() != null;
    }

    public Product getProduct() {
        return (Product)this.elements.get(ElementType.product);
    }
}

