/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.conf;

import ebuild.core.conf.ConfExpr;
import ebuild.core.conf.ConfMap;
import ebuild.util.CollectionUtil;
import ebuild.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfMapping {
    public static final ConfMapping EMPTY = new ConfMapping(CollectionUtil.EMPTY_SET);
    public static final ConfMapping IDENTITY = new ConfMapping(CollectionUtil.singletonList(new Item(ConfExpr.TRUE, ConfMap.STAR)));
    public final Collection<Item> items;

    ConfMapping(Collection<Item> items) {
        this.items = items;
    }

    public ConfMap evaluate(ConfMap input) {
        ConfMap.Builder r = new ConfMap.Builder();
        this.evaluate(input, r);
        return r.build();
    }

    public void evaluate(ConfMap input, ConfMap.Builder builder) {
        for (Item e : this.items) {
            e.select(input, builder);
        }
    }

    public String toString() {
        ArrayList<String> r = new ArrayList<String>(this.items.size());
        for (Item e : this.items) {
            r.add(e.toString());
        }
        Collections.sort(r);
        return StringUtil.join(";", r);
    }

    public static class Item {
        public final ConfExpr expr;
        public final ConfMap to;

        public Item(ConfExpr expr, ConfMap to) {
            this.expr = expr;
            this.to = to;
        }

        public void select(ConfMap input, ConfMap.Builder r) {
            if (this.expr.evaluate(input)) {
                if (this.to == ConfMap.STAR) {
                    r.addAll(input);
                } else {
                    r.addAll(this.to);
                }
            }
        }

        public String toString() {
            return String.valueOf(this.expr.toString()) + "->" + this.to.toString();
        }
    }
}

