/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.impl;

import ebuild.api.common.ElementType;
import ebuild.api.common.IElementKey;
import ebuild.api.common.IVersion;
import ebuild.base.EBuildException;
import ebuild.core.impl.Version;
import ebuild.util.ObjectUtil;
import ebuild.util.StringUtil;
import java.io.File;

public class KeyE
implements IElementKey,
Comparable {
    public static final String UNIVERSE_PROJECT = "project";
    public static final String UNIVERSE_RELEASE = "release";
    public final ElementType type;
    public final String universe;
    public final String org;
    public final String name;
    public final Version version;

    public static KeyE newWorkingKey(ElementType type, String org_name, String branch) throws EBuildException {
        String[] ss = org_name.split("-");
        if (ss.length != 2) {
            throw EBuildException.newBadRequest("Expected form of ebuild project directories is [org]-[name], got: " + org_name);
        }
        return KeyE.newRevision(type, UNIVERSE_PROJECT, ss[0], ss[1], branch, "working");
    }

    public static KeyE newRevision(ElementType type, String universe, String org, String name, String branch, String revision) throws EBuildException {
        return new KeyE(type, universe, org, name, Version.newRevision(branch, revision));
    }

    public static KeyE newTagged(ElementType type, String universe, String org, String name, String version) {
        return new KeyE(type, universe, org, name, Version.newTag(version));
    }

    public static KeyE newUnversioned(String universe, String org, String name) {
        return new KeyE(null, universe, org, name, null);
    }

    public KeyE(ElementType type, String universe, String org, String name, Version version) {
        this.type = type;
        this.universe = universe;
        this.org = org;
        this.name = name;
        this.version = version;
    }

    public KeyE withoutType() {
        return new KeyE(null, this.universe, this.org, this.name, this.version);
    }

    public KeyE withName(String name2) {
        return new KeyE(this.type, this.universe, this.org, name2, this.version);
    }

    public KeyE withOrg(String org2) {
        return new KeyE(this.type, this.universe, org2, this.name, this.version);
    }

    public KeyE withVersion(Version version2) {
        if (version2 == this.version) {
            return this;
        }
        return new KeyE(this.type, this.universe, this.org, this.name, version2);
    }

    public KeyE withTag(String tag) {
        return this.withVersion(Version.newTag(tag));
    }

    public KeyE withRevision(String revision) {
        return this.withVersion(this.version.withRevision(revision));
    }

    public KeyE withType(ElementType type2) {
        if (type2 == this.type) {
            return this;
        }
        return new KeyE(type2, this.universe, this.org, this.name, this.version);
    }

    public String getDefaultWorkspaceName() {
        return String.valueOf(this.org) + "-" + this.name;
    }

    public KeyE asWorking() {
        return this.asWorking(this.type, this.version.getBranch());
    }

    public KeyE asWorking(ElementType type, String branch) {
        return new KeyE(type, UNIVERSE_PROJECT, this.org, this.name, Version.newRevision(branch, "working"));
    }

    public String fullname() {
        return String.valueOf(this.org) + "-" + this.name;
    }

    public String fullnameAndVersion() {
        String r = this.fullname();
        if (this.version != null) {
            r = String.valueOf(r) + "-" + this.version;
        }
        return r;
    }

    public String fullnameAndVersionAndUniverse() {
        String r = this.fullnameAndVersion();
        if (this.universe != null) {
            r = String.valueOf(this.universe) + "/" + r;
        }
        return r;
    }

    public String toString() {
        return String.valueOf(StringUtil.rpad(9, "" + this.type)) + " " + this.fullnameAndVersionAndUniverse();
    }

    public File getSubDirectoryOfLibrary(File libraryDir) {
        return this.getSubDirectoryOfUniverse(new File(libraryDir, this.universe));
    }

    public File getSubDirectoryOfUniverse(File universeDir) {
        return new File(universeDir, this.asLibraryPath());
    }

    public String asLibraryFilePath() {
        if (this.version.isTag()) {
            return String.valueOf(this.fullname()) + "/" + this.version.getTag();
        }
        if (this.version.isTrunk()) {
            return String.valueOf(this.fullname()) + "/trunk/" + this.version.getRevision();
        }
        return String.valueOf(this.fullname()) + "/branches/" + this.version.getBranch() + "/" + this.version.getRevision();
    }

    public String asLibraryPath() {
        return String.valueOf(this.asLibraryFilePath()) + "/";
    }

    public int hashCode() {
        return ObjectUtil.hashOf(this.type) + ObjectUtil.hashOf(this.universe) + ObjectUtil.hashOf(this.org) + ObjectUtil.hashOf(this.name) + ObjectUtil.hashOf(this.version);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KeyE)) {
            return false;
        }
        KeyE b = (KeyE)obj;
        return ObjectUtil.areEqual(this.type, b.type) && ObjectUtil.areEqual(this.universe, b.universe) && ObjectUtil.areEqual(this.org, b.org) && ObjectUtil.areEqual(this.name, b.name) && ObjectUtil.areEqual(this.version, b.version);
    }

    public String getOrg() {
        return this.org;
    }

    public String getName() {
        return this.name;
    }

    public ElementType getType() {
        return this.type;
    }

    public IVersion getVersion() {
        return this.version;
    }

    public int compareTo(Object o) {
        KeyE b = (KeyE)o;
        return this.toString().compareTo(b.toString());
    }
}

