/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.run;

import ebuild.api.core.IEBuildRunner;
import ebuild.api.plugin.IEclipseNature;
import ebuild.api.repo.AbstractRepositoryProvider;
import ebuild.base.EBuildException;
import ebuild.base.EBuildLogger;
import ebuild.base.PluginUtil;
import ebuild.base.ReportBuilder;
import ebuild.base.Task;
import ebuild.core.Action;
import ebuild.core.ActionQueue;
import ebuild.core.ActionStatus;
import ebuild.core.BuildPlan;
import ebuild.core.BuildPlanRunner;
import ebuild.core.EBuild;
import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.ModuleVersion;
import ebuild.core.impl.BuildTask;
import ebuild.core.impl.BuildTaskSet;
import ebuild.core.run.ReleaseRunner;
import ebuild.htmlreport.HtmlReport;
import ebuild.options.OptionsBuilder;
import ebuild.options.OptionsUtil;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.util.StringUtil;
import ebuild.util.ZipUtil;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EBuildRunner
extends BuildPlanRunner
implements IEBuildRunner {
    private Map<String, AbstractRepositoryProvider> repoProviders = new LinkedHashMap<String, AbstractRepositoryProvider>(0);
    private EBuild ebuild;

    protected EBuildRunner() {
    }

    @Override
    protected EBuildLogger getLogger() {
        return this.getEBuild().logger;
    }

    @Override
    protected EBuild getEBuild() {
        if (this.ebuild == null) {
            throw new Error("Not initialised");
        }
        return this.ebuild;
    }

    @Override
    public abstract String getKey();

    @Override
    public abstract void go() throws Exception;

    @Override
    protected void log(String msg) {
        this.getLogger().log(msg);
    }

    @Override
    protected void loge(String msg) {
        String[] stringArray = msg.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.getLogger().log("!! " + s);
            ++n2;
        }
    }

    private static String versionCode() {
        if ("0.8.5" != null) {
            return "0.8.5";
        }
        String r = "";
        if (ModuleVersion.BRANCH != null) {
            r = String.valueOf(ModuleVersion.BRANCH) + "/";
        }
        return String.valueOf(r) + ModuleVersion.REVISION;
    }

    public void go(ElementC cElement, BuildTask task) throws Exception {
        this.go(this.ebuild.getBuildPlan(cElement), task);
    }

    @Override
    public void go(BuildPlan mainPlan, BuildTask task) throws Exception {
        BuildTaskSet tasks = new BuildTaskSet(task);
        this.log("");
        this.log("");
        this.log("////////////////////////////////////");
        this.log("////// Resolve And Configure ///////");
        this.log("");
        this.resolveAndConfigure(mainPlan, tasks);
        this.log("");
        this.log("");
        this.log("////////////////////////////");
        this.log("////// Plan Task List //////");
        this.log("");
        this.buildActionList(mainPlan, tasks);
        this.log("");
        this.log("");
        this.log("//////////////////////////");
        this.log("////// Execute Plan //////");
        this.log("");
        this.run(this.ebuild.queue);
    }

    @Override
    protected void resolveAndConfigure(BuildPlan mainPlan, BuildTaskSet tasks) throws EBuildException {
        mainPlan.resolveAndConfigure(tasks);
        if (this.ebuild.isDEBUG()) {
            this.log("");
            this.log("Build Plans");
            for (Object k : this.ebuild.buildPlans.keySet()) {
                this.log("  " + k);
            }
        }
    }

    private void buildActionList(BuildPlan mainPlan, BuildTaskSet tasks) throws Exception {
        String key = this.getKey();
        Task.start("plan actions", key);
        try {
            mainPlan.buildActionList(this.ebuild.queue, tasks);
        }
        finally {
            Task.end(key);
        }
        this.ebuild.queue.removeDuplicates();
        for (Action a : this.ebuild.queue) {
            this.log("queued " + StringUtil.rpad(7, a.getStatus().displayString()) + " " + a.format());
        }
    }

    private void run(ActionQueue queue) throws Exception {
        for (Action action : queue) {
            if (action.getStatus() == ActionStatus.done && !this.ebuild.options.noSkipping) {
                this.log("- skipping  " + action + " -");
                this.getLogger().setProvisionalHeading("\n");
                action.finish(true);
                this.getLogger().setProvisionalHeading(null);
                continue;
            }
            this.log("- executing " + action + " -");
            this.getLogger().setProvisionalHeading("\n");
            action.run(this.getLogger());
            action.finish(false);
            this.getLogger().setProvisionalHeading(null);
        }
    }

    protected abstract EBuild.Options getOptions();

    protected abstract void readOptions(OptionsBuilder var1, String[] var2);

    protected abstract void formatOptionValues(OptionsBuilder var1);

    protected void init0(EBuild ebuild) {
        this.ebuild = ebuild;
        for (String repoType : this.repoProviders.keySet()) {
            ebuild.REPOS.addProviderPlugin(repoType, this.repoProviders.get(repoType));
        }
    }

    protected void init1() throws EBuildException {
        for (File f : this.ebuild.options.workspaces) {
            if (f.isDirectory()) continue;
            throw EBuildException.newBadRequest("Invalid directory: " + f.getPath());
        }
    }

    private boolean isValidApiClassLoader(ClassLoader apiClassLoader) {
        try {
            apiClassLoader.loadClass(EBuild.class.getName());
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                apiClassLoader.loadClass(IEclipseNature.class.getName());
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return false;
            }
            return true;
        }
    }

    public Callable<String> run(String[] args) {
        EBuild.Options options = this.getOptions();
        if (OptionsUtil.isPrintOptions(args)) {
            System.err.println(OptionsUtil.formatOptions(ReleaseRunner.Options.class));
            return null;
        }
        System.err.println("Pass argument ? to print out options");
        OptionsBuilder<EBuild.Options> optionsBuilder = new OptionsBuilder<EBuild.Options>(options);
        this.readOptions(optionsBuilder, args);
        Callable<String> r = optionsBuilder.verify();
        if (r != null) {
            return r;
        }
        this.formatOptionValues(optionsBuilder);
        ClassLoader apiClassLoader = this.getClass().getClassLoader().getParent();
        assert (this.isValidApiClassLoader(apiClassLoader));
        this.init0(new EBuild(apiClassLoader, options));
        return this.run();
    }

    public void addRepoProvider(String repoType, AbstractRepositoryProvider provider) {
        this.repoProviders.put(repoType, provider);
    }

    private Callable<String> run() {
        if (this.getEBuild().isDEBUG()) {
            this.log("system classloader path: ");
            this.log(PluginUtil.displayClassloader(this.ebuild, ClassLoader.getSystemClassLoader()));
            this.log("core classloader path: ");
            this.log(PluginUtil.displayClassloader(this.ebuild, EBuildRunner.class.getClassLoader()));
        }
        ReportBuilder.Stream report = new ReportBuilder.Stream(this.getLogger().out);
        try {
            try {
                this.init1();
                this.go();
            }
            finally {
                this.getLogger().printReportOfWarnings(report);
            }
            return null;
        }
        catch (Throwable e) {
            this.getLogger().log("");
            this.getLogger().printReportOfError(report, e, EBuildRunner.versionCode());
            Callable<String> callable = new Callable<String>(){

                @Override
                public String call() throws Exception {
                    ReportBuilder.Memory report = new ReportBuilder.Memory();
                    EBuildRunner.this.getLogger().printReportOfError(report, e, EBuildRunner.versionCode());
                    return report.toString();
                }
            };
            return callable;
        }
        finally {
            this.getLogger().prime();
            this.printHtmlBuildReport();
        }
    }

    protected void printHtmlBuildReport() {
        if (this.ebuild.reportDatabase != null) {
            new HtmlReport(this.ebuild).generate();
        }
    }

    protected void releaseSource(File outputDir, String sourceReleaseName, boolean workspace) throws Exception {
        EBuild ebuild = this.getEBuild();
        File releaseDir = new File(outputDir, sourceReleaseName);
        this.log("");
        this.log("Releasing source: " + ebuild.formatAsDisplayPath(releaseDir));
        File seed = new File(releaseDir, "_ebuild/seed");
        FileUtil.mkdirOrFail(seed);
        if (workspace) {
            for (Element e : ebuild.WORKSPACES.getResolvedElements()) {
                if (e == null) continue;
                Set<String> ignores = CollectionUtil.newSet("build", "release", "gen");
                File projectIn = e.getProjectDirectory();
                File projectOut = new File(releaseDir, projectIn.getName());
                FileUtil.mkdirOrFail(projectOut);
                File[] fileArray = projectIn.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (!ignores.contains(f.getName())) {
                        File bad = new File(f, projectOut.getName());
                        FileUtil.deleteDir(bad);
                        FileUtil.copyToDir(f, projectOut);
                    }
                    ++n2;
                }
            }
        } else {
            File library = new File(releaseDir, "_ebuild/library/ebuild");
            library.mkdirs();
            for (Element e : ebuild.LIBRARY.getResolvedElements()) {
                Element p;
                File releasePartDir = e.key.getSubDirectoryOfUniverse(library);
                File releaseMeta = new File(releasePartDir, "meta");
                FileUtil.mkdirOrFail(releaseMeta);
                for (File f : e.getMetaFiles()) {
                    FileUtil.copyToDir(releaseMeta, f);
                }
                if (!(e instanceof Element) || !(p = e).isSource()) continue;
                File builtSource = p.getProjectDirectory();
                FileUtil.copyToDir(builtSource, releasePartDir);
            }
        }
        FileUtil.copyToDir(ebuild.HOME.getFile("seed/version"), seed);
        FileUtil.copyToDir(ebuild.HOME.getFile("seed/build.xml"), seed);
        File archive = new File(outputDir, String.valueOf(sourceReleaseName) + "-source.zip");
        this.log("Archiving library as: " + ebuild.formatAsDisplayPath(archive));
        ZipUtil.zipDirectoryIncludeName(archive, releaseDir);
        FileUtil.deleteDir(releaseDir);
    }
}

