/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.run;

import ebuild.api.common.ElementType;
import ebuild.api.common.Scope;
import ebuild.api.log.ILogger;
import ebuild.api.repo.RepositoryPluginException;
import ebuild.base.EBuildException;
import ebuild.base.MetaType;
import ebuild.base.Task;
import ebuild.core.Artifact;
import ebuild.core.EBuild;
import ebuild.core.EBuildContext;
import ebuild.core.EBuildContextOfRoot;
import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.ElementReleaseArtifact;
import ebuild.core.Module;
import ebuild.core.ModuleC;
import ebuild.core.ModuleDeps;
import ebuild.core.Product;
import ebuild.core.ProductC;
import ebuild.core.ProductReleaseArtifact;
import ebuild.core.RepositoryInstance;
import ebuild.core.RepositoryRef;
import ebuild.core.RepositoryWorkingCopy;
import ebuild.core.TopBuildPlan;
import ebuild.core.WorkspaceProject;
import ebuild.core.impl.BuildTask;
import ebuild.core.impl.ConfKey;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.Exclude;
import ebuild.core.impl.KeyC;
import ebuild.core.impl.KeyE;
import ebuild.core.impl.Select;
import ebuild.core.impl.Version;
import ebuild.core.run.EBuildRunner;
import ebuild.options.DisplayOrder;
import ebuild.options.OptionsBuilder;
import ebuild.options.OptionsUtil;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.util.Logger;
import ebuild.util.StringUtil;
import ebuild.xml.CmnXml;
import ebuild.xml.OptXml;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseRunner
extends EBuildRunner {
    private final Options options = new Options();
    private EBuildContext releaseContext;
    private List<Select> selected = new ArrayList<Select>();
    private Map<Select, ElementC> selectedElementCs;
    private OptXml.EBuildReleaseOptions fileOptions;
    private Map<String, RepositoryRef> projectRepos = new HashMap<String, RepositoryRef>();

    @Override
    protected EBuild.Options getOptions() {
        return this.options;
    }

    @Override
    protected void readOptions(OptionsBuilder optionsBuilder, String[] args) {
        Options optionsObj = (Options)optionsBuilder.getOptionsObj();
        Map<String, String> optionsMap = OptionsUtil.read(args);
        optionsBuilder.merge(optionsMap);
        if (optionsObj.optionsFile != null) {
            try {
                this.fileOptions = OptXml.deserialize(optionsObj.optionsFile);
                optionsBuilder.merge(this.fileOptions.options);
            }
            catch (Exception e) {
                optionsBuilder.addError("Could not read options file: " + e.getMessage());
            }
        }
        if (!optionsObj.home.exists()) {
            optionsBuilder.addError("_ebuild directory does not exist: " + optionsObj.home);
        }
    }

    @Override
    protected void formatOptionValues(OptionsBuilder optionsBuilder) {
        final Options options = (Options)optionsBuilder.getOptionsObj();
        final Set<String> set = optionsBuilder.getSetOptions();
        System.err.println("////////////////////////////////////////////////////////////");
        System.err.println(OptionsUtil.formatOptionValues((Object)options, new CollectionUtil.Filter<String>(){

            @Override
            public boolean accept(String f) {
                Object v = OptionsUtil.getValue(options, f);
                if ("no-skipping".equals(f) || "verbose".equals(f) || "debug".equals(f)) {
                    return v == Boolean.TRUE;
                }
                if ("home".equals(f)) {
                    return options.debug;
                }
                return set.contains(f);
            }
        }));
        System.err.println("////////////////////////////////////////////////////////////");
        System.err.println("");
    }

    @Override
    protected void init1() throws EBuildException {
        this.releaseContext = new EBuildContextOfRoot(this.getEBuild(), "Release Context");
        this.releaseContext.addParents(this.getEBuild().context);
        this.interpretFileOptions(this.fileOptions);
    }

    private void addRepos(List<CmnXml.Repository> repos) throws EBuildException {
        this.releaseContext.addNamedRepository("workspace", this.getEBuild().HOME.getWorkspaceWorkingCopy().getRepository(), null);
        for (CmnXml.Repository r : repos) {
            this.releaseContext.addRepository(r);
        }
    }

    private OptXml.Select getSelect(Options options) throws EBuildException {
        OptXml.Select r = new OptXml.Select();
        r.elementType = options.elementType;
        r.org = options.org;
        r.name = options.name;
        r.artifact = options.artifact;
        r.tag = options.tag;
        r.branch = options.branch;
        r.revision = options.revision;
        r.confs = options.confs;
        return r;
    }

    private void addKeys(OptXml.Select select, OptXml.Select prototype) throws EBuildException {
        OptXml.Select prototype2 = prototype.clone(select);
        if ("*".equals(prototype2.name)) {
            Version version = EBuildUtil.asVersion(prototype2, Version.TRUNK_HEAD);
            RepositoryRef repo = this.releaseContext.lookupRepository(prototype2.source);
            try {
                this.log("////////////////////////////////////////////////////////////");
                this.log("//// List all projects for " + version + ":-");
                List<KeyE> l = repo.getRepo().listElements(version);
                for (KeyE ekey : l) {
                    KeyC cekey = new KeyC(ekey, new ConfKey(prototype2.confs));
                    this.log("////     " + cekey);
                    this.selected.add(new Select(prototype2.source, cekey, prototype2.artifact));
                }
                this.log("//// Total " + l.size());
                this.log("////////////////////////////////////////////////////////////");
            }
            catch (RepositoryPluginException e) {
                throw EBuildException.newRepoIssue("Unable to fetch project list for " + version, e);
            }
        } else {
            this.addKeys(select.subSelects, prototype2);
        }
    }

    private void addKeys(List<OptXml.Select> selects, OptXml.Select prototype) throws EBuildException {
        if (selects.size() == 0) {
            Version version = EBuildUtil.asVersion(prototype, Version.TRUNK_HEAD);
            KeyE ekey = new KeyE(prototype.elementType, "project", prototype.org, prototype.name, version);
            KeyC cekey = new KeyC(ekey, new ConfKey(prototype.confs));
            this.selected.add(new Select(prototype.source, cekey, prototype.artifact));
        } else {
            for (OptXml.Select selDef : selects) {
                this.addKeys(selDef, prototype);
            }
        }
    }

    private void interpretFileOptions(OptXml.EBuildReleaseOptions fileOptions) throws EBuildException {
        List<OptXml.Select> selects = CollectionUtil.EMPTY_LIST;
        if (fileOptions != null) {
            this.addRepos(fileOptions.repositories);
            selects = fileOptions.selects;
        }
        this.addKeys(selects, this.getSelect(this.options));
        if (this.selected.size() == 0) {
            throw EBuildException.newBadRequest("No element selected - set org,name ... etc. or  <select/> in options file ");
        }
    }

    @Override
    public void go() throws Exception {
        this.releaseContext.addLocalRepository(this.useRepo(this.getLogger(), this.getEBuild().HOME.getWorkspaceWorkingCopy(), "_ebuild"), null);
        this.selectedElementCs = new LinkedHashMap<Select, ElementC>(this.selected.size());
        Task.start("Resolve Top", "");
        try {
            for (Select select : this.selected) {
                try {
                    this.selectedElementCs.put(select, this.resolveTop(select));
                }
                catch (Exception e) {
                    this.getLogger().warn("Could not resolve " + select, e);
                }
            }
        }
        finally {
            Task.end("");
        }
        if (this.selectedElementCs.size() == 0) {
            throw EBuildException.newBadRequest("Did not successfully select a single repository");
        }
        TopBuildPlan plan = new TopBuildPlan(this.getEBuild(), this.selectedElementCs.values());
        if (this.options.source) {
            this.go(plan, BuildTask.release_source);
        } else {
            this.go(plan, BuildTask.build_release);
        }
        if (this.options.source) {
            for (Select s : this.selected) {
                this.copySource(s.key.ekey);
            }
        } else {
            this.copyReleases();
        }
    }

    private Element resolveTop(String source, KeyE key) throws Exception {
        Version v;
        RepositoryRef repoRef = source == null ? this.guessInitialSourceRepository(key) : this.releaseContext.lookupRepository(source);
        if (StringUtil.isEmptyString(key.org) && repoRef != null) {
            key.withOrg(repoRef.expectOrg(null));
        }
        if ((v = key.version).isHead()) {
            RepositoryInstance.Source srepo = repoRef.expectSourceRepo();
            String revision = this.getEBuild().getWorkspaceHeadRevision(srepo);
            this.log("");
            this.log("head -> " + revision);
            this.log("");
            v = Version.newRevision(v.getBranch(), revision);
            key = key.withVersion(v);
        }
        return this.getEBuild().LIBRARY.resolveElement(repoRef, key);
    }

    private ElementC resolveTop(Select select) throws Exception {
        Element el = this.resolveTop(select.source, select.key.ekey);
        ConfKey subKey = select.key.subkey;
        return el.getCPart(subKey);
    }

    private RepositoryInstance.Source useRepo(ILogger logger, RepositoryWorkingCopy wc, String path) throws EBuildException {
        RepositoryInstance r = null;
        if (wc != null && (r = wc.getRepository()).isSource()) {
            logger.log("... using location [workspace]/" + path + " to locate repository");
            logger.log("Repository: " + r);
            return r.asSourceSafe();
        }
        logger.log("[workspace]/" + path + " exists, but not linked to a repository");
        return null;
    }

    private RepositoryRef guessInitialSourceRepository(KeyE key) throws Exception {
        Logger logger = this.getLogger().newSubLogger("Guess initial repository");
        logger.log("No repository supplied, attempting to guess repository");
        logger.log("");
        WorkspaceProject wsp = this.getEBuild().WORKSPACES.getWorkspaceProject(key.getDefaultWorkspaceName());
        if (wsp != null) {
            RepositoryInstance.Source r = this.useRepo(logger, wsp.workingCopy, wsp.dir.getName());
            String n = r.getUri();
            RepositoryRef ref = this.projectRepos.get(n);
            if (ref == null) {
                ref = this.releaseContext.addNamedRepository(n, r, null);
                this.projectRepos.put(n, ref);
            }
            return ref;
        }
        logger.log("... " + key + " not in workspace");
        return this.releaseContext.getRepository("local");
    }

    private String sourceReleaseName() {
        if (this.selected.size() != 1) {
            throw new Error("Multiple released elements for source release not supported");
        }
        Object p = this.selectedElementCs.get((Object)this.selected.get((int)0)).element;
        if (p instanceof Product) {
            return ((Product)p).releaseSourceFileName();
        }
        return ((Element)p).key.fullnameAndVersion();
    }

    void copySource(KeyE key) throws Exception {
        String sourceReleaseName = this.sourceReleaseName();
        File outputDir = this.options.getOutputDirectory();
        this.releaseSource(outputDir, sourceReleaseName, false);
    }

    private void doCopy(File f, File toDir) throws IOException {
        this.log("  <-" + this.getEBuild().formatAsDisplayPath(f));
        FileUtil.copyToDir(f, toDir);
    }

    private void copyToReleaseLib(File releaseLib, ElementC builtElementC) throws Exception {
        Object builtPart = builtElementC.element;
        File builtMeta = ((Element)builtPart).getMetaMainFile();
        File builtPlugin = null;
        if (builtPart instanceof Module) {
            builtPlugin = ((Element)builtPart).META.getMetaDir().getFile(MetaType.BUILD_PLUGIN);
        }
        File releasePartDir = ((Element)builtPart).key.getSubDirectoryOfUniverse(releaseLib);
        File releaseReleaseDir = new File(releasePartDir, "release");
        File releaseMetaDir = new File(releasePartDir, "meta");
        releaseReleaseDir.mkdirs();
        releaseMetaDir.mkdirs();
        File[] fileArray = ((Element)builtPart).getReleaseDirectory().listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            this.doCopy(f, releaseReleaseDir);
            ++n2;
        }
        this.doCopy(builtMeta, releaseMetaDir);
        ((Element)builtPart).context.UPSTREAM_REVISIONS.generateWithLocals(releaseMetaDir);
        if (builtPlugin != null) {
            this.doCopy(builtPlugin, releaseMetaDir);
        }
    }

    void copyReleases() throws Exception {
        File releaseDir;
        File releaseLib = this.options.getOutputLibrary();
        if (releaseLib != null) {
            this.log("");
            this.log("Releasing to library: " + this.getEBuild().formatAsDisplayPath(releaseLib));
            ModuleDeps.RecurseRule recurseRule = new ModuleDeps.RecurseRule(){

                public boolean ignore(ModuleDeps.ModuleDep md) {
                    return md.subsumed;
                }
            };
            ModuleDeps.GathererOfReleases gatherer = new ModuleDeps.GathererOfReleases();
            gatherer.setContinueRule(recurseRule);
            for (ElementC elementC : this.selectedElementCs.values()) {
                if (elementC.element instanceof Module) {
                    Module module = (Module)elementC.element;
                    ModuleDeps moduleDeps = (ModuleDeps)elementC.getDependencies(Scope.MAIN);
                    Exclude exclude = module.isPlugin() ? ModuleC.NOAPI : Exclude.NONE;
                    moduleDeps.doDeepGather(gatherer, recurseRule, exclude);
                }
                Iterator ers = elementC.iterateReleases();
                Iterator<Object> iterator = ers.iterator();
                while (iterator.hasNext()) {
                    ElementReleaseArtifact elementReleaseArtifact = (ElementReleaseArtifact)iterator.next();
                    gatherer.releases.add(elementReleaseArtifact);
                }
            }
            HashSet<ElementC> elementCs = new HashSet<ElementC>();
            for (Artifact r : gatherer.releases) {
                elementCs.add(r.getElementC());
            }
            for (ElementC elementC : elementCs) {
                this.copyToReleaseLib(releaseLib, elementC);
            }
        }
        if ((releaseDir = this.options.getOutputDirectory()) != null) {
            releaseDir.mkdirs();
            this.log("");
            this.log("Copying released components to " + this.getEBuild().formatAsDisplayPath(releaseDir));
            for (Select select : this.selected) {
                ElementC elementC;
                elementC = this.selectedElementCs.get(select);
                if (!(elementC instanceof ProductC)) continue;
                Collection<ElementReleaseArtifact> prs = elementC.iterateReleases();
                for (ProductReleaseArtifact productReleaseArtifact : prs) {
                    this.doCopy(productReleaseArtifact.artifactFile, releaseDir);
                }
            }
        }
    }

    @Override
    public String getKey() {
        return "release";
    }

    @DisplayOrder(value={"org", "name", "branch", "revision", "tag", "confs", "", "output-library", "output-directory"})
    public static class Options
    extends EBuild.Options {
        public File optionsFile;
        public ElementType elementType;
        public String org;
        public String name;
        public String artifact;
        public String branch;
        public String revision;
        public String tag;
        public String confs;
        public boolean source;
        public File outputLibrary;
        public File outputDirectory;

        public File getOutputDirectory() {
            File r = this.outputDirectory;
            if (r == null) {
                return null;
            }
            if (!r.isAbsolute()) {
                r = new File(this.home, this.outputDirectory.getPath());
            }
            return r;
        }

        public File getOutputLibrary() {
            File r = this.outputLibrary;
            if (r == null) {
                return null;
            }
            if (!r.isAbsolute()) {
                r = new File(this.home, this.outputLibrary.getPath());
            }
            return r;
        }

        boolean hasTag() {
            return !StringUtil.isEmptyString(this.tag);
        }
    }
}

