/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.run;

import ebuild.api.log.ILogger;
import ebuild.base.EBuildException;
import ebuild.base.PathJanitor;
import ebuild.core.BuildPlan;
import ebuild.core.BuildResolutionReport;
import ebuild.core.EBuild;
import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.SystemPlugins;
import ebuild.core.TopBuildPlan;
import ebuild.core.conf.ConfMap;
import ebuild.core.impl.BuildTask;
import ebuild.core.impl.ConfKey;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.run.EBuildRunner;
import ebuild.core.util.FileProcessor;
import ebuild.core.util.FileSelection;
import ebuild.core.util.FileTraversal;
import ebuild.core.util.FileVisitor;
import ebuild.options.DisplayOrder;
import ebuild.options.OptionsBuilder;
import ebuild.options.OptionsUtil;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;

public class WorkspaceRunner
extends EBuildRunner {
    private final Options options = new Options();

    protected EBuild.Options getOptions() {
        return this.options;
    }

    protected void readOptions(OptionsBuilder optionsBuilder, String[] args) {
        Options optionsObj = (Options)optionsBuilder.getOptionsObj();
        optionsBuilder.mergeArgs(args);
        if (optionsObj.projectDir != null) {
            optionsBuilder.mergeDefault("home", new File(optionsObj.projectDir, "../_ebuild").getPath());
            optionsBuilder.mergeDefault("workspaces", new File(optionsObj.projectDir, "..").getPath());
        } else {
            optionsBuilder.mergeDefault("workspaces", new File(optionsObj.home, "..").getPath());
        }
        optionsBuilder.mergeDefault("purge-library", "" + (optionsObj.task == BuildTask.eclipse_setup));
        if (!optionsObj.home.exists()) {
            optionsBuilder.addError("_ebuild directory does not exist: " + optionsObj.home);
        }
    }

    protected void formatOptionValues(OptionsBuilder optionsBuilder) {
        final Options options = (Options)optionsBuilder.getOptionsObj();
        final Set<String> set = optionsBuilder.getSetOptions();
        System.err.println("////////////////////////////////////////////////////////////");
        System.err.println(OptionsUtil.formatOptionValues((Object)options, new CollectionUtil.Filter<String>(){

            @Override
            public boolean accept(String f) {
                Object v = OptionsUtil.getValue(options, f);
                if ("no-skipping".equals(f) || "verbose".equals(f) || "debug".equals(f)) {
                    return Boolean.TRUE.equals(v);
                }
                if ("home".equals(f)) {
                    return !"../_ebuild".equals(f) || options.debug;
                }
                return set.contains(f);
            }
        }));
        System.err.println("////////////////////////////////////////////////////////////");
        System.err.println("");
    }

    public String getKey() {
        return "workspace";
    }

    public void go() throws Exception {
        BuildPlan buildPlan;
        this.getEBuild().updateUpstream = this.options.updateUpstream;
        BuildTask task = this.options.task;
        BuildResolutionReport report = this.getEBuild().report;
        Element theElement = null;
        report.startResolve(this.getEBuild().context, "Workspace");
        if (this.options.projectDir != null && !"_ebuild".equals(this.options.projectDir.getName())) {
            theElement = this.getEBuild().context.resolveWorkspaceElement(this.options.projectDir.getName());
            if (theElement == null) {
                throw EBuildException.newBadRequest("Not an ebuild project: " + this.options.projectDir);
            }
            ConfMap confSet = EBuildUtil.parseConfMap(this.options.confs);
            buildPlan = this.getEBuild().getBuildPlan(theElement.getCPart(new ConfKey(confSet)));
        } else {
            ArrayList<ElementC> elements = new ArrayList<ElementC>();
            this.log("////////////////////////////////////////////////////////////");
            this.log("//// Resolving workspace:-");
            for (File workspace : this.options.getWorkspaces()) {
                this.log("////      " + this.getEBuild().formatAsDisplayPath(workspace));
                File[] fileArray = workspace.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File projectCandidate = fileArray[n2];
                    try {
                        Element element = this.getEBuild().context.resolveWorkspaceElement(projectCandidate.getName());
                        if (element != null && element.PROJECT.META != null) {
                            elements.add(element.getDefault());
                        }
                    }
                    catch (EBuildException e) {
                        this.getLogger().warn("Not a valid ebuild project: " + projectCandidate, e);
                    }
                    ++n2;
                }
            }
            this.log("////////////////////////////////////////////////////////////");
            buildPlan = new TopBuildPlan(this.getEBuild(), elements);
        }
        report.endResolve();
        this.go(buildPlan, task);
        if (task == BuildTask.release_source) {
            if (theElement != null) {
                File outputDir = theElement.getReleaseDirectory();
                this.releaseSource(outputDir, theElement.getName(), true);
            } else {
                throw EBuildException.newBadRequest("Unsupported task release_source on entire workspace. Select individual project");
            }
        }
        if (this.options.purgeLibrary) {
            this.getLogger().setProvisionalHeading("*** purging library ****");
            FileSelection keep = new FileSelection(this.getEBuild().LIBRARY.root);
            EBuild ebuild = this.getEBuild();
            keep.add(ebuild.LIBRARY.meta);
            for (SystemPlugins.PluginPath p : ebuild.PLUGINS.listInstalledPlugins()) {
                for (String jar : p.classpath) {
                    File jarFile = new File(jar);
                    File moduleDir = WorkspaceRunner.getModuleDirOfJarFile(jarFile);
                    if (moduleDir == null) {
                        keep.add(jarFile);
                        continue;
                    }
                    keep.add(moduleDir);
                }
            }
            for (File f : ebuild.LIBRARY.used) {
                keep.add(f);
            }
            WorkspaceRunner.purge(this.getLogger(), ebuild, ebuild.LIBRARY.root, keep);
        }
    }

    private static File getModuleDirOfJarFile(File jarFile) {
        File f = jarFile;
        while (f != null && !"release".equals(f.getName())) {
            f = f.getParentFile();
        }
        if (f == null) {
            return null;
        }
        return f.getParentFile();
    }

    public static void purge(final ILogger logger, final PathJanitor janitor, File root, final FileSelection keep) throws Exception {
        final FileVisitor<RuntimeException> deleter = new FileVisitor<RuntimeException>(){

            @Override
            public boolean dirBefore(File paramFile) {
                this.file(paramFile);
                return false;
            }

            @Override
            public void file(File paramFile) {
                try {
                    FileUtil.deleteDirOrFail(paramFile);
                    logger.log("Deleted: " + janitor.formatAsDisplayPath(paramFile));
                }
                catch (IOException iOException) {
                    logger.log("Could not delete: " + janitor.formatAsDisplayPath(paramFile));
                }
            }

            @Override
            public void dirAfter(File paramFile) {
            }
        };
        int deleted = (Integer)FileTraversal.traverse(new FileProcessor(){
            int count;

            private void delete(File f) throws Exception {
                FileTraversal.traverse(deleter, f);
            }

            public void file(File f) throws Exception {
                if (!keep.isSelected(f)) {
                    this.delete(f);
                }
            }

            public boolean dirBefore(File d) throws Exception {
                if (keep.isSelected(d)) {
                    return false;
                }
                if (keep.isPartiallySelected(d)) {
                    return true;
                }
                this.delete(d);
                return false;
            }

            public void dirAfter(File d) throws Exception {
            }

            public Integer finish() {
                return this.count;
            }
        }, root);
        if (deleted > 0) {
            logger.log(String.valueOf(deleted) + " files and directories purged from library as they are no longer used by the workspace");
        }
    }

    @DisplayOrder(value={"task", "confs", "projectDir", ""})
    public static class Options
    extends EBuild.Options {
        public BuildTask task = BuildTask.eclipse_setup;
        public String confs = "";
        public String artifact = null;
        public File projectDir;
        public boolean updateUpstream = true;
        public boolean purgeLibrary;
    }
}

