/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.util;

import ebuild.util.StringUtil;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class FileSelection {
    final Set<File> partial = new HashSet<File>();
    final Set<File> full = new HashSet<File>();

    public FileSelection(File ... roots) {
        File[] fileArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            File r = fileArray[n2];
            this.partial.add(r);
            ++n2;
        }
    }

    public void add(File select) {
        if (this.isSelected(select)) {
            return;
        }
        this.full.add(select);
        File f = select;
        while (f != null && !this.partial.contains(f)) {
            this.partial.add(f);
            f = f.getParentFile();
        }
    }

    public boolean isSelected(File file) {
        File f = file;
        while (f != null) {
            if (this.full.contains(f)) {
                return true;
            }
            if (this.partial.contains(f)) {
                return false;
            }
            f = f.getParentFile();
        }
        return false;
    }

    public boolean isPartiallySelected(File file) {
        return this.partial.contains(file);
    }

    public String toString() {
        TreeSet<File> r = new TreeSet<File>(this.full);
        return StringUtil.prefix("\n    ", r);
    }
}

