/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.util;

import ebuild.core.util.FileProcessor;
import ebuild.core.util.FileVisitor;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTraversal {
    public static <O, E extends Exception> O traverse(FileProcessor<O, E> processor, File ... files) throws E {
        FileTraversal.traverse(processor, files);
        return processor.finish();
    }

    public static <E extends Exception> void traverse(FileVisitor<E> visitor, File ... files) throws E {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.exists()) {
                FileTraversal.traverseInner(visitor, f);
            }
            ++n2;
        }
    }

    private static <E extends Exception> void traverseInner(FileVisitor<E> visitor, File f) throws E {
        if (f.isDirectory()) {
            boolean cont = visitor.dirBefore(f);
            if (cont) {
                File[] childs;
                File[] fileArray = childs = f.listFiles();
                int n = childs.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    FileTraversal.traverseInner(visitor, child);
                    ++n2;
                }
            }
            visitor.dirAfter(f);
        } else {
            visitor.file(f);
        }
    }
}

