/*
 * Decompiled with CFR 0.152.
 */
package ebuild.htmlreport;

import ebuild.api.log.ILogger;
import ebuild.base.EBuildException;
import ebuild.core.BuildResolutionReport;
import ebuild.core.EBuild;
import ebuild.core.impl.DependencyType;
import ebuild.core.impl.KeyE;
import ebuild.core.impl.Version;
import ebuild.util.FileUtil;
import ebuild.util.IOUtil;
import java.io.File;
import java.io.IOException;

public class HtmlReport {
    final EBuild ebuild;
    final ILogger logger;
    final BuildResolutionReport.Database database;
    final File dir;

    public HtmlReport(EBuild ebuild) {
        this.ebuild = ebuild;
        this.logger = ebuild.logger;
        this.database = ebuild.reportDatabase;
        this.dir = ebuild.HOME.getFile("report");
    }

    public void generate() {
        try {
            this.generateInner();
        }
        catch (IOException e) {
            EBuildException.newInternalError("IOException generating report", e);
        }
    }

    public String path(KeyE key) {
        String path = key.asLibraryFilePath();
        path = path.replace("*", "_");
        return String.valueOf(path) + ".html";
    }

    public String path(Object key) {
        if (key instanceof KeyE) {
            return this.path((KeyE)key);
        }
        return String.valueOf((String)key) + ".html";
    }

    public String colour(KeyE key) {
        if (key.version.isWorking()) {
            return "#FF9966";
        }
        return "#00CCFF";
    }

    public String colour(Object key) {
        if (key instanceof KeyE) {
            return this.colour((KeyE)key);
        }
        return "#FFFF99";
    }

    public Page newPage(BuildResolutionReport.Database.Entry entry) {
        return this.newPage(this.path(entry.key));
    }

    public Page newPage(String path) {
        File f = new File(this.dir, path);
        FileUtil.mkdirOrError(f.getParentFile());
        return new Page(f);
    }

    public void generateInner() throws IOException {
        this.logger.log("Generating Build Report: " + this.ebuild.formatAsDisplayPath(this.dir));
        if (this.dir.exists()) {
            this.logger.log("Deleting previous report");
            FileUtil.deleteDirOrError(this.dir);
        }
        Page css = this.newPage("style.css");
        css.write(IOUtil.resourceToString(HtmlReport.class, "style.css"));
        for (final BuildResolutionReport.Database.Entry entry : this.database.entries.values()) {
            final Page page = this.newPage(entry);
            final StringBuilder sb = new StringBuilder();
            new Object(){

                String versionType(Version version) {
                    if (version.isWorking()) {
                        return "workspace";
                    }
                    return "library";
                }

                String title() {
                    if (entry.key instanceof KeyE) {
                        KeyE key = (KeyE)entry.key;
                        String prodtype = key.type.toString();
                        String versionType = this.versionType(key.version);
                        return "<div class=\"title " + prodtype + "\">" + key.fullname() + "</div>" + "<div class=\"title " + versionType + "\">" + key.version + "</div>" + "<div class=\"clear\"/>";
                    }
                    return "<div class=\"title top\">Root</div><div class=\"clear\"/>";
                }

                void appendln(String s) {
                    sb.append(s);
                    sb.append("\n");
                }

                void run() throws IOException {
                    this.appendln("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\">");
                    this.appendln("<meta>");
                    this.appendln("<link rel='stylesheet' href='" + page.ref("style.css") + "' type='text/css'/>");
                    this.appendln("</meta>");
                    this.appendln("<body>");
                    this.appendln(this.title());
                    this.appendln("");
                    this.appendln("<h2>outgoing</h2>");
                    this.appendln("<table>");
                    this.appendln("<thead>");
                    this.appendln("<tr>");
                    this.appendln("<th>Type</th>");
                    this.appendln("<th>Name</th>");
                    this.appendln("<th>Version</th>");
                    this.appendln("</tr>");
                    this.appendln("</thead>");
                    this.appendln("<tbody>");
                    for (BuildResolutionReport.Database.ResolvedKey resolvedKey : entry.outgoing) {
                        KeyE otherKey = resolvedKey.resolved;
                        String otherType = otherKey.type.toString();
                        String otherName = otherKey.fullname();
                        String versionPath = HtmlReport.this.path(otherKey);
                        String versionType = this.versionType(otherKey.version);
                        String versionLabel = resolvedKey.selected.version.toString();
                        if (resolvedKey.isDifferent()) {
                            versionLabel = String.valueOf(versionLabel) + " ( -> " + resolvedKey.resolved.version + ")";
                        }
                        this.appendln("<thead><tr>");
                        this.appendln("<td>" + resolvedKey.depType.name + "</td>");
                        this.appendln("<td class=\"" + otherType + "\">" + otherName + "</td>");
                        this.appendln("<td class=\"" + versionType + "\">" + page.anchor(versionPath, versionLabel) + "</td>");
                        this.appendln("</tr></thead>");
                    }
                    this.appendln("</tbody>");
                    this.appendln("</table>");
                    this.appendln("<h2>incoming</h2>");
                    this.appendln("<table>");
                    this.appendln("<thead>");
                    this.appendln("<tr>");
                    this.appendln("<th>Type</th>");
                    this.appendln("<th>Name</th>");
                    this.appendln("<th>Version</th>");
                    this.appendln("</tr>");
                    this.appendln("</thead>");
                    this.appendln("<tbody>");
                    for (Comparable<BuildResolutionReport.Database.ResolvedKey> comparable : entry.incoming.keySet()) {
                        BuildResolutionReport.Database.ResolvedKey rkey = entry.incoming.get(comparable);
                        if (rkey.depType == DependencyType.TOP) {
                            this.appendln("<tr><td class=\"top\" colspan=\"3\">" + page.anchor("Root.html", "Root") + "</td></tr");
                            continue;
                        }
                        KeyE otherKey = (KeyE)comparable;
                        String otherType = otherKey.type.toString();
                        String otherName = otherKey.fullname();
                        String versionPath = HtmlReport.this.path(otherKey);
                        String versionType = this.versionType(otherKey.version);
                        String versionLabel = otherKey.version.toString();
                        if (rkey.isDifferent()) {
                            versionLabel = String.valueOf(versionLabel) + " (" + rkey.selected.version + "->" + ")";
                        }
                        this.appendln("<thead><tr>");
                        this.appendln("<td>" + rkey.depType.name + "</td>");
                        this.appendln("<td class=\"" + otherType + "\">" + otherName + "</td>");
                        this.appendln("<td class=\"" + versionType + "\">" + page.anchor(versionPath, versionLabel) + "</td>");
                        this.appendln("</tr></thead>");
                    }
                    this.appendln("</tbody>");
                    this.appendln("</table>");
                    this.appendln("</body>");
                    this.appendln("</html>");
                    page.write(sb.toString());
                }
            }.run();
        }
    }

    class Page {
        final File file;
        final String path2top;

        Page(File file) {
            this.file = file;
            String path = ".";
            File f = file.getParentFile();
            while (!f.equals(HtmlReport.this.dir)) {
                path = path == "." ? ".." : String.valueOf(path) + "/..";
                f = f.getParentFile();
            }
            this.path2top = path;
        }

        String ref(String path) {
            return String.valueOf(this.path2top) + "/" + path;
        }

        private String anchor(String path, String label) {
            return "<a href='" + this.ref(path) + "'>" + label + "</a>";
        }

        public void write(String string) throws IOException {
            IOUtil.stringToFile(string, this.file);
        }
    }
}

