/*
 * Decompiled with CFR 0.152.
 */
package ebuild.util.file;

import ebuild.util.FileUtil;
import ebuild.util.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileContainer {
    public static final Filter FILTER_ALL = new Filter(){

        public boolean accept(Entry entry) {
            return true;
        }
    };

    public Iterable<Entry> list() {
        return this.list(FILTER_ALL);
    }

    public void close() throws IOException {
    }

    public abstract Iterable<Entry> list(Filter var1);

    public abstract Entry newEntry(String var1) throws IOException;

    public static abstract class Entry {
        public abstract String getPath();

        public String getName() {
            String path = this.getPath();
            int slash = path.lastIndexOf(47);
            if (slash != -1) {
                return path.substring(slash + 1);
            }
            return path;
        }

        public String getFolderPath() {
            String path = this.getPath();
            int slash = path.lastIndexOf(47);
            if (slash != -1) {
                return path.substring(0, slash);
            }
            return null;
        }

        public String getSuffix() {
            String name = this.getName();
            int dot = name.lastIndexOf(46);
            if (dot != -1) {
                return name.substring(dot + 1);
            }
            return name;
        }

        public String getPrefix() {
            return FileUtil.removeSuffix(this.getName());
        }

        public abstract InputStream read() throws IOException;

        public abstract OutputStream write() throws IOException;

        public byte[] readBytes() throws IOException {
            return IOUtil.inputStreamToBytes(this.read());
        }

        public void writeBytes(byte[] bytes) throws IOException {
            OutputStream out = this.write();
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            IOUtil.pipe(in, out);
        }
    }

    public static interface Filter {
        public boolean accept(Entry var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Folder
    extends FileContainer {
        final File top;

        public Folder(File top) {
            this.top = top;
        }

        @Override
        public Iterable<ebuild.util.file.FileContainer$Entry> list(Filter filter) {
            Collection<String> ps = FileUtil.deepList(this.top);
            ArrayList<ebuild.util.file.FileContainer$Entry> r = new ArrayList<ebuild.util.file.FileContainer$Entry>(ps.size());
            for (String p : ps) {
                File f = new File(this.top, p);
                Entry e = new Entry(f, p);
                if (!filter.accept(e)) continue;
                r.add(e);
            }
            return r;
        }

        @Override
        public ebuild.util.file.FileContainer$Entry newEntry(String path) {
            return new Entry(new File(this.top, path), path);
        }

        public class Entry
        extends ebuild.util.file.FileContainer$Entry {
            final File file;
            final String path;

            Entry(File file, String path) {
                this.file = file;
                this.path = path;
            }

            public String getPath() {
                return this.path;
            }

            public InputStream read() throws IOException {
                return new FileInputStream(this.file);
            }

            public OutputStream write() throws IOException {
                FileUtil.mkdirOrFail(this.file.getParentFile());
                return new FileOutputStream(this.file);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZipRead
    extends FileContainer {
        final ZipFile archive;

        public ZipRead(File archiveFile) throws IOException {
            this(new ZipFile(archiveFile));
        }

        public ZipRead(ZipFile archive) {
            this.archive = archive;
        }

        private Error writeError() {
            return new Error(String.valueOf(this.getClass().getSimpleName()) + " read only!");
        }

        @Override
        public Iterable<ebuild.util.file.FileContainer$Entry> list(Filter filter) {
            ArrayList<ebuild.util.file.FileContainer$Entry> r = new ArrayList<ebuild.util.file.FileContainer$Entry>(this.archive.size());
            Enumeration<? extends ZipEntry> zes = this.archive.entries();
            while (zes.hasMoreElements()) {
                ZipEntry ze = zes.nextElement();
                Entry e = new Entry(ze);
                if (!filter.accept(e)) continue;
                r.add(e);
            }
            return r;
        }

        @Override
        public ebuild.util.file.FileContainer$Entry newEntry(String path) {
            throw this.writeError();
        }

        public class Entry
        extends ebuild.util.file.FileContainer$Entry {
            final ZipEntry zipEntry;

            public Entry(ZipEntry zipEntry) {
                this.zipEntry = zipEntry;
            }

            public String getPath() {
                return this.zipEntry.getName();
            }

            public InputStream read() throws IOException {
                return ZipRead.this.archive.getInputStream(this.zipEntry);
            }

            public OutputStream write() throws IOException {
                throw ZipRead.this.writeError();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZipWrite
    extends FileContainer {
        final ZipOutputStream zout;

        public ZipWrite(File archiveFile) throws IOException {
            this(new ZipOutputStream(new FileOutputStream(archiveFile)));
        }

        public ZipWrite(ZipOutputStream out) {
            this.zout = out;
        }

        private Error readError() {
            return new Error(String.valueOf(this.getClass().getSimpleName()) + " write only!");
        }

        @Override
        public Iterable<ebuild.util.file.FileContainer$Entry> list(Filter filter) {
            throw this.readError();
        }

        @Override
        public ebuild.util.file.FileContainer$Entry newEntry(String path) throws IOException {
            ZipEntry e = new ZipEntry(path);
            this.zout.putNextEntry(e);
            return new Entry(e);
        }

        @Override
        public void close() throws IOException {
            this.zout.close();
        }

        public class Entry
        extends ebuild.util.file.FileContainer$Entry {
            final ZipEntry zipEntry;

            public Entry(ZipEntry zipEntry) {
                this.zipEntry = zipEntry;
            }

            public String getPath() {
                return this.zipEntry.getName();
            }

            public InputStream read() throws IOException {
                throw ZipWrite.this.readError();
            }

            public OutputStream write() throws IOException {
                return new FilterOutputStream(ZipWrite.this.zout){

                    public void close() throws IOException {
                        this.flush();
                        ((Entry)Entry.this).ZipWrite.this.zout.closeEntry();
                    }
                };
            }
        }
    }
}

