/*
 * Decompiled with CFR 0.152.
 */
package ebuild.base;

import ebuild.api.log.ILogger;
import ebuild.base.Backtrace;
import ebuild.base.EBuildException;

public class Task {
    private static final ThreadLocal<Task> threadLocal = new ThreadLocal();
    public final ILogger logger;
    final Backtrace backtrace;
    final Task parent;

    public static Task get() {
        return threadLocal.get();
    }

    public static Task expect() {
        Task r = Task.get();
        if (r == null) {
            throw new Error("Not in task!");
        }
        return r;
    }

    public static Task start(String verb, Object key) throws EBuildException {
        return Task.start(verb, key, null);
    }

    public static Task start(String verb, Object key, ILogger logger) throws EBuildException {
        Task parent = Task.get();
        Task task = new Task(parent, logger);
        threadLocal.set(task);
        task.backtrace.start_(verb, key, true);
        return task;
    }

    public static void end(Object key) {
        Task task = Task.expect();
        Task parent = task.parent;
        task.backtrace.end_(key);
        threadLocal.set(parent);
    }

    private Task(Task parent, ILogger logger) {
        this.parent = parent;
        this.backtrace = new Backtrace(this);
        this.logger = logger;
    }

    public String toString() {
        return this.backtrace.toString();
    }
}

