/*
 * Decompiled with CFR 0.152.
 */
package ebuild.compat;

import ebuild.util.StringUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderSignature {
    public final Set<String> inputs;
    public final Set<String> outputs;

    public BuilderSignature(Set<String> inputs, Set<String> outputs) {
        this.inputs = inputs;
        this.outputs = outputs;
    }

    public BuilderSignature bind(Map<String, String> vars) {
        return new BuilderSignature(this.bind(vars, this.inputs), this.bind(vars, this.outputs));
    }

    private Set<String> bind(Map<String, String> vars, Set<String> set) {
        if (set == null) {
            return null;
        }
        HashSet<String> r = new HashSet<String>(set.size());
        for (String s : set) {
            for (String vname : vars.keySet()) {
                String vval = vars.get(vname);
                String vstring = "${" + vname + "}";
                s = s.replace(vstring, vval);
            }
            r.add(s);
        }
        return r;
    }

    public String toString() {
        return "inputs:  " + StringUtil.join(",", this.inputs) + "\n" + "outputs: " + StringUtil.join(",", this.outputs);
    }
}

