/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.base.EBuildException;
import ebuild.base.EBuildLogger;
import ebuild.base.Task;
import ebuild.core.Action;
import ebuild.core.ActionQueue;
import ebuild.core.ActionStatus;
import ebuild.core.BuildPlan;
import ebuild.core.EBuild;
import ebuild.core.impl.BuildTask;
import ebuild.core.impl.BuildTaskSet;
import ebuild.util.StringUtil;

public abstract class BuildPlanRunner {
    protected abstract EBuild getEBuild();

    protected EBuildLogger getLogger() {
        return this.getEBuild().logger;
    }

    public abstract String getKey();

    public abstract void go() throws Exception;

    protected void log(String msg) {
        this.getLogger().log(msg);
    }

    protected void loge(String msg) {
        String[] stringArray = msg.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.getLogger().log("!! " + s);
            ++n2;
        }
    }

    public void go(BuildPlan mainPlan, BuildTask task) throws Exception {
        BuildTaskSet tasks = new BuildTaskSet(task);
        this.log("");
        this.log("");
        this.log("////////////////////////////////////");
        this.log("////// Resolve And Configure ///////");
        this.log("");
        this.resolveAndConfigure(mainPlan, tasks);
        this.log("");
        this.log("");
        this.log("////////////////////////////");
        this.log("////// Plan Task List //////");
        this.log("");
        this.buildActionList(mainPlan, tasks);
        this.log("");
        this.log("");
        this.log("//////////////////////////");
        this.log("////// Execute Plan //////");
        this.log("");
        this.run(this.getEBuild().queue);
    }

    protected void resolveAndConfigure(BuildPlan mainPlan, BuildTaskSet tasks) throws EBuildException {
        mainPlan.resolveAndConfigure(tasks);
        if (this.getEBuild().isDEBUG()) {
            this.log("");
            this.log("Build Plans");
            for (Object k : this.getEBuild().buildPlans.keySet()) {
                this.log("  " + k);
            }
        }
    }

    private int taskNoDigitsRequired() {
        int n = this.getEBuild().queue.size();
        int digits = 1;
        while (n > 10) {
            ++digits;
            n /= 10;
        }
        return digits;
    }

    protected void buildActionList(BuildPlan mainPlan, BuildTaskSet tasks) throws Exception {
        String key = this.getKey();
        ActionQueue queue = this.getEBuild().queue;
        Task.start("plan actions", key);
        try {
            mainPlan.buildActionList(queue, tasks);
        }
        finally {
            Task.end(key);
        }
        queue.removeDuplicates();
        int i = 1;
        int digits = this.taskNoDigitsRequired();
        for (Action a : queue) {
            a.index = i++;
            this.log(String.valueOf(a.formatNumber(digits)) + " - queued " + StringUtil.rpad(7, a.getStatus().displayString()) + " " + a.format());
        }
    }

    protected void run(ActionQueue queue) throws Exception {
        int digits = this.taskNoDigitsRequired();
        for (Action action : queue) {
            boolean skipping = action.getStatus() == ActionStatus.done && !this.getEBuild().options.noSkipping;
            String verb = skipping ? "skipping" : "executing";
            this.log(String.valueOf(action.formatNumber(digits)) + " - " + verb + "  " + action + " -");
            this.getLogger().setProvisionalHeading("\n");
            if (!skipping) {
                action.run(this.getLogger());
            }
            action.finish(skipping);
            this.getLogger().setProvisionalHeading(null);
        }
    }
}

