/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.plugin.AbstractBuilder;
import ebuild.api.plugin.IPropertyMap;
import ebuild.base.EBuildException;
import ebuild.compat.BuilderSignature;
import ebuild.core.BuildPluginDef;
import ebuild.core.BuilderInstance;
import ebuild.core.Module;
import ebuild.core.ModuleC;
import ebuild.core.conf.ConfMap;
import ebuild.core.conf.ConfMapping;
import ebuild.core.impl.ConfKey;
import ebuild.xml.CmnXml;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderDef
extends BuildPluginDef {
    final BuilderSignature signature;

    public BuilderDef(Module module, ConfMapping mapping, BuilderSignature signature, List<CmnXml.Property> props) {
        this(null, module, mapping, signature, props);
    }

    public BuilderDef(BuilderDef prototype, ConfMapping mapping, List<CmnXml.Property> props) {
        this(prototype, prototype.module, mapping, prototype.signature, props);
    }

    private BuilderDef(BuilderDef prototype, Module module, ConfMapping mapping, BuilderSignature signature, List<CmnXml.Property> props) {
        super(prototype, module, mapping, props);
        this.signature = signature;
    }

    public BuilderInstance instantiate(ConfMap inputConf, Set<String> inputs) throws EBuildException {
        BuilderSignature signature = new BuilderSignature(inputs, this.signature.outputs);
        return this.instantiate(inputConf, signature);
    }

    public BuilderInstance instantiate(ConfMap contextConf) throws EBuildException {
        return this.instantiate(contextConf, this.signature);
    }

    private BuilderInstance instantiate(ConfMap contextConf, BuilderSignature signatureDef) throws EBuildException {
        ConfMap pluginConf = this.evaluateMapping(contextConf);
        BuilderSignature signature = signatureDef.bind(pluginConf.asMap());
        ModuleC moduleC = this.module.getCPart(new ConfKey(pluginConf));
        AbstractBuilder builder = moduleC.asBuilder();
        IPropertyMap propsC = builder.newPropertyMap();
        this.configureProps(propsC, contextConf, pluginConf);
        return new BuilderInstance(moduleC, builder, signature, propsC);
    }

    @Override
    public BuilderDef clone(ConfMapping mapping, List<CmnXml.Property> propertiesList) {
        return new BuilderDef(this, mapping, propertiesList);
    }
}

