/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.base.EBuildException;
import ebuild.base.MetaType;
import ebuild.core.ElementBuildMeta;
import ebuild.core.MetaDir;
import ebuild.core.conf.ConfMap;
import ebuild.core.impl.ConfKey;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.Exclude;
import ebuild.core.impl.KeyC;
import ebuild.core.impl.KeyE;
import ebuild.xml.CmnXml;
import ebuild.xml.PrdXml;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductBuildMeta
extends ElementBuildMeta {
    public ProductBuildMeta(MetaDir dir) {
        super(dir);
    }

    @Override
    public void check() throws EBuildException {
    }

    @Override
    public MetaType getMetaType() {
        return MetaType.PRODUCT_ASSEMBLY;
    }

    public Map<String, ModuleSelection> getModuleSelections(final KeyC key) throws EBuildException {
        ConfMap conf = key.subkey.conf;
        final HashMap<String, ModuleSelection> r = new HashMap<String, ModuleSelection>();
        new AssemblyVisitor(conf){

            public Object visitModuleSelection(String path, PrdXml.ModuleSelection moduleSelectionXml) {
                String groupConfMapping = moduleSelectionXml.confMapping;
                List<PrdXml.Include> includes = moduleSelectionXml.includes;
                PrdXml.OurModule ours = moduleSelectionXml.ourModule;
                Exclude excludes = Exclude.newExclude(moduleSelectionXml.excludes);
                if (ours != null) {
                    String confMapping = ours.confMapping;
                    if (confMapping == null) {
                        confMapping = "->*";
                    }
                    KeyE keye = key.ekey;
                    PrdXml.Include inc = new PrdXml.Include();
                    inc.source = "local";
                    inc.org = keye.org;
                    inc.name = keye.name;
                    inc.conf = ours.conf;
                    inc.confMapping = confMapping;
                    inc.revision = keye.version.getRevision();
                    inc.branch = keye.version.getBranch();
                    inc.tag = keye.version.getTag();
                    inc.dependencies = ours.dependencies;
                    ArrayList<PrdXml.Include> l2 = new ArrayList<PrdXml.Include>(includes.size() + 1);
                    l2.addAll(includes);
                    l2.add(inc);
                    includes = l2;
                }
                ModuleSelection msi = new ModuleSelection(moduleSelectionXml.artifact, groupConfMapping, includes, excludes);
                r.put(path, msi);
                return null;
            }
        }.goAll();
        return r;
    }

    public Map<String, PrdXml.Product> getSelectedComponentsXml(ConfKey subKey) throws EBuildException {
        final HashMap<String, PrdXml.Product> r = new HashMap<String, PrdXml.Product>();
        new AssemblyVisitor(subKey.conf){

            Object visitProduct(String path, PrdXml.Product component) {
                r.put(path, component);
                return null;
            }
        }.goAll();
        return r;
    }

    @Override
    public PrdXml.EbuildProductAssembly expectBuildXml() {
        return (PrdXml.EbuildProductAssembly)super.expectBuildXml();
    }

    public List<PrdXml.Target> getTargetsXml() throws EBuildException {
        return this.expectBuildXml().targets;
    }

    public Iterable<CmnXml.SelectWithSource> getMainDependencies() throws EBuildException {
        final ArrayList<CmnXml.SelectWithSource> r = new ArrayList<CmnXml.SelectWithSource>();
        new AssemblyVisitor(null){

            public Object visitProduct(String path, PrdXml.Product component) throws EBuildException {
                return r.add(component);
            }

            public Object visitModuleSelection(String path, PrdXml.ModuleSelection moduleSelection) throws EBuildException {
                return r.addAll(moduleSelection.includes);
            }
        }.goAll();
        return r;
    }

    public Map<Object, ? extends PrdXml.Assembler> getBuildDependencies(ConfKey subKey) throws EBuildException {
        final HashMap map = new HashMap(10);
        new AssemblyVisitor(subKey == null ? null : subKey.conf){

            public Object visitAssembler(String path, PrdXml.Assembler assembler, Map inputs) {
                map.put(path, assembler);
                return null;
            }
        }.goAll();
        return map;
    }

    PrdXml.Target expectTarget(String target) throws EBuildException {
        for (PrdXml.Target t : this.getTargetsXml()) {
            if (!target.equals(t.name)) continue;
            return t;
        }
        throw EBuildException.newConfProblem("Bad reference, no <target> for ref: " + target);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AssemblyVisitor<R> {
        final ConfMap configuration;
        Map<String, R> norecurse = new HashMap<String, R>();

        AssemblyVisitor() {
            this(null);
        }

        AssemblyVisitor(ConfMap configuration) {
            this.configuration = configuration;
        }

        boolean hasConfiguration() {
            return this.configuration != null;
        }

        void goAll() throws EBuildException {
            for (PrdXml.Target t : ProductBuildMeta.this.getTargetsXml()) {
                this.go(t.name);
            }
        }

        R go(String target) throws EBuildException {
            return this.recurseNamed(target);
        }

        R visitProduct(String path, PrdXml.Product component) throws EBuildException {
            return null;
        }

        R visitModuleSelection(String path, PrdXml.ModuleSelection moduleSelection) throws EBuildException {
            return null;
        }

        R visitAssembler(String path, PrdXml.Assembler assembler, Map<String, R> inputs) throws EBuildException {
            return null;
        }

        R visitGroup(String path, PrdXml.AssemblyGroup group, List<R> members) throws EBuildException {
            return null;
        }

        R recurseNamed(String name) throws EBuildException {
            if (this.norecurse.containsKey(name)) {
                return this.norecurse.get(name);
            }
            R r = this.recurseGroup(name, ProductBuildMeta.this.expectTarget(name));
            this.norecurse.put(name, r);
            return r;
        }

        private String subpath(int size, String path, int i) {
            if (size == 1) {
                return path;
            }
            return String.valueOf(path) + "_" + i;
        }

        R recurseGroup(String path, PrdXml.AssemblyGroup group) throws EBuildException {
            return this.visitGroup(path, group, this.recurseGroupMembers(path, group));
        }

        List<R> recurseGroupMembers(String path, PrdXml.AssemblyGroup group) throws EBuildException {
            String path2;
            int size = group.count();
            ArrayList<R> r = new ArrayList<R>(size);
            int i = 0;
            if (group.ref != null) {
                ++i;
                r.add(this.recurseNamed(group.ref));
            }
            for (PrdXml.Ref ref : group.refs) {
                ++i;
                r.add(this.recurseNamed(ref.name));
            }
            for (PrdXml.Assembler ass : group.assemblers) {
                path2 = this.subpath(size, path, i++);
                r.add(this.visitAssembler(path2, ass, this.recurseInputs(path2, ass.inputList)));
            }
            for (PrdXml.Product c : group.products) {
                if (this.hasConfiguration()) {
                    if (EBuildUtil.evaluateExpr(c.conf, this.configuration)) {
                        r.add(this.visitProduct(this.subpath(size, path, i), c));
                    }
                } else {
                    r.add(this.visitProduct(this.subpath(size, path, i), c));
                }
                ++i;
            }
            for (PrdXml.ModuleSelection ms : group.moduleSelections) {
                r.add(this.visitModuleSelection(this.subpath(size, path, i++), ms));
            }
            for (PrdXml.If if_ : group.ifs) {
                path2 = this.subpath(size, path, i++);
                r.add(this.recurseIf(path2, if_));
            }
            return r;
        }

        Map<String, R> recurseInputs(String path, List<PrdXml.Input> inputs) throws EBuildException {
            LinkedHashMap<String, R> r = new LinkedHashMap<String, R>(inputs.size());
            for (PrdXml.Input i : inputs) {
                String name;
                String path2 = i.appendToPath(path);
                R a = this.recurseGroup(path2, i);
                String string = name = i.name == null ? "anonymous" : i.name;
                if (r.containsKey(name)) {
                    throw EBuildException.newConfProblem("Multiple inputs must have distinct names: " + name);
                }
                r.put(i.name, a);
            }
            return r;
        }

        R recurseIf(String path, PrdXml.If if_) throws EBuildException {
            if (this.hasConfiguration()) {
                if (EBuildUtil.evaluateExpr(if_.cond, this.configuration)) {
                    return this.recurseGroup(String.valueOf(path) + "_then", if_.then);
                }
                return this.recurseGroup(String.valueOf(path) + "_else", if_.else_);
            }
            this.recurseGroup(String.valueOf(path) + "_then", if_.then);
            this.recurseGroup(String.valueOf(path) + "_else", if_.else_);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ModuleSelection {
        final String artifact;
        final String groupMapping;
        final List<PrdXml.Include> includes;
        final Exclude excludes;

        ModuleSelection(String artifact, String groupMapping, List<PrdXml.Include> includes, Exclude excludes) {
            this.artifact = artifact;
            this.groupMapping = groupMapping;
            this.includes = includes;
            this.excludes = excludes;
        }
    }
}

